import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "Create Next App",
  description: "Generated by create next app",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body>
        <header>
          <nav>
            <ul style={{ display: "flex", listStyle: "none", gap: "1rem" }}>
              <li>
                <a href="/server">Server</a>
              </li>
              <li>
                <a href="/client">Client</a>
              </li>
            </ul>
          </nav>
        </header>
        <main style={{ padding: "0 2.25rem" }}>{children}</main>
      </body>
    </html>
  );
}
