/**
 * Creates tooltips to be used in the ToolTipView.
 *
 * Copyright (C) 2024 Scribe
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

import Foundation

struct ToolTipViewDatasource: ToolTipViewDatasourceable {
  var theme: ViewThemeable
  private var content: NSMutableAttributedString

  // MARK: Init

  init(content: NSMutableAttributedString, theme: ViewThemeable) {
    self.content = content
    self.theme = theme
  }

  func getCurrentText() -> NSMutableAttributedString {
    content
  }
}
