# Contributing to sciencefair

We'd love you to contribute to sciencefair and make it more useful.

Here are some guidelines to help you engage and contribute:

   * [Code of conduct](#conduct)
   * [Getting help](#help)
   * [Issues and bugs](#issue)
   * [Feature requests](#feature)
   * [Contributing code](#contribute)

## <a name = "conduct"/>Code of conduct

Help us keep sciencefair open and inclusive. Please read and follow our [Code of Conduct](CODE_OF_CONDUCT.md).

## <a name = "help"/>Getting help

If you have questions about how to use sciencefair, we're available on [gitter](https://gitter.im/codeforscience/community).

## <a name = "issue"/>Found an issue?

If you find a mistake in the source code or documentation, you can help us by submitting an issue to our [GitHub issue tracker](https://github.com/codeforscience/sciencefair/issues).

Please take a look at the following guidelines before creating a new issue.

1. Have you searched the issue archive to see if your question has already been answered or reported?

2. If your issue appears to be a bug, and hasn't been reported, open a new issue. Help us to deal with issues efficiently by providing the following information:
   * __Overview of the issue__ - including error messages / stack trace if an error is being thrown
   * __Motivation / Use Case__ - explain why this is an issue for you
   * __Version__ - which version of sciencefair are you using?
   * __Operating System__ - what version are you using?
   * __Node and npm versions__ - it may also be useful to include the output of `npm list`
   * __Related issues__ - has a similar issue been reported before?
   * __Suggest a fix__ - if you can't fix the bug yourself, perhaps you can point to what might be causing the problem (line of code or commit)

3. If you can fix the issue yourself, create a Pull Request!

## <a name = "feature"/>Want a feature?

You can request a new feature by submitting an issue to our GitHub Repository. It's very helpful if you can include a motivation / use case.

## <a name = "contribute"/>Want to contribute?

Contributions are very welcome. Take a look at the [current issues and feature requests](https://github.com/codeforscience/sciencefair/issues). Add a comment to an existing issue to mention that you plan to work on it.

If you'd like to implement a new feature, please open an issue to discuss any changes you would like to Pull Request. If the feature is likely to require major changes, please discuss it first on our [gitter](https://gitter.im/codeforscience/community) so that we can better coordinate our efforts, prevent duplication of work, and help you to craft the change so that it is successfully accepted into the project.
