# Code of conduct

The open science and open source communities are made up of a mixture of professionals and volunteers from all over the world. Diversity is one of our huge strengths, but it can also lead to communication issues and unhappiness.

Here at Code For Science, we have a few ground rules that we ask people to adhere to. This code applies equally to founders, contributors and those seeking help and guidance.

This isn’t an exhaustive list of things that you can’t do. Rather, take it in the spirit in which it’s intended - a guide to make it easier to enrich all of us and the communities in which we participate.

This code of conduct applies to all spaces managed by the Code For Science initiative. This includes gitter, the mailing lists, the issue tracker, repositories, and any other forums created by the project team which the community uses for communication such as Skype, Google Hangouts, etc. In addition, violations of this code outside these spaces may affect a person's ability to participate within them.

If you believe someone is violating the code of conduct, we ask that you report it by contacting the [Code For Science Team](https://github.com/orgs/codeforscience/people) collectively. For more details please see our [Reporting Guidelines](#reporting).

## Be welcoming, friendly and patient.

Be welcoming. As an inherently open community, we strive to welcome and support people of all backgrounds and identities. This includes, but is not limited to members of any race, ethnicity, culture, national origin, colour, immigration status, social and economic class, educational level, sex, sexual orientation, gender identity and expression, age, size, family status, political belief, religion, and mental and physical ability.

## Be considerate.

Your work will be used by other people, and you in turn will depend on the work of others. Any decision you take will affect users and colleagues, and you should take those consequences into account when making decisions. Remember that we're a world-wide community, so you might not be communicating in someone else's primary language.

## Be respectful.

Not all of us will agree all the time, but disagreement is no excuse for poor behavior and poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It’s important to remember that a community where people feel uncomfortable or threatened is not a productive one. Members of the Code For Science community should be respectful when dealing with other members as well as with people outside the Code For Science community.

## Be careful in the words that you choose.

We are a community of professionals, and we conduct ourselves professionally. Be kind to others. Do not insult or put down other participants. Harassment and other exclusionary behavior aren't acceptable. This includes, but is not limited to:
   * Violent threats or language directed against another person.
   * Discriminatory jokes and language.
   * Posting sexually explicit or violent material.
   * Posting (or threatening to post) other people's personally identifying information ("doxing").
   * Personal insults, especially those using racist or sexist terms.
   * Unwelcome sexual attention.
   * Advocating for, or encouraging, any of the above behavior.
   * Repeated harassment of others. In general, if someone asks you to stop, then stop.

When we disagree, try to understand why. Disagreements, both social and technical, happen all the time and this community is no exception. It is important that we resolve disagreements and differing views constructively. Different people have different perspectives on issues. Being unable to understand why someone holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that it is human to err and blaming each other doesn’t get us anywhere. Instead, focus on helping to resolve issues and learning from mistakes.

# <a name="reporting">Reporting Guidelines</a>

If you believe someone is violating the code of conduct we ask that you report it to the Code For Science team by emailing conduct@codeforscience.com. All reports will be kept confidential. In some cases we may determine that a public statement will need to be made. If that's the case, the identities of all victims and reporters will remain confidential unless those individuals instruct us otherwise.

If you believe anyone is in physical danger, please notify appropriate law enforcement first. If you are unsure what law enforcement agency is appropriate, please include this in your report and we will attempt to notify them.

In your report please include:

* Your contact info (so we can get in touch with you if we need to follow up)
* Names (real, nicknames, or pseudonyms) of any individuals involved. If there were other witnesses besides you, please try to include them as well.
* When and where the incident occurred. Please be as specific as possible.
* Your account of what occurred. If there is a publicly available record (e.g. a mailing list archive or a public IRC logger) please include a link.
* Any extra context you believe existed for the incident.
* If you believe this incident is ongoing.
* Any other information you believe we should have.

If your report is concerning a member of the Code For Science team, and you do not wish them to see the report, you may escalate your report by emiting it directly to the independent arbiter, Mozilla Science Lab.

## What happens after you file a report?

We promise to acknowledge receipt within 24 hours (and will aim for much quicker than that).

The Code For Science team will immediately meet to review the incident and determine:

* What happened.
* Whether this event constitutes a code of conduct violation.
* Who the bad actor was.
* Whether this is an ongoing situation, or if there is a threat to anyone's physical safety.
* If this is determined to be an ongoing incident or a threat to physical safety, the working groups' immediate priority will be to protect everyone involved. This means we may delay an "official" response until we believe that the situation has ended and that everyone is physically safe.

Once the team has a complete account of the events they will make a decision as to how to response. Responses may include:

* Nothing (if we determine no violation occurred).
* A private reprimand from the working group to the individual(s) involved.
* A public reprimand.
* An imposed vacation (i.e. asking someone to "take a week off" from a mailing list or IRC).
* A permanent or temporary ban from some or all spaces (mailing lists, gitter, etc.)
* A request for a public or private apology.

We'll respond within one week to the person who filed the report with either a resolution or an explanation of why the situation is not yet resolved.

Once we've determined our final action, we'll contact the original reporter to let them know what action (if any) we'll be taking. We'll take into account feedback from the reporter on the appropriateness of our response, but we don't guarantee we'll act on it.

Finally, the team may choose to a public report of the incident.

## Appealing

Only permanent resolutions (such as bans) may be appealed. To appeal a decision of the working group, please contact the Code For Science team at conduct@codeforscience.com who will escalate this to our independent arbiter, Mozilla Science Lab to review the case.


This Code of Conduct is based on the CoC's from the [Django](https://www.djangoproject.com/conduct/) and [Speak Up!](https://web.archive.org/web/20141205224353/http://speakup.io/coc.html) projects and following [guidance from the Ada Initiative](https://adainitiative.org/2014/02/18/howto-design-a-code-of-conduct-for-your-community/).
