+++
date = "2017-03-31"
title = "Utiliser les cartes"
+++

<ul class="contents">
	<li><a href="#trouver-les-cartes">Trouver les cartes</a></li>
	<li><a href="#explorer-les-cartes">Explorer les cartes</a></li>
	<li><a href="#télécharger-les-cartes">Télécharger les cartes</a></li>
	<li><a href="#recherche-avancée">Recherche avancée</a></li>
</ul>

[Scholars GeoPortal](http://geo.scholarsportal.info/#_lang=fr) est un géoportail en ligne permettant aux utilisateurs de trouver et de télécharger des cartes et des données géospatiales. En utilisation GeoPortal et l’index de navigation de cartes intégré, les utilisateurs peuvent voir la disponibilité des cartes par emplacement et ajouter des cartes au visualiseur de cartes pour découvrir tout cela en ligne. GeoPortal contient également des caractéristiques permettant de superposer plusieurs cartes et d’inclure d’autres données pour voir les changements au fil du temps. Les cartes peuvent être téléchargées pour tout usage et sont disponibles en format GeoTIFF ou JPG. Suivez les étapes ci-dessous pour en savoir plus au sujet de l’accès et de l’utilisation de la collection dans GeoPortal.

Pour rechercher des cartes par nom de lieu sans entrer dans GeoPortal, allez à [_Collection au complet_](../collection/).

## Trouver les cartes

### Utiliser l’index

La première étape pour accéder à la collection des cartes topographiques historiques est de trouver et d’utiliser l’index de navigation. Il existe deux ensembles de collections de cartes topographiques dans Scholars GeoPortal, contenant chacun leur propre index de navigation, un pour chaque série de cartes 1:63,360 et 1:25,000. En utilisant l'index de navigation, vous pouvez voir la disponibilité des cartes en choisissant la zone d’intérêt trouvée sur la carte.

Dans Scholars GeoPortal, les cartes sont disponibles par le biais d’un affichage d’index interactif en ligne. Pour accéder aux index de la carte pour différentes échelles de cartes, allez directement au Scholars GeoPortal :

- [Index de navigation pour 1:63 360](http://geo.scholarsportal.info/#r/details/_uri@=564032357&_add:true)
- [Index de navigation pour 1:25 000](http://geo.scholarsportal.info/#r/details/_uri@=847590539&_add:true) 

 Vous devriez maintenant vous retrouver dans l’index de navigation pour sélectionner les cartes qui vous intéressent.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-3-FR.PNG" alt="Capture d’écran de l’index de la carte 1:63,360 chargé sur le visualiseur de cartes dans Scholars GeoPortal.">

### Choisir les cartes

Quand l’index de navigation apparaît avec plusieurs cellules rectangulaires, cliquez sur la zone d’intérêt pour voir les cartes disponibles. Une liste de cartes, en rapport avec la zone sélectionnée, apparaîtra à gauche de l’écran. Chaque résultat représente des cartes individuelles [éditions] dans la collection.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-4-FR.PNG" alt="Capture d’écran des résultats d’une recherche dans GeoPortal après avoir sélectionné une cellule de grille à partir de la carte-index.">

Tout comme pour les autres ensembles de données dans GeoPortal, dès que l’index de navigation de cartes est activé vous pouvez utiliser l’outil panoramique et le zoom pour voir les zones de la carte qui sont disponibles. L’index affiche le numérotage du Système national de référence cartographique (SNRC). Il s’agit de chiffres normalisés de feuilles de cartes, affichés au centre des cellules de grille de l’index pour faciliter l’identification.

**Astuces** : La cellule choisie reste surlignée et indique ce que vous avez choisi jusqu’à ce que vous cliquiez encore une fois ou sélectionniez une autre zone.

Une mini-carte apparaîtra en bas à droite pour vous permettre de savoir où vous êtes sur la carte, même quand vous zoomez en avant. Si vous désirez la minimiser, cliquez tout simplement sur la flèche du bas située en bas à droite.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-5.PNG" alt="Capture d’écran de la mini-carte. Elle apparaît en bas à droite du visualiseur du GeoPortal.">

### Trouver l’index dans GeoPortal

Vous pouvez trouver les index en effectuant une recherche pour « _Index topographique historique_ » dans le principal champ de recherche.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-6-FR.PNG" alt="Capture d’écran du champ de recherche contenant les mots « Index topographique historique ».">

Si vous avez déjà vu une feuille de carte dans Scholars GeoPortal, vous pouvez retourner à l’index en tout temps en cliquant sur Afficher la carte d’index à partir du registre de métadonnées.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-7-FR.PNG" alt="Capture d’écran d’un registre de métadonnées pour « Brampton, Ontario », avec un lien indiquant « Afficher la carte d’index ».">

## Explorer les cartes

### Voir les Cartes

Après avoir choisi la zone d’intérêt en utilisant l’index de navigation, sélectionnez une carte à partir de la liste de résultats à gauche, puis cliquez sur le bouton _Vue_ pour charger la carte.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-8-FR.PNG" alt="Capture d’écran des résultats d’une recherche pour une feuille de carte de « Port Burwell, Ontario » ; le bouton « Vue » est entouré.">

Cliquez sur le bouton _Vue générale_ après le chargement de la carte pour zoomer et voir la carte de plus près.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-9-FR.PNG" alt="Capture d’écran de la carte chargée sur le visualiseur de carte dans GeoPortal après avoir été choisie à partir des résultats de recherche situés à gauche de l’écran.">

### Utiliser le curseur transparence et le fond de carte

Par défaut, le GeoPortal vous fournit un visualiseur de fond de carte indiquant le contexte actuel et d’autres caractéristiques topographiques sur la surface de la Terre. Vous pouvez changer le fond de carte en tout temps en cliquant sur l’onglet _Cartes de base_ en haut à droite du GeoPortal.

La galerie du fond de carte apparaît et vous pouvez choisir parmi plusieurs options.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-10-FR.PNG" alt="Capture d’écran de la galerie de cartes de base du GeoPortal.">

Vous pouvez régler la transparence de la carte pour la comparer avec le carte de base et voir les changements au fil du temps. Pour régler la transparence sur la carte, cliquez sur l’onglet Carte à partir du principal champ de recherche. À partir de là, vous pouvez voir une liste de cartes qui se chargent sur le visualiseur de carte.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-11-FR.PNG" alt="Capture d’écran de l’onglet « Carte » dans le GeoPortal ; le curseur transparence est entouré.">

En utilisant la barre du curseur transparence, vous pouvez régler la transparence de la couche supérieure, révélant ainsi la couche inférieure. Vous pouvez faire cela en superposant plusieurs cartes.

Si vous désirez réarranger les cartes pour qu’une soit au-dessus de l’autre, cliquez tout simplement sur une carte en-dessous de l’onglet _Carte_, puis faites-la glisser vers la position souhaitée. Veuillez noter que la carte-index sera toujours présente sur la liste et doit rester en haut de la liste pour reprendre le mode d’index de navigation.

### Voir et superposer plusieurs cartes

Dépendamment de la cellule d’index que vous avez choisie, il peut y avoir plus d’une carte disponible pour une zone spécifique. Elles sont souvent référées comme des éditions. Suivez les étapes suivantes pour voir plusieurs cartes en même temps en utilisant le visualiseur :

1. À partir de la liste des résultats, cliquez sur le bouton Vue sur autant de feuilles de carte que vous aimeriez voir apparaître.
2. À partir de l’onglet Carte, vous pouvez réorganiser les cartes selon la manière dont vous aimeriez les voir dans le visualiseur GeoPortal, avec le premier résultat apparaissant en haut. Vous pouvez également utiliser la barre du curseur transparence pour voir les changements au fil du temps sur les éditions des cartes.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-12-FR.PNG" alt="Capture d’écran de l’onglet « Carte » dans le GeoPortal ; le curseur transparence est entouré.">

### En savoir plus sur les cartes – métadonnées et détails

De riches métadonnées ont été créées pour chaque feuille de carte. Elles peuvent être explorées en cliquant sur le bouton _Détails_ associé avec chaque carte. Ce bouton fera apparaître le panneau des métadonnées, indiquant un résumé, une vignette, des documents supplémentaires et plus encore, sur la manière dont la carte numérique a été créée.

**Remarque** : les métadonnées détaillées ne sont disponibles qu'en anglais.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-13-FR.PNG" alt="Capture d’écran du registre des métadonnées pour « Brampton, ON » dans le GeoPortal.">

## Télécharger les cartes

Dès vous avez choisi la carte, vous pouvez la télécharger en format GeoTIFF. Ce format contient des renseignements de géolocalisation inclus dans le fichier pouvant être utilisés dans un Système d’information géographique (SIG). Chaque feuille de carte peut être téléchargée en cliquant sur le bouton Télécharger présent sur la liste des cartes.

Si vous préférez télécharger la carte en format JPG, allez à [_Collection au complet_](../collection/) et cliquez sur l’option _Télécharger_ à côté de la carte concernée.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-14-FR.PNG" alt="Capture d’écran des résultats d’une recherche pour les cartes de Toronto ; le bouton « Télécharger » est entouré.">

**Lien rapide :** [Toronto, Ontario. 1:63,360. Feuille de carte 030M11, [ed. 1], 1909](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K030M11_1909TIFF&_add:true)

Ceci fera apparaître une fenêtre contextuelle. Vous serez obligés de désactiver votre système de blocage de fenêtres contextuelles. (**astuce** : vous pouvez passer outre en cliquant une deuxième fois sur le bouton _Télécharger_)

**Conseils** : Les anciennes cartes sont cool ! Si vous avez téléchargé ces cartes et vous les utilisez d’une manière assez originale, nous aimerions en savoir plus. Veuillez nous [contacter](../contact) et nous dire de quelle manière vous utilisez ces cartes dans vos projets.

## Recherche avancée

**Remarque :** Pour utiliser les options de la recherche avancée et trouver des cartes topographiques historiques dans GeoPortal, vous serez obligés d’utiliser l’index de navigation de cartes en même temps que la recherche. Des détails supplémentaires sont disponibles dans les sections ci-dessous au sujet de l’index de navigation.

### Rechercher par nom de carte ou le numéro SNRC

Si vous connaissez le nom ou le numéro SNRC d’une carte spécifique, vous pouvez effectuer cette recherche avec la collection et en utilisant le principal champ de recherche de GeoPortal.

1. Choisissez _Cartes historiques_ à partir du menu déroulant à côté du champ de recherche.
**Remarque** : Les cartes historiques n’apparaîtront pas dans les résultats de la recherche si _Cartes historiques_ n’est pas sélectionné.
2. Inscrivez un nom ou un numéro SNRC (ex. 030M11) dans le champ de recherche, puis cliquez sur le bouton _Recherche_.
3. Les résultats apparaîtront en-dessous du champ de recherche.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-15-FR.PNG" alt="Capture d’écran du champ de recherche dans GeoPortal avec le mot « Toronto » inscrit et l’option « Cartes historiques » choisie à partir du menu déroulant.">

Si vous n’obtenez aucun résultat avec votre recherche, le nom de la carte peut ne pas correspondre avec le nom de lieu actuel (par exemple : la ville de « Oakville » est sous le nom de « Hamilton »). Si cela se produit, vous pouvez _Rechercher par adresse_ ou _Rechercher par zone_ (voir ci-dessous).

### Rechercher par lieu ou adresse

Si vous connaissez le nom actuel d’un lieu que vous recherchez, vous pouvez rechercher les cartes qui correspondent à cet endroit.

1. Cliquez sur le bouton _Lieu ou adresse_ (au-dessus du champ de recherche).
2. Inscrivez le nom de l’endroit concerné (ex. « exeter, on »)
3. Quand vous cliquez sur le bouton _Recherche_, les résultats montreront les lieux géocodés que l’on peut zoomer sur la carte, en cliquant sur le bouton _Vue générale_.
<br><br><img class="img-responsive using-maps" src="../../img/usingmaps/Figure-16-FR.PNG" alt="Capture d’écran de l’option de recherche « Lieu ou Adresse » dans GeoPortal, avec « Exeter, ON » inscrit, et le bouton vue générale entouré."><br>
4. Dès que vous avez zoomé sur ce lieu, et si ça tombe sur une zone permettant d’avoir une carte topographique historique, vous pouvez cliquer sur l’index de navigation pour voir les feuilles de carte disponibles pour cette zone.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-17.PNG" alt="Capture d’écran des résultats de la recherche « Lieu ou Adresse » dans GeoPortal pour « Exeter, ON ».">

### Rechercher par zone

Il est possible de voir quelles cartes sont disponibles dans une zone donnée sans avoir le nom d’un lieu actuel en tête.

1. Choisissez _Cartes historiques_ à partir du menu déroulant à côté du champ de recherche. Mettez un astérisque (*) dans le champ de recherche.
<br><br><img class="img-responsive using-maps" src="../../img/usingmaps/Figure-18-FR.PNG" alt="Capture d’écran du champ de recherche dans GeoPortal avec un ‘*’ et l’option « Cartes historiques » choisie à partir du menu déroulant."><br>
2. Cliquez sur le signe **+** à côté du champ de recherche. Un nouveau champ de recherche apparaîtra.
3. À partir du menu déroulant, à côté de ce deuxième champ de recherche, choisissez l’option _Inclure Étendue_. Une option _Tracer_ apparaîtra à gauche du menu.
<br><br><img class="img-responsive using-maps" src="../../img/usingmaps/Figure-19-FR.PNG" alt="Capture d’écran du champ de recherche dans GeoPortal avec un ‘*’ et l’option « Cartes historiques » choisie à partir du menu déroulant, ainsi que l’option « Inclure Étendue » en dessous comme option de recherche supplémentaire."><br>
4. Choisissez l’option _Tracer_. Glissez votre curseur au-dessus de la carte pour sélectionner la zone qui vous intéresse, puis cliquez sur le bouton _Recherche_. Les résultats apparaîtront en-dessous du champ de recherche.

<img class="img-responsive using-maps" src="../../img/usingmaps/Figure-20-FR.PNG" alt="Capture d’écran des résultats d’un recherche dans GeoPortal pour une « Recherche par zone » du centre de l’Ontario.">

Si vous désirez en savoir plus sur l’utilisation de Scholars GeoPortal pour accéder à d’autres données/cartes, veuillez vous référer au [Guide de l’utilisateur](https://learn.scholarsportal.info/all-guides/geoportal).
