+++
date = "2017-03-16"
title = "Using the Maps"
+++

<ul class="contents">
	<li><a href="#finding-maps">Finding maps</a></li>
	<li><a href="#exploring-maps">Exploring maps</a></li>
	<li><a href="#downloading-maps">Downloading maps</a></li>
	<li><a href="#advanced-searching">Advanced searching</a></li>
</ul>

[Scholars GeoPortal](http://geo.scholarsportal.info) is an online geoportal that allows users to find and download geospatial data and maps. Using the GeoPortal and the built-in map index navigation, users can view map availability by location, and, add maps to the map viewer to explore online. The GeoPortal also supports features to layer multiple maps, and layer other data to visualize changes over time. Maps can be downloaded for any purpose and available in GeoTIFF or JPG formats. Follow the steps below to learn more about how to access and use the collection in the GeoPortal.

To search for maps directly by place name without entering the GeoPortal, go to [_Full Collection_](../collection/).

## Finding Maps

### Using the index

The first step to accessing the historical topographic map collection is to locate and use the index navigation aid. There are two sets of historical topographic map collections available in the Scholars GeoPortal, each with their own index map for navigation, one for the 1:63,360 and 1:25,000 scale map sets. Using the index navigation, you can view map availability by selecting the area of interest found on the map.

In Scholars GeoPortal, maps are available through an interactive online index display. To access the map indexes for different map scales, go directly to the Scholars GeoPortal:

- [1:63 360 Index Navigation](http://geo.scholarsportal.info/#r/details/_uri@=564032357&_add:true)
- [1:25 000 Index Navigation](http://geo.scholarsportal.info/#r/details/_uri@=847590539&_add:true)

You should now be presented with the index navigation aid to select maps of interest.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-3.PNG" alt="Screen capture of the 1:63,360 index map, loaded on the map viewer in the Scholars GeoPortal.">

### Selecting maps

The index navigation appears with several rectangular cells, click an area of interest to view available maps. A list of maps for that selected area will appear on the left-hand side results list. Each of these represent individual maps [editions] in the collection.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-4.PNG" alt="Screen capture of the results of a search in the GeoPortal after selecting a grid cell from the index map.">

As with using other datasets in the GeoPortal, once the index map navigation is enabled, you can pan and zoom to interactively see the map areas that are available. The index is displaying the National Topographic Series (NTS) numbering, which are standardized map sheet numbers, displayed in the center of the index grid cells for easy identification.

**Tip:** The selected cell remains highlighted indicating where you have selected until you click it again, or select another area.

A mini-map will be displayed in the bottom right corner, allowing you to easily see where you currently are, even when zoomed in. If you want to minimize this, simply click on the downward arrow in the bottom right corner.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-5.PNG" alt="Screen capture of mini-map, which appears in the bottom right hand corner of the geoPortal viewer.">

### Finding the index in the GeoPortal

You can also find the indexes by searching for '_Historical Topographic Index_' in the main search box.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-6.PNG" alt="Screen capture of the search field, with “Historical Topographic Index” entered.">

If you are already viewing a map sheet in the Scholars GeoPortal, you can link back to the index at any time by clicking on _Show Index Map_ from the metadata record.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-7.PNG" alt="Screen capture of a metadata record for 'Brampton, Ontario', with link to 'Show Index Map' circled.">

## Exploring Maps

### View Maps

After you have selected an area of interest using the index navigation, select a map from the left results list, and click the _View_ button to load the map.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-8.PNG" alt="Screen capture of the results of a search for the ‘Port Burwell, Ontario’ map sheet, ‘add’ button circled.">

Click the _Zoom_ button after the map has been loaded to zoom to the map for further exploring.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-9.PNG" alt="Screen capture of a map that has been loaded on the map viewer in the GeoPortal, after being selected from search results in the left hand panel.">

### Using the basemap and transparency slider

By default the GeoPortal provides you with a basemap viewer that shows current landscape and other topographic features on the earth’s surface. You can change the basemap at any time by clicking on the _Base maps_ tab from the upper right corner of the GeoPortal.

The base map gallery appears and you can select from any of the base maps options for display.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-10.PNG" alt="Screen capture of the base map gallery in the GeoPortal.">

You can adjust the transparency of the map in comparison to the basemap to showcase changes over time. To adjust transparency on the map, click on the Map tab from the main search area. From here you will see a list of maps loaded on the map viewer.  

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-11.PNG" alt="Screen capture of the ‘map’ tab in the GeoPortal, transparency slider circled.">

Using the transparency slider bar, you can adjust the transparency of the top layer, revealing the ones beneath. You can do this with multiple overlapping maps.

If you would like to rearrange the maps, so that one is on top of the other, simply click on a map under the _Map_ tab, and drag to the desired position. Please note that the index map will still appear in this listing and must remain on top of the list to resume interacting in the index navigation mode.

### Viewing & overlaying multiple maps

Depending upon which index cell you have selected, there may be more than one map available for a particular area. These are often referred to as editions. To view more than one map at the same time using the viewer:

1. From the map results list, click the _View_ button on as many map sheets as you would like to display.
2. From the _Map_ tab, you can reorder the maps according to how you would like them to be displayed in the GeoPortal viewer, with the first result listed appearing on top. You can use the transparency slider bar to view changes over time on the map editions.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-12.PNG" alt="Screen capture of the ‘map’ tab in the GeoPortal, transparency slider circled.">

### Learning about the maps - metadata & details

Rich metadata has been created for each map sheet which can be explored by clicking the _Details_ button associated with each map. This brings up the metadata pane, showing an abstract, a thumbnail, additional documentation, and more about how the digital map was created.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-13.PNG" alt="Screen capture of the metadata record for ‘Brampton, ON’ in the GeoPortal.">

## Downloading maps

Once you have selected a map, you can download the map as a GeoTIFF, which has geolocation information embedded in the file for use in a Geographic Information System (GIS). If you would prefer to download a JPG of the image, navigate to [_Full Collection_](../collection/) and click the _Download_ option beside the desired map.

Each map sheet can be downloaded by clicking the _Download_ button on the map listing.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-14.PNG" alt="Screen capture of the results of a search for Toronto maps, ‘download’ button circled.">

**Quick link:** [Toronto, Ontario. 1:63,360. Map Sheet 030M11, [ed. 1], 1909](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K030M11_1909TIFF&_add:true)

This will trigger a pop-up and thus might require your browser’s popup blocker to be disabled (clicking the _Download_ button again should overcome this).  

**Tip:** Old maps are cool! If you have downloaded these maps and are using them in an interesting way, we would love to hear from you. Please [contact us](../contact/) and let us know how you are using these maps in your own projects.

## Advanced Searching

**Please note:** to use advanced search options for finding historical topographic maps in the GeoPortal, you may be required to also use the index map navigation in conjunction with searching. More detail is available in the above sections about the index navigation aid.

### Search by Map Name or NTS Sheet Number

If you know the name or NTS number of a particular map, you can search through the collection using the main search field of the GeoPortal.

1. From the drop-down menu beside the search field, select Historical Maps. Note: Historical maps will not show up in the search results if Historical Maps is not selected.
2. Type in a name, or NTS number (ex. 030M11) in the search field, and click the _Search_ button.
3. Results will be displayed below the search field.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-15.PNG" alt="Screen capture of the search field in the GeoPortal, with ‘Toronto’ typed in and ‘Historical Maps’ selected from the drop-down menu to the right.">

If your search returns no results, the map name might not coincide with the current place name for that location (for example, the town of “Oakville” is under the map name “Hamilton”). If this happens, you can _Search by Place of Address_ or _Search by Area_ (see below).

### Search by Place or Address

If you know the current name of the location you are looking for, you can search for maps that cover it.

1. Click the button for _Place or Address_ (above the search field).
2. Enter the location name of interest. E.g “exeter, on”.
3. When you click the _Search_ button, the results show geocoded locations which can be zoomed to on the map, by clicking the _Zoom_ button.
<br><br><img class="img-responsive using-maps" src="../img/usingmaps/Figure-16.PNG" alt="Screen capture of the ‘Place of Address’ search option in the GeoPortal, with ‘Exeter, ON’ typed in, and the ‘zoom’ button circled."><br>
4. Once you zoom into this location, if it falls within a historical topographic map availability area, you can click the index navigation to show the available map sheets for that area.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-17.PNG" alt="Screen capture of the results of a ‘Place of Address’ search in the GeoPortal for ‘Exeter, ON.'">

### Search by Area

It is possible to view what maps are available for a given area without having a current place name in mind.

1. From the drop-down menu beside the search field, select _Historical Maps_. Type in an asterisk (*) in the search field.
<br><br><img class="img-responsive using-maps" src="../img/usingmaps/Figure-18.PNG" alt="Screen capture of the search field in the GeoPortal, with ‘*’ typed in and ‘Historical Maps’ selected from the drop-down menu to the right."><br>
2. Click the plus **+** sign beside the search field. A new search box will appear.
3. From the drop-down menu beside this second search field, select _Include Area_. A _Click & Draw_ option will appear to the left of the menu.
<br><br><img class="img-responsive using-maps" src="../img/usingmaps/Figure-19.PNG" alt="Screen capture of the search field in the GeoPortal, with ‘*’ typed in, ‘Historical Maps’ selected from the drop-down menu to the right, and ‘Include Area’ selected below as an additional search option."><br>
4. Select _Click & Draw_. Drag your cursor over the map to select the area you are interested in, and click the _Search_ button. Results will be displayed below the search field.

<img class="img-responsive using-maps" src="../img/usingmaps/Figure-20.PNG" alt="Screen capture of the results of a search in the GeoPortal for a ‘Search by Area’ of central Ontario.">

If you are interested in learning more about using the Scholars GeoPortal to access other data / maps please refer to [the User Guide](https://learn.scholarsportal.info/all-guides/geoportal).
