+++
date = "2017-03-30"
title = "Collection Highlights"
+++

Topographic maps can provide historical snapshots that allow you to explore changes to an area over time.  Check out the examples below to see how these maps can be used to visualize transforming landscapes, urban areas, and waterways in Ontario.

Old maps are cool! If you are using these maps in an interesting way, we would love to hear from you. Please [contact us](../contact/) and let us know how you are using these maps in your own projects.  

## The Port Lands of Toronto

(areas forming the Don River Delta and Ashbridge’s Bay)

<div class="juxtapose">
    <img src="../img/highlights/030M11_1909.jpg" data-label="1909" />
    <img src="../img/highlights/030M11_1918.jpg" data-label="1918" />
</div>

<div class="row slider-description">
	<p class="col-md-6"><strong>Left</strong>: Early development and Keating Channel (1909-1915)</p>
	<p class="col-md-6"><strong>Right</strong>: Early Land Filling and Shipping Channels (1918)</p>
</div>

### Sources

- [Toronto, Ontario. 1:63,360. Map Sheet 030M11, [ed. 1], 1909](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K030M11_1909TIFF&_add:true)
- [Toronto, Ontario. 1:63, 360. Map Sheet 030M11, [ed. 3], 1918](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K030M11_1918TIFF&_add:true)

<br>

## Urban Growth in the Ottawa area

<div class="juxtapose">
    <img src="../img/highlights/031G05_1908.jpg" data-label="1908" />
    <img src="../img/highlights/031G05_1932.jpg" data-label="1932" />
</div>

<div class="row slider-description">
	<p class="col-md-6"><strong>Left</strong>: Early Urban Development (1908)</p>
	<p class="col-md-6"><strong>Right</strong>: Expansion into the west end, and north of the Rideau River. Significant increase in paved roads (1932).</p>
</div>

### Sources

- [Ottawa, Ontario. 1:63,360. Map Sheet 031G05, [ed. 2], 1908](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K031G05_1908TIFF&_add:true)
- [Ottawa, Ontario. 1:63,360. Map Sheet 031G05, [ed. 10], 1932](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K031G05_1932TIFF&_add:true)

<br>

## Rondeau Provincial Park

<div class="juxtapose">
	<img src="../img/highlights/HTDP63360K040I05_1910TIFF.jpg" data-label="1901" />
    <img src="../img/highlights/HTDP63360K040I05_1941_MBTIFF.jpg" data-label="1941" />
</div>

<div class="row slider-description">
	<p class="col-md-6"><strong>Left</strong>: Early Rondeau Provincial Park (1901)</p>
	<p class="col-md-6"><strong>Right</strong>: Development of the park, including road pattern and shoreline cottages, over a 30 year period (1941)</p>
</div>

### Sources

- [Ridgetown, Ontario. 1:63,360. Map Sheet 040I05, [ed. 1], 1910](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K040I05_1910TIFF&_add:true)
- [Ridgetown, Ontario. 1:63,360. Map Sheet 040I05, [ed. 3], gridded, 1941](http://geo.scholarsportal.info/#r/details/_uri@=HTDP63360K040I05_1941_MBTIFF&_add:true)

### More information

Rondeau Provincial Park, created in 1894 and located on a sand spit extending into Lake Erie, is the second oldest provincial park in Ontario. The name of the park comes from the French words “ronde eau” or “round water” which describes the shape of the harbour sheltered by the peninsula. Rondeau is home to the largest area of Carolinian forest in Canada, and is an important stopover for birds during migration.

- [Rondeau Provincial Park, Ontario Parks](https://www.ontarioparks.com/park/rondeau)

<script src="../js/juxtapose.js"></script>
