+++
date = "2017-04-24"
title = "About The Project"
+++

## Overview

The Ontario Council of University Libraries (OCUL) Historical Topographic Map Digitization Project is a province-wide collaboration to inventory, digitize, georeference, and provide broad access to early topographic maps of Ontario. The collection provides open access to georeferenced topographic maps at the 1:25,000 and 1:63,360 (one inch to one mile) scales, covering towns, cities, and rural areas in Ontario over the period of 1906 to 1977. The project adds over 1000 maps to our collective digital holdings.

The project traces its beginnings back to 2011, when the idea for digitizing historic topographic maps had been identified as a strategic goal by the OCUL Map Group. A major impetus for the digitization of historical topographic maps came in 2012 when members of the group became aware that the Maps Depository Program run by Natural Resources Canada was ending. In response, an inventory of historic Canadian federal topographic map series was created to determine what was collectively held in Ontario Universities. A small digitization working group was also struck to begin moving the project forward, and this group continued preliminary work on the project throughout 2013.

From the outset of the funded project in 2014, Ontario universities have contributed their support by supplying and scanning maps, georeferencing the digital images, creating metadata for the records, and developing the online geographical display of the maps for the public to access.

Topographic maps at these scales are heavily used by researchers interested in examining changes over time, such as urban sprawl, transportation patterns, diminishing woodlots, or shoreline erosion.

The OCUL Geo Community is a forum for the exchange of information and ideas pertaining to maps, geospatial data, and other cartographic resources, both print and digital, within the wider Ontario Council of University Libraries community.

For more information and inquiries about the project please [contact us](../contact/).

## Technical Specifications

The following presents the steps taken to digitize all of the historical topographic maps from the 1:25,000 and 1:63,360 scale series for Ontario. These technical specifications are presented as a set of scanning and georeferencing guidelines for the project. This can also serve as a useful reference for other institutions undertaking map digitization projects.

### Digitization

Print maps were digitized at 600 ppi resolution and 24-bit colour depth with Colortrac feed-through scanners (models SmartLF Gx+ T56 and SmartLF SG), using standardized colour normalization and stitch correction processes. Manual quality control methods were applied to each digitized sheet to ensure images were straightened and cropped appropriately. Images were also manually inspected for the presence of scanning artifacts; affected images were either corrected or the sheet was flagged for re-scanning.

### Derivative Images

ImageMagick software was used within a custom script to generate three different-sized derivative images for each digitized sheet in JPEG format. A ‘large’ JPEG derivative was generated by scaling the original TIFF image by 50%; a ‘medium’ JPEG derivative was generated by scaling the original TIFF to a 2000 pixel-wide image; and, a ‘small’ JPEG derivative was generated by scaling the original TIFF to a 204 pixel-wide image.

### Georeferencing and Georectification

A total of 8 to 12 ground control points (GCPs) were established for each digitized map using ArcMap software (versions 10.1 to 10.5). Georeferencing and projection for each map was carried out using the Geospatial Data Abstraction Library (GDAL) functions gdal_translate and gdalwarp, respectively. A custom script was used to automate the conversion of ArcMap GCP files to GDAL format, as well as the georeferencing and warping processes. As part of the warping process, GeoTIFFs were projected to the NAD83 datum, and into the appropriate UTM zone.

### Tiled Web Map Generation

Each georectified image was transformed into a collection of tiled web maps using the gdal2tiles library within a custom script. Tiles were generated in Web Mercator projection (EPSG: 3857) for zoom levels 6 through 16.

All geoprocessing scripts may be accessed [on Github](https://github.com/jasonbrodeur/OCUL_HTDP).

### Project Website

The project website was created with the [Hugo static website generator](https://gohugo.io/). It uses [JuxtaposeJS](https://juxtapose.knightlab.com/) to compare images, and the [elevateZoom-plus jQuery plugin](https://github.com/igorlino/elevatezoom-plus) to zoom into individual maps. The source code for the website is available [on Github](https://github.com/scholarsportal/historical-topos).

For more information about the project’s technical specifications please [contact us](https://ocul.on.ca/topomaps/contact/).

## Contributors

Over the course of the project there were many contributors from across Ontario, including libraries and other organizations, some providing maps from local collections, map scanning, georeferencing, quality assurance, metadata creation, data transformation, project management, and technical development. The following is a list of institutions and organizations that contributed to the project from 2014 to 2017.

### Organizations

* Archives of Ontario
* Brock University Library
* Carleton University Library
* Library and Archives Canada
* McMaster University Library
* Natural Resources Canada
* Queen’s University Library
* Ryerson University Library
* Scholars Portal
* Toronto Reference Library
* Trent University Library
* University of Alberta Library
* University of Ottawa
* University of Toronto Libraries
* University of Waterloo Library
* Western University Library
* Wilfrid Laurier University Library
* York University Library

<br>

### Individuals

* Colleen Beard (Brock University)
* Sharon Janzen (Brock University)
* Rebecca Bartlett (Carleton University Library)
* Ryder Burt (Carleton University Library)
* Joël Rivard (Carleton University Library)
* Marc Cockburn (Library and Archives Canada)
* Lorraine Dubreuil (Emeritus, McGill University)
* Jordan Aharoni (McMaster University)
* Victoria Balkwill Tweedie (McMaster University)
* Gordon Beck (McMaster University)
* Jason Brodeur (McMaster University)
* Katie Maloney (McMaster University)
* Jenny Ni (McMaster University)
* Ashleigh Patterson (McMaster University)
* Margaret Rutten (McMaster University)
* Bianca Chiarenza (Ryerson University)
* Noel Damba (Ryerson University)
* Dan Jakubek (Ryerson University)
* Jo Ashley (Scholars Portal)
* Jaiwei Chen (Scholars Portal)
* Kara Handren (Scholars Portal)
* Amber Leahey (Scholars Portal)
* Kaitlin Newson (Scholars Portal)
* Kevin Worthington (Scholars Portal)
* Charles Hill (University of Ottawa Library)
* Raphaël Pelletier (University of Ottawa Library)
* Sophie Routhier LeBlanc (University of Ottawa Library)
* Sarah Simpkin (University of Ottawa Library)
* Wish Yen (University of Ottawa Library)
* Marcel Fortin (University of Toronto, St. George)
* Jordan Hale (University of Toronto, St. George)
* Eva Dodsworth (University of Waterloo)
* Cheryl Woods (Western University Library)
* Peter Genzinger (Wilfrid Laurier University)
* Trudy Bodak (Emeritus, York University)
* Neil Livingston (York University Library)
* Zarah Malm (York University)
* Rosa Orlandini (York University Library)
* Veronica Petta (York University)
* Artemisia Robins (York University)
* Marisa Thomas-Perrier (York University)

<br>

Special thank you to the Ontario Council of University Libraries (OCUL) for providing the funding for the 3-year project. In 2017, OCUL is celebrating its 50th anniversary, and this project marks a tremendous achievement, recognizing collaboration in shared stewardship and preserving Canada’s past.
