+++
date = "2017-03-31"
title = "About The Maps"
+++

Early topographic mapping in Canada was fragmented, with many agencies producing maps at different scales. The areas mapped varied, and the legends and colours used rarely matched up. This changed in 1904, when a standardized system of mapping was introduced, which officially became Canada’s National Topographic System (NTS) in 1926. Over the next several decades, over 1000 maps were produced for Ontario alone in the 1:63,360 and 1:25,000 scales series. The timeline below provides a detailed history of the production of these maps.

## Historical Timeline

**1899-1902:** The Boer War raises concerns in Canada about the importance of military maps for national defence.

**1903:** Major E.H. Hills, a British military mapping expert, publishes his “Report on the Survey of Canada.” This report was commissioned by the Canadian Government, to determine whether existing topographical maps could be used for military operations. Hills’ report is very critical of existing maps, and recommends the creation of a survey unit within the Canadian Army.

**1904:** The Survey Division of the Canadian Army’s Intelligence Branch, Department of Militia and Defence, is formed. Surveying operations begin for the earliest maps in the 1:63,360 series.

**1906-1914:** An agreement between the Canadian Army and British War Office allows for British topographers to be loaned out to the Canadian Army’s Survey Division. This agreement fills much-needed positions in the Survey Division. As a result, the earliest maps produced are extremely similar to the specifications of the British Ordnance Survey.

**1906:** The first topographical maps produced by the new Survey Division are published in Great Britain.

**1912:** The Department of Militia and Defence purchases printing equipment, allowing Canadian maps to be published in Canada.

**1906-1922:** Two other agencies become involved in contributing to map production: the Geological Survey, Department of Mines and the Topographical and Air Survey Bureau, Department of the Interior. _Note: the Department of the Interior was very rarely involved in the creation of maps in the Province of Ontario._

**1922:** The Board on Topographical Surveys and Maps is established, to create guidelines for a common set of map specifications that could be used by all agencies involved.
The first experiments using aerial photographs as a topographic tool are conducted by the Royal Canadian Air Force (RCAF).

**1923:** The sheet line numbering system for maps is adopted (this becomes the National Topographic System (NTS) standard numbering system in 1926).

The Department of Militia and Defence becomes the Department of National Defence.

All agencies agree to publish maps ungridded. The Department of National Defence retains permission to add gridding to sheets as required.

**1924:** The Survey Division becomes the Geographical Section, General Staff, Department of National Defence.

**1931:** Aerial photography is now widely used for all new topographic surveys and revisions. All photographs are taken by the RCAF.

**1936:** The Geological Survey, Department of Mines becomes the Mapping Branch, Department of Energy, Mines and National Resources.

**1948:** The national mapping agencies of Canada, the United States, and the United Kingdom, hold a joint  meeting that concludes it is desirable to follow other NATO countries and switch map series from foot-mile scales to even representation fractions (1:25,000, 1:50,000 and 1:250,000).

**1949:** Canada decides to make the switch to even representation fractions.

**1950:** The last map is drawn in the 1:63,360 map series. Printing continues into the early 1950s.
The NTS 1:63,360 scale is changed to 1:50,000.

**1954:** The first aerial photographs are taken in Ontario for the new 1:25,000 topographical maps. These maps focus almost exclusively on urban areas.

**1956:** The first maps are published in the 1:25,000s series. All maps are surveyed and published under the direction of the Department of National Defence.

**1960:** Private surveying companies are contracted to take aerial photographs. From this time on, the RCAF is rarely involved in topographical surveys.

**1964:** Separate publication of non-gridded vs. gridded (military) sheets is discontinued. All sheets after this date are published using a UTM grid.

**1974:** The last aerial photographs are taken for the 1:25,000 map series, and the last revised sheet is published. Printing continued into the late 1970s.

## Map Legend Lettering and Conventional Signs

Original maps in the 1:63,360 series were printed in 5 colours:

* Black: lettering, cultural detail, geographic graticule
* Red: stone or brick buildings
* Blue: water features
* Brown: metalled (paved) roads, contours, spot heights and bench marks
* Green: wooded areas

<img class= "img-responsive" src="../img/legend-63k-1.png" alt="Example of a typical legend on the 1:63,360 series maps, showing symbology and colouring used for the following: highways, roads, paths, railways, post offices, telegraph/telephone routes, survey monuments, boundaries (provincial, county, township), power lines, triangulation stations, cemeteries, telephone exchanges.">

<img class= "img-responsive" src="../img/legend-63k-2.png" alt="Example of a typical legend on the 1:63,360 series maps, showing symbology and colouring used for the following: houses, barns, mills (saw, grist/flour, cheese, other), quarries, pits (sand, gravel), woods (deciduous, coniferous), churches, schools, marshes, orchards, altitudes, bench marks, contours (elevations, depressions).">

By 1927, the use of red to indicate stone or brick buildings stopped. From this point on, red was used to indicate paved roads. All other colouring remained largely consistent through to the end of the 1:25,000 series.

Detailed information on the lettering and symbols used in the creation of these maps is available in the resources listed below.

## More Information

Canada, Surveys and Mapping Branch. _Cartographic Symbols and Specifications of the National Topographic System 1:25,000 – 1:50,000 / Spécifications des symbols cartographiques du Système national de reference cartographique_. Ottawa: Surveys and Mapping Branch, 1977.

Dubreuil, Lorraine. _Canada’s Militia and Defence Maps: 1905-1931._ Ottawa: Association of Canadian Map Libraries and Archives, 1992.

Dubreuil, Lorraine. _Standard Topographical maps of Canada, 1904-1948._ Ottawa: Association of Canadian Map Libraries and Archives, 1991.

Natural Resources Canada / Ressources naturelles Canada. _Topographic Maps: The Basics_. http://epe.lac-bac.gc.ca/100/201/301/weekly_checklist/2014/internet/w14-20-U-E.html/collections/collection_2014/rncan-nrcan/M114-35-2014-eng.pdf

L.M. Sebert. “The One Inch to One Mile Series of the National Mapping Program.” In, _The Canadian Cartographer_ 13, no. 2 (December 1976).

Sebert, L.M. and N.L. Nicholson. _The maps of Canada: a guide to official Canadian maps, charts, atlases and gazetteers_. Folkestone, Kent: Dawson, 1981.
