import { buildMockPlatformAction, buildMockPlatformDataMap } from './TestersMockBuilders';
import { mockPlatformDataMaps } from './MockPlatformDataMaps';
import { PlatformAction } from '../../src/types/TagRulesTypes';
import { InputType, VarType } from '../../src/gql/generated/globalTypes';

const mockPlatformAction = {
    dataManagerAction: buildMockPlatformAction('Data Manager', [
        mockPlatformDataMaps.ingestEndpointPayloadDesigner,
    ]),
    domSelectorAction: buildMockPlatformAction('Dom Selector', [
        mockPlatformDataMaps.domSelector,
        mockPlatformDataMaps.domSelectorMandatory,
    ]),
    conditionsAction: buildMockPlatformAction('Conditions', [
        mockPlatformDataMaps.genericCondition,
        mockPlatformDataMaps.stringCondition,
        mockPlatformDataMaps.numberCondition,
        mockPlatformDataMaps.genericConditionMandatory,
        mockPlatformDataMaps.stringConditionMandatory,
        mockPlatformDataMaps.numberConditionMandatory,
    ]),
    scalarsAction: buildMockPlatformAction('Simple Scalars', [
        mockPlatformDataMaps.text,
        mockPlatformDataMaps.textArea,
        mockPlatformDataMaps.email,
        mockPlatformDataMaps.color,
        mockPlatformDataMaps.int,
        mockPlatformDataMaps.float,
        buildMockPlatformDataMap(VarType.STRING, InputType.TEXT_WITH_MACRO_SUPPORT),
    ]),
    booleanAction: buildMockPlatformAction('Boolean Inputs', [
        mockPlatformDataMaps.checkbox,
        mockPlatformDataMaps.checkboxMandatory,
        mockPlatformDataMaps.booleanInput,
        mockPlatformDataMaps.booleanInputMandatory,
    ]),
    lookupSelectsAction: buildMockPlatformAction('Lookup Selects', [
        mockPlatformDataMaps.revisionSelect,
        mockPlatformDataMaps.environmentSelect,
        mockPlatformDataMaps.consentVendors,
        mockPlatformDataMaps.consentPurposes,
        mockPlatformDataMaps.revisionSelectMandatory,
        mockPlatformDataMaps.environmentSelectMandatory,
        mockPlatformDataMaps.consentPurposesMandatory,
        mockPlatformDataMaps.consentVendorsMandatory,
    ]),
    datesAction: buildMockPlatformAction('Dates', [
        buildMockPlatformDataMap(VarType.DATETIME, InputType.DATE_STRING, true),
        buildMockPlatformDataMap(VarType.DATETIME, InputType.DATE_STRING),
        buildMockPlatformDataMap(VarType.TIMESTAMP, InputType.DATE_STAMP, true),
        buildMockPlatformDataMap(VarType.TIMESTAMP, InputType.DATE_STAMP),
        buildMockPlatformDataMap(VarType.DATETIME, InputType.DATETIME_STRING, true),
        buildMockPlatformDataMap(VarType.DATETIME, InputType.DATETIME_STRING),
        buildMockPlatformDataMap(VarType.TIMESTAMP, InputType.DATETIME_STAMP, true),
        buildMockPlatformDataMap(VarType.TIMESTAMP, InputType.DATETIME_STAMP),
    ]),
    urlAction: buildMockPlatformAction('URLs', [
        buildMockPlatformDataMap(VarType.STRING, InputType.URL, true),
        buildMockPlatformDataMap(VarType.STRING, InputType.URL),
        buildMockPlatformDataMap(VarType.STRING, InputType.URL_WITH_MACRO_SUPPORT, true),
        buildMockPlatformDataMap(VarType.STRING, InputType.URL_WITH_MACRO_SUPPORT),
    ]),
    selectAction: buildMockPlatformAction('Selects', [
        buildMockPlatformDataMap(
            VarType.ARRAY_STRING,
            InputType.MULTIPLE_SELECT,
            true,
            InputType.MULTIPLE_SELECT,
            ['dsfsdfsdf', 'sdsdf', 'ddd'],
        ),
        buildMockPlatformDataMap(
            VarType.ARRAY_STRING,
            InputType.MULTIPLE_SELECT,
            false,
            InputType.MULTIPLE_SELECT,
            ['dsfsdfsdf', 'sdsdf', 'ddd'],
        ),
        buildMockPlatformDataMap(VarType.STRING, InputType.SELECT, true, InputType.SELECT, [
            'dsfsdfsdf',
            'sdsdf',
            'ddd',
        ]),
        buildMockPlatformDataMap(VarType.STRING, InputType.SELECT, false, InputType.SELECT, [
            'dsfsdfsdf',
            'sdsdf',
            'ddd',
        ]),
    ]),
};

const mockPlatformActions = {
    noDataCase: [] as PlatformAction[],
    newSelectorsCase: [
        mockPlatformAction.dataManagerAction,
        mockPlatformAction.booleanAction,
        mockPlatformAction.domSelectorAction,
        mockPlatformAction.conditionsAction,
        mockPlatformAction.lookupSelectsAction,
        mockPlatformAction.datesAction,
        mockPlatformAction.urlAction,
        mockPlatformAction.selectAction,
    ] as PlatformAction[],
    defaultCase: [
        mockPlatformAction.dataManagerAction,
        mockPlatformAction.scalarsAction,
        mockPlatformAction.datesAction,
        {
            id: '5f31490d66dba60c29f65ded',
            name: 'Scalars',
            description: '...',
            platform_data_maps: [
                {
                    id: '5f31490d6dfxd',
                    key: 'js',
                    var_type: VarType.STRING,
                    input_type: InputType.JAVASCRIPT,
                    is_optional: true,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490d6dfxd1',
                    key: 'css',
                    var_type: VarType.STRING,
                    input_type: InputType.CSS,
                    is_optional: true,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490d6dfxd2',
                    key: 'html',
                    var_type: VarType.STRING,
                    input_type: InputType.HTML,
                    is_optional: true,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490d6dfxd3',
                    key: 'json',
                    var_type: VarType.STRING,
                    input_type: InputType.JSON,
                    is_optional: false,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490dv3',
                    key: 'select',
                    var_type: VarType.STRING,
                    input_type: InputType.SELECT,
                    is_optional: false,
                    default_value: null,
                    option_values: ['dsfsdfsdf', 'sdsdf', 'ddd'],
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
            ],
            __typename: 'PlatformAction',
        },
        {
            id: '5f31490d66dba60c29f65d66',
            name: 'Arrays',
            description: '...',
            platform_data_maps: [
                {
                    id: '5f31490d66dba60c29f65de0101',
                    key: 'yy',
                    var_type: VarType.ARRAY_INT,
                    input_type: InputType.INT_ARRAY_INPUT,
                    is_optional: false,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490d66dba60c29f60103',
                    key: 'bg_color',
                    var_type: VarType.ARRAY_FLOAT,
                    input_type: InputType.FLOAT_ARRAY_INPUT,
                    is_optional: true,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490d66dba60c29f65005',
                    key: 'text',
                    var_type: VarType.ARRAY_STRING,
                    input_type: InputType.TEXT_ARRAY_INPUT,
                    is_optional: false,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490d66dba60c29f65006',
                    key: 'multiline',
                    var_type: VarType.ARRAY_STRING,
                    input_type: InputType.TEXTAREA_ARRAY_INPUT,
                    is_optional: false,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
            ],
            __typename: 'PlatformAction',
        },
        {
            id: '5f31490d66dba60c29f65dfa',
            name: 'Load JavaScript Tag',
            description: '...',
            platform_data_maps: [
                {
                    id: '5f31490d66dba60c29f65de2',
                    key: 'js',
                    var_type: VarType.STRING,
                    input_type: InputType.TEXTAREA,
                    is_optional: false,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [],
                },
                {
                    id: '5f31490d66dba60c29f65df4',
                    key: 'js_options',
                    var_type: VarType.OBJECT,
                    input_type: InputType.OBJECT_INPUT,
                    is_optional: false,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [
                        {
                            id: '5f31490d66dba60c29f65dee',
                            key: 'js_frame_options',
                            var_type: VarType.OBJECT,
                            input_type: InputType.OBJECT_INPUT,
                            is_optional: false,
                            default_value: null,
                            option_values: null,
                            description: '...',
                            __typename: 'PlatformDataMap',
                            child_platform_data_maps: [
                                {
                                    id: '5f31490d66dba60c29f65de3',
                                    key: 'use_sandbox',
                                    var_type: VarType.BOOLEAN,
                                    input_type: InputType.CHECKBOX,
                                    is_optional: true,
                                    default_value: {
                                        __typename: 'DefaultValueContainer',
                                        value: false,
                                    },
                                    option_values: null,
                                    description: '...',
                                    __typename: 'PlatformDataMap',
                                    child_platform_data_maps: [],
                                },
                                {
                                    id: '5f31490d66dba60c2cxvbxcvde3',
                                    key: 'url',
                                    var_type: VarType.STRING,
                                    input_type: InputType.URL,
                                    is_optional: true,
                                    option_values: null,
                                    description: '...',
                                    default_value: null,
                                    __typename: 'PlatformDataMap',
                                    child_platform_data_maps: [],
                                },
                            ],
                        },
                    ],
                },
                {
                    id: '5f31490d66dba60c29f65df3',
                    key: 'js_env_vars',
                    var_type: VarType.ARRAY_OBJECT,
                    input_type: InputType.OBJECT_ARRAY_INPUT,
                    is_optional: true,
                    default_value: null,
                    option_values: null,
                    description: '...',
                    __typename: 'PlatformDataMap',
                    child_platform_data_maps: [
                        {
                            id: '5f31490d66dba60c29f65de4',
                            key: 'env_var_key',
                            var_type: VarType.INT,
                            input_type: InputType.INT_INPUT,
                            is_optional: false,
                            default_value: null,
                            option_values: null,
                            description: '...',
                            __typename: 'PlatformDataMap',
                            child_platform_data_maps: [],
                        },
                        {
                            id: '5f31490d66dba60c29f65de5',
                            key: 'env_var_value',
                            var_type: VarType.STRING,
                            input_type: InputType.TEXT,
                            is_optional: false,
                            default_value: null,
                            option_values: null,
                            description: '...',
                            __typename: 'PlatformDataMap',
                            child_platform_data_maps: [],
                        },
                    ],
                },
            ],
            __typename: 'PlatformAction',
        },
    ] as PlatformAction[],
};

export { mockPlatformActions };
