import { AppPlatformRevision } from '../../src/types/TagRulesTypes';
import { buildMockPlatformDataMap } from './TestersMockBuilders';
import { InputType, VarType } from '../../src/gql/generated/globalTypes';

const mockAppPlatformRevisions = {
    defaultCase: [
        {
            __typename: 'AppPlatformRevision',
            id: '5fd72001bf85900a194307f0',
            platform_revision: {
                __typename: 'PlatformRevision',
                id: '5fd71ffdbf85900a194307ad',
                platform: {
                    __typename: 'Platform',
                    id: '5edf4c48e9615d9a1c66bc9b',
                    name: 'Scale8 Platform',
                },
                platform_data_containers: [
                    {
                        __typename: 'PlatformDataContainer',
                        id: '5fd71ffdbf85900a194307b8',
                        persisting_id: 'query_string',
                        allow_custom: true,
                        name: 'Query String',
                        platform_data_maps: [],
                        validation_rules: null,
                        description: '...',
                    },
                    {
                        __typename: 'PlatformDataContainer',
                        id: '5fd71ffdbf85900a194307bb',
                        persisting_id: 'custom_data_layer',
                        allow_custom: true,
                        name: 'Custom Data Layer',
                        platform_data_maps: [],
                        validation_rules: null,
                        description: '...',
                    },
                    {
                        __typename: 'PlatformDataContainer',
                        id: '5fd71ffdbf85900a194307b5',
                        persisting_id: 'local_storage',
                        allow_custom: true,
                        name: 'Local Storage',
                        platform_data_maps: [],
                        validation_rules: null,
                        description: '...',
                    },
                    {
                        __typename: 'PlatformDataContainer',
                        id: '5fd71ffdbf85900a194307be',
                        persisting_id: 'scale8_data_layer',
                        allow_custom: true,
                        name: 'Scale8 Data Layer',
                        platform_data_maps: [
                            {
                                id: '5f31490cxyxba60c29f65db5',
                                key: 'rawObjRoot',
                                var_type: VarType.OBJECT,
                                input_type: InputType.OBJECT_INPUT,
                                default_value: null,
                                option_values: null,
                                __typename: 'PlatformDataMap',
                                description: '...',
                                child_platform_data_maps: [],
                                is_optional: true,
                            },
                            {
                                __typename: 'PlatformDataMap',
                                child_platform_data_maps: [
                                    buildMockPlatformDataMap(
                                        VarType.STRING,
                                        InputType.TEXT,
                                        false,
                                        'country_code',
                                    ),
                                    buildMockPlatformDataMap(
                                        VarType.ARRAY_STRING,
                                        InputType.TEXT,
                                        false,
                                        'subdivision_codes',
                                    ),
                                    {
                                        id: '5f31490cxyxba60c29f65db5',
                                        key: 'rawObjDeep',
                                        var_type: VarType.OBJECT,
                                        input_type: InputType.OBJECT_INPUT,
                                        default_value: null,
                                        option_values: null,
                                        __typename: 'PlatformDataMap',
                                        description: '...',
                                        child_platform_data_maps: [],
                                        is_optional: true,
                                    },
                                ],
                                id: '5fd71ffdbf85900a194307bd',
                                key: 'geo_data',
                                var_type: 'OBJECT',
                                input_type: 'OBJECT_INPUT',
                                description: 'A description has not been provided',
                                option_values: null,
                                is_optional: false,
                                default_value: null,
                            },
                            {
                                __typename: 'PlatformDataMap',
                                child_platform_data_maps: [
                                    {
                                        __typename: 'PlatformDataMap',
                                        child_platform_data_maps: [],
                                        id: '5fd71ffdbf85900a194307b6',
                                        key: 'key',
                                        var_type: 'STRING',
                                        input_type: 'TEXT',
                                        description: 'A description has not been provided',
                                        option_values: null,
                                        is_optional: false,
                                        default_value: null,
                                    },
                                    {
                                        __typename: 'PlatformDataMap',
                                        child_platform_data_maps: [],
                                        id: '5fd71ffdbf85900a194307b9',
                                        key: 'value',
                                        var_type: 'ARRAY_STRING',
                                        input_type: 'TEXT',
                                        description: 'A description has not been provided',
                                        option_values: null,
                                        is_optional: false,
                                        default_value: null,
                                    },
                                ],
                                id: '5fd71ffdbf85900a194307bc',
                                key: 'platform_vars',
                                var_type: 'ARRAY_OBJECT',
                                input_type: 'OBJECT_ARRAY_INPUT',
                                description: 'A description has not been provided',
                                option_values: null,
                                is_optional: false,
                                default_value: null,
                            },
                        ],
                        description: '...',
                    },
                ],
            },
        },
    ] as AppPlatformRevision[],
};

export { mockAppPlatformRevisions };
