import { ConditionType, InputType } from '../gql/generated/globalTypes';

export type MatchConditionValue = {
    condition: ConditionType;
    types: (InputType | 'Custom' | 'StringCondition' | 'NumberCondition')[];
    symbol: string;
    text: string;
};

const matchConditionValues: MatchConditionValue[] = [
    {
        condition: ConditionType.IS_DEFINED,
        types: ['Custom', 'StringCondition', 'NumberCondition'],
        symbol: '✓',
        text: 'Is Defined',
    },
    {
        condition: ConditionType.IS_NOT_DEFINED,
        types: ['Custom', 'StringCondition', 'NumberCondition'],
        symbol: '∅',
        text: 'Is Not Defined',
    },
    {
        condition: ConditionType.EQUAL,
        types: [
            InputType.TEXT,
            InputType.TEXTAREA,
            InputType.URL,
            InputType.URL_WITH_MACRO_SUPPORT,
            InputType.EMAIL,
            InputType.HTML,
            InputType.CSS,
            InputType.JAVASCRIPT,
            InputType.JSON,
            InputType.FLOAT_INPUT,
            InputType.INT_INPUT,
            InputType.DATETIME_STAMP,
            InputType.DATETIME_STRING,
            InputType.DATE_STAMP,
            InputType.DATE_STRING,
            InputType.CHECKBOX,
            InputType.BOOLEAN_INPUT,
            InputType.COLOR,
            InputType.COUNTRY_CODE_SELECT,
            InputType.RADIO,
            InputType.SELECT,
            InputType.DOM_SELECTOR_INPUT,
            InputType.STRING_CONDITION,
            InputType.NUMBER_CONDITION,
            InputType.ENVIRONMENT_SELECT,
            InputType.REVISION_SELECT,
            'Custom',
            'StringCondition',
            'NumberCondition',
        ],
        symbol: '=',
        text: 'Equal',
    },
    {
        condition: ConditionType.NOT_EQUAL,
        types: [
            InputType.TEXT,
            InputType.TEXTAREA,
            InputType.URL,
            InputType.URL_WITH_MACRO_SUPPORT,
            InputType.EMAIL,
            InputType.HTML,
            InputType.CSS,
            InputType.JAVASCRIPT,
            InputType.JSON,
            InputType.FLOAT_INPUT,
            InputType.INT_INPUT,
            InputType.DATETIME_STAMP,
            InputType.DATETIME_STRING,
            InputType.DATE_STAMP,
            InputType.DATE_STRING,
            InputType.BOOLEAN_INPUT,
            InputType.COLOR,
            InputType.COUNTRY_CODE_SELECT,
            InputType.RADIO,
            InputType.SELECT,
            InputType.DOM_SELECTOR_INPUT,
            InputType.STRING_CONDITION,
            InputType.NUMBER_CONDITION,
            InputType.ENVIRONMENT_SELECT,
            InputType.REVISION_SELECT,
            'Custom',
            'StringCondition',
            'NumberCondition',
        ],
        symbol: '≠',
        text: 'Not Equal',
    },
    {
        condition: ConditionType.GREATER_THAN,
        types: [
            InputType.FLOAT_INPUT,
            InputType.INT_INPUT,
            InputType.DATETIME_STAMP,
            InputType.DATETIME_STRING,
            InputType.DATE_STAMP,
            InputType.DATE_STRING,
            'Custom',
            'NumberCondition',
        ],
        symbol: '>',
        text: 'Greater Than',
    },
    {
        condition: ConditionType.LESS_THAN,
        types: [
            InputType.FLOAT_INPUT,
            InputType.INT_INPUT,
            InputType.DATETIME_STAMP,
            InputType.DATETIME_STRING,
            InputType.DATE_STAMP,
            InputType.DATE_STRING,
            'Custom',
            'NumberCondition',
        ],
        symbol: '<',
        text: 'Less Than',
    },
    {
        condition: ConditionType.GREATER_THAN_EQUAL,
        types: [
            InputType.FLOAT_INPUT,
            InputType.INT_INPUT,
            InputType.DATETIME_STAMP,
            InputType.DATETIME_STRING,
            InputType.DATE_STAMP,
            InputType.DATE_STRING,
            'Custom',
            'NumberCondition',
        ],
        symbol: '≥',
        text: 'Greater Than Equal',
    },
    {
        condition: ConditionType.LESS_THAN_EQUAL,
        types: [
            InputType.FLOAT_INPUT,
            InputType.INT_INPUT,
            InputType.DATETIME_STAMP,
            InputType.DATETIME_STRING,
            InputType.DATE_STAMP,
            InputType.DATE_STRING,
            'Custom',
            'NumberCondition',
        ],
        symbol: '≤',
        text: 'Less Than Equal',
    },
    {
        condition: ConditionType.CONTAINS,
        types: [
            InputType.FLOAT_ARRAY_INPUT,
            InputType.INT_ARRAY_INPUT,
            InputType.TEXT_ARRAY_INPUT,
            InputType.TEXTAREA_ARRAY_INPUT,
            InputType.CONSENT_VENDORS,
            InputType.CONSENT_PURPOSES,
            InputType.MULTIPLE_SELECT,
        ],
        symbol: '∋',
        text: 'Contains',
    },
    {
        condition: ConditionType.CONTAINS,
        types: [
            InputType.TEXT,
            InputType.TEXTAREA,
            InputType.URL,
            InputType.URL_WITH_MACRO_SUPPORT,
            InputType.EMAIL,
            InputType.HTML,
            InputType.CSS,
            InputType.JAVASCRIPT,
            InputType.JSON,
            InputType.DOM_SELECTOR_INPUT,
            InputType.STRING_CONDITION,
            InputType.NUMBER_CONDITION,
            InputType.ENVIRONMENT_SELECT,
            InputType.REVISION_SELECT,
            'StringCondition',
        ],
        symbol: '⊏⊐',
        text: 'Contains',
    },
    {
        condition: ConditionType.CONTAINS,
        types: ['Custom'],
        symbol: '∋/⊏⊐',
        text: 'Contains',
    },
    {
        condition: ConditionType.BEGINS_WITH,
        types: [
            InputType.TEXT,
            InputType.TEXTAREA,
            InputType.URL,
            InputType.URL_WITH_MACRO_SUPPORT,
            InputType.EMAIL,
            InputType.HTML,
            InputType.CSS,
            InputType.JAVASCRIPT,
            InputType.JSON,
            InputType.DOM_SELECTOR_INPUT,
            InputType.STRING_CONDITION,
            InputType.NUMBER_CONDITION,
            InputType.ENVIRONMENT_SELECT,
            InputType.REVISION_SELECT,
            'Custom',
            'StringCondition',
        ],
        symbol: '⊏',
        text: 'Begins with',
    },
    {
        condition: ConditionType.ENDS_WITH,
        types: [
            InputType.TEXT,
            InputType.TEXTAREA,
            InputType.URL,
            InputType.URL_WITH_MACRO_SUPPORT,
            InputType.EMAIL,
            InputType.HTML,
            InputType.CSS,
            InputType.JAVASCRIPT,
            InputType.JSON,
            InputType.DOM_SELECTOR_INPUT,
            InputType.STRING_CONDITION,
            InputType.NUMBER_CONDITION,
            InputType.ENVIRONMENT_SELECT,
            InputType.REVISION_SELECT,
            'Custom',
            'StringCondition',
        ],
        symbol: '⊐',
        text: 'Ends with',
    },
    {
        condition: ConditionType.REGULAR_EXPRESSION,
        types: [
            InputType.TEXT,
            InputType.TEXTAREA,
            InputType.URL,
            InputType.URL_WITH_MACRO_SUPPORT,
            InputType.EMAIL,
            InputType.HTML,
            InputType.CSS,
            InputType.JAVASCRIPT,
            InputType.JSON,
            InputType.DOM_SELECTOR_INPUT,
            InputType.STRING_CONDITION,
            InputType.NUMBER_CONDITION,
            InputType.ENVIRONMENT_SELECT,
            InputType.REVISION_SELECT,
            'Custom',
            'StringCondition',
        ],
        symbol: '⌕',
        text: 'Regular Expression',
    },
];
export { matchConditionValues };
