# Generated by Django 2.2.9 on 2020-01-30 19:40

from django.db import migrations
from machina_search import settings


class Migration(migrations.Migration):

    dependencies = [
        ('machina_search', '0001_initial'),
    ]

    if settings.SEARCH_ENGINE == 'postgres':
        operations = [
            migrations.RunSQL(
                    sql='''
                    CREATE FUNCTION update_search_table() RETURNS trigger AS $machina_search_postssearchindex$
                        BEGIN
                            IF (TG_OP = 'UPDATE' OR TG_OP = 'INSERT') THEN
                                INSERT into machina_search_postssearchindex 
                                    (topic, search_vector_all, search_vector_subject)
                                SELECT
                                    NEW.id,
                                    setweight(to_tsvector('pg_catalog.{0}', coalesce(NEW.subject, '')), 'A') ||
                                    setweight(to_tsvector('pg_catalog.{0}', coalesce(NEW.content, '')), 'B'),
                                    to_tsvector('pg_catalog.{0}', coalesce(NEW.subject, ''))
                                ON CONFLICT ("topic") 
                                DO UPDATE SET
                                    "search_vector_all" = EXCLUDED.search_vector_all,
                                    "search_vector_subject" = EXCLUDED.search_vector_subject;
                                RETURN NEW;
                            ELSIF (TG_OP = 'DELETE') THEN
                                DELETE FROM machina_search_postssearchindex
                                WHERE topic = OLD.id;
                                RETURN OLD;
                            END IF;
                        END;
                    $machina_search_postssearchindex$ LANGUAGE plpgsql;

                    CREATE TRIGGER post_search_index_add 
                    AFTER INSERT OR UPDATE OR DELETE ON forum_conversation_post
                    FOR EACH ROW EXECUTE PROCEDURE update_search_table();
                    '''.format(settings.SEARCH_LANGUAGE),

                    reverse_sql='''
                    DROP TRIGGER IF EXISTS post_search_index_add ON forum_conversation_post;
                    '''),
        ]
    else:
        operations = []
