{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit i_ExportMarks2KMLConfig;

interface

uses
  i_ExportConfig;

type
  TKmlSortingType = (kstNone = 0, kstByNameASC, kstByNameDESC);

  TKmlIconScaleType = (kistAbs = 0, kistSmall, kistMedium, kistLarge);

  IExportMarks2KMLConfigStatic = interface
    ['{19E357D9-248B-44FB-93F0-9CCDBD1748FF}']
    function GetUseCoordFormatting: Boolean;
    property UseCoordFormatting: Boolean read GetUseCoordFormatting;

    function GetCoordPrecision: Integer;
    property CoordPrecision: Integer read GetCoordPrecision;

    function GetSortingType: TKmlSortingType;
    property SortingType: TKmlSortingType read GetSortingType;

    function GetIconScaleType: TKmlIconScaleType;
    property IconScaleType: TKmlIconScaleType read GetIconScaleType;

    function GetUseAbsPathToIcon: Boolean;
    property UseAbsPathToIcon: Boolean read GetUseAbsPathToIcon;

    function GetAbsPathToIcon: string;
    property AbsPathToIcon: string read GetAbsPathToIcon;
  end;

  IExportMarks2KMLConfig = interface(IExportConfig)
    ['{D9088CC7-6B52-46C0-AFC7-6F905BF5A96F}']
    function GetUseCoordFormatting: Boolean;
    procedure SetUseCoordFormatting(const AValue: Boolean);
    property UseCoordFormatting: Boolean read GetUseCoordFormatting write SetUseCoordFormatting;

    function GetCoordPrecision: Integer;
    procedure SetCoordPrecision(const AValue: Integer);
    property CoordPrecision: Integer read GetCoordPrecision write SetCoordPrecision;

    function GetSortingType: TKmlSortingType;
    procedure SetSortingType(const AValue: TKmlSortingType);
    property SortingType: TKmlSortingType read GetSortingType write SetSortingType;

    function GetIconScaleType: TKmlIconScaleType;
    procedure SetIconScaleType(const AValue: TKmlIconScaleType);
    property IconScaleType: TKmlIconScaleType read GetIconScaleType write SetIconScaleType;

    function GetUseAbsPathToIcon: Boolean;
    procedure SetUseAbsPathToIcon(const AValue: Boolean);
    property UseAbsPathToIcon: Boolean read GetUseAbsPathToIcon write SetUseAbsPathToIcon;

    function GetAbsPathToIcon: string;
    procedure SetAbsPathToIcon(const AValue: string);
    property AbsPathToIcon: string read GetAbsPathToIcon write SetAbsPathToIcon;

    function GetStatic: IExportMarks2KMLConfigStatic;
  end;

implementation

end.
