{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit i_BerkeleyDBKeyValue;

interface

uses
  Types;

type
  //   key/value
  IBerkeleyDBKeyValueBase = interface
    ['{D3EDE8C5-CF68-428F-A63B-B815F363F021}']
    function Assign(
      const AData: Pointer;
      const ASize: Integer;
      const AOwnMem: Boolean
    ): Boolean;

    function GetData: Pointer;
    property Data: Pointer read GetData;

    function GetSize: Integer;
    property Size: Integer read GetSize;
  end;

  //  key (8 )
  IBerkeleyDBKey = interface(IBerkeleyDBKeyValueBase)
    ['{FD32450C-AC56-4B80-89C8-293C778A37C1}']
    function GetPoint: TPoint;
    property Point: TPoint read GetPoint;
  end;

  //  key (10 )
  IBerkeleyDBVersionedKey = interface(IBerkeleyDBKey)
    ['{3A4C614E-F835-40F1-8471-339C3807A629}']
    function GetVersionID: Word;
    property VersionID: Word read GetVersionID;
  end;

  // Value     
  IBerkeleyDBValue = interface(IBerkeleyDBKeyValueBase)
    ['{47E2D6BD-598E-4C5A-892C-968117885975}']
    function GetTileBody: Pointer;
    property TileBody: Pointer read GetTileBody;

    function GetTileSize: Integer;
    property TileSize: Integer read GetTileSize;

    function GetTileDate: TDateTime;
    property TileDate: TDateTime read GetTileDate;

    function GetTileVersionInfo: string;
    property TileVersionInfo: string read GetTileVersionInfo;

    function GetTileContentType: AnsiString;
    property TileContentType: AnsiString read GetTileContentType;
  end;

  //    -     (*.sdb)
  IBerkeleyDBMetaKey = interface(IBerkeleyDBKey)
    ['{32DAFA1B-03DE-49AD-B66E-8FCBBBBD6B74}']
  end;

  IBerkeleyDBMetaValue = interface(IBerkeleyDBKeyValueBase)
    ['{F15DC7B4-8D53-4FA8-81A6-AC17CF0C5749}']
    function GetStorageEPSG: Integer;
    property StorageEPSG: Integer read GetStorageEPSG;
  end;

  //     -    
  IBerkeleyDBVersionedMetaKey = interface(IBerkeleyDBVersionedKey)
    ['{B86D06BF-F013-4B38-8FD7-0C09005C080D}']
  end;

  IBerkeleyDBVersionedMetaValueElement = interface(IBerkeleyDBKeyValueBase)
    ['{9D8A8DBC-70E5-460F-B48F-AD8EE4D3F0DA}']
    function GetVersionID: Word;
    property VersionID: Word read GetVersionID;

    function GetTileZOrder: Word;
    property TileZOrder: Word read GetTileZOrder;

    function GetTileSize: Integer;
    property TileSize: Integer read GetTileSize;

    function GetTileDate: TDateTime;
    property TileDate: TDateTime read GetTileDate;

    function GetTileCRC: Cardinal;
    property TileCRC: Cardinal read GetTileCRC;

    function GetTileVersionInfo: string;
    property TileVersionInfo: string read GetTileVersionInfo;

    function GetTileContentType: AnsiString;
    property TileContentType: AnsiString read GetTileContentType;
  end;

  IBerkeleyDBVersionedMetaValue = interface(IBerkeleyDBKeyValueBase)
    ['{AC723A9F-2397-4D0E-B5F3-1E278F60ECC6}']
    function GetCount: Integer;
    property ItemsCount: Integer read GetCount;

    function GetItem(const AIndex: Integer): IBerkeleyDBVersionedMetaValueElement;
    property Item[const AIndex: Integer]: IBerkeleyDBVersionedMetaValueElement read GetItem;

    function Add(const AItem: IBerkeleyDBVersionedMetaValueElement): Integer;

    procedure Replace(
      const AIndex: Integer;
      const AItem: IBerkeleyDBVersionedMetaValueElement
    );

    procedure Del(const AIndex: Integer);
  end;

implementation

end.
