{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit u_VectorTileRendererChangeableForMarksLayer;

interface

uses
  i_MarksDrawConfig,
  i_Bitmap32BufferFactory,
  i_GeometryProjectedProvider,
  i_ListenerNotifierLinksList,
  i_MarkerProviderForVectorItem,
  i_VectorTileRenderer,
  i_VectorTileRendererChangeable,
  u_ChangeableBase;

type
  TVectorTileRendererChangeableForMarksLayer = class(TChangeableWithSimpleLockBase, IVectorTileRendererChangeable)
  private
    FCaptionDrawConfig: ICaptionDrawConfig;
    FBitmap32StaticFactory: IBitmap32StaticFactory;
    FProjectedProvider: IGeometryProjectedProvider;
    FMarkerProvider: IMarkerProviderForVectorItem;

    FLinksList: IListenerNotifierLinksList;
    FResult: IVectorTileRenderer;
    procedure OnConfigChange;
  private
    function GetStatic: IVectorTileRenderer;
  public
    constructor Create(
      const ACaptionDrawConfig: ICaptionDrawConfig;
      const ABitmap32StaticFactory: IBitmap32StaticFactory;
      const AProjectedProvider: IGeometryProjectedProvider;
      const AMarkerProvider: IMarkerProviderForVectorItem
    );
  end;

implementation

uses
  u_ListenerByEvent,
  u_ListenerNotifierLinksList,
  u_VectorTileRendererForMarks;

{ TBitmapLayerProviderChangeableForMarksLayer }

constructor TVectorTileRendererChangeableForMarksLayer.Create(
  const ACaptionDrawConfig: ICaptionDrawConfig;
  const ABitmap32StaticFactory: IBitmap32StaticFactory;
  const AProjectedProvider: IGeometryProjectedProvider;
  const AMarkerProvider: IMarkerProviderForVectorItem
);
begin
  Assert(Assigned(ACaptionDrawConfig));
  Assert(Assigned(ABitmap32StaticFactory));
  Assert(Assigned(AProjectedProvider));
  Assert(Assigned(AMarkerProvider));
  inherited Create;
  FCaptionDrawConfig := ACaptionDrawConfig;
  FBitmap32StaticFactory := ABitmap32StaticFactory;
  FProjectedProvider := AProjectedProvider;
  FMarkerProvider := AMarkerProvider;

  FLinksList := TListenerNotifierLinksList.Create;

  FLinksList.Add(
    TNotifyNoMmgEventListener.Create(Self.OnConfigChange),
    FCaptionDrawConfig.ChangeNotifier
  );
  FLinksList.ActivateLinks;
  OnConfigChange;
end;

function TVectorTileRendererChangeableForMarksLayer.GetStatic: IVectorTileRenderer;
begin
  CS.BeginRead;
  try
    Result := FResult;
  finally
    CS.EndRead;
  end;
end;

procedure TVectorTileRendererChangeableForMarksLayer.OnConfigChange;
var
  VResult: IVectorTileRenderer;
begin
  VResult :=
    TVectorTileRendererForMarks.Create(
      FCaptionDrawConfig.GetStatic,
      FBitmap32StaticFactory,
      FProjectedProvider,
      FMarkerProvider
    );

  CS.BeginWrite;
  try
    FResult := VResult;
  finally
    CS.EndWrite;
  end;
  DoChangeNotify;
end;

end.
