{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit u_RegionProcessProgressInfoInternalFactory;

interface

uses
  i_GeometryLonLat,
  i_RegionProcessProgressInfo,
  i_MapViewGoto,
  i_RegionProcess,
  i_NotifierOperation,
  i_NotifierTime,
  i_RegionProcessProgressInfoInternalFactory,
  u_BaseInterfacedObject;

type
  TRegionProcessProgressInfoInternalFactory = class(TBaseInterfacedObject, IRegionProcessProgressInfoInternalFactory)
  private
    FAppClosingNotifier: INotifierOneOperation;
    FTimerNoifier: INotifierTime;
    FMapGoto: IMapViewGoto;
    FRegionProcess: IRegionProcess;
  private
    function Build(
      const APolygon: IGeometryLonLatPolygon
    ): IRegionProcessProgressInfoInternal;
  public
    constructor Create(
      const AAppClosingNotifier: INotifierOneOperation;
      const ATimerNoifier: INotifierTime;
      const ARegionProcess: IRegionProcess;
      const AMapGoto: IMapViewGoto
    );
  end;

implementation

uses
  Forms,
  u_RegionProcessProgressInfo,
  u_NotifierOperation,
  u_Notifier,
  u_Synchronizer,
  frm_ProgressSimple;

{ TRegionProcessProgressInfoInternalFactory }

constructor TRegionProcessProgressInfoInternalFactory.Create(
  const AAppClosingNotifier: INotifierOneOperation;
  const ATimerNoifier: INotifierTime;
  const ARegionProcess: IRegionProcess;
  const AMapGoto: IMapViewGoto
);
begin
  inherited Create;
  FAppClosingNotifier := AAppClosingNotifier;
  FTimerNoifier := ATimerNoifier;
  FRegionProcess := ARegionProcess;
  FMapGoto := AMapGoto;
end;

function TRegionProcessProgressInfoInternalFactory.Build(
  const APolygon: IGeometryLonLatPolygon
): IRegionProcessProgressInfoInternal;
var
  VCancelNotifierInternal: INotifierOperationInternal;
  VProgressInfo: TRegionProcessProgressInfo;
  VOperationID: Integer;
begin
  VCancelNotifierInternal :=
    TNotifierOperation.Create(
      TNotifierBase.Create(GSync.SyncVariable.Make(Self.ClassName + 'Notifier'))
    );
  VOperationID := VCancelNotifierInternal.CurrentOperation;
  VProgressInfo := TRegionProcessProgressInfo.Create(VCancelNotifierInternal, VOperationID);
  Result := VProgressInfo;

  TfrmProgressSimple.Create(
    Application,
    FAppClosingNotifier,
    FTimerNoifier,
    VCancelNotifierInternal,
    VProgressInfo,
    FRegionProcess,
    FMapGoto,
    APolygon
  );
end;

end.
