{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit u_MarkSystemImplConfigORM;

interface

uses
  SynTable,
  SynCommons,
  i_MarkSystemImplConfigORM,
  u_MarkSystemImplConfigBase;

type
  TMarkSystemImplConfigORM = class(TMarkSystemImplConfigBase, IMarkSystemImplConfigORM)
  private
    FSynUser: TSynUserPassword;
    FCacheSizeMb: Cardinal;
    FForcedSchemaName: string;
  private
    { IMarkSystemImplConfigORM }
    function GetUserName: string;
    function GetPassword: string;
    function GetPasswordPlain: string;
    function GetCacheSizeMb: Cardinal;
    function GetForcedSchemaName: string;
  public
    constructor Create(
      const AFileName: string;
      const AIsReadOnly: Boolean;
      const AUserName: string;
      const APasswordPlain: string;
      const APassword: string;
      const ACacheSizeMb: Cardinal = 100;
      const AForcedSchemaName: string = ''
    );
    destructor Destroy; override;
  end;

implementation

uses
  SysUtils;

{ TMarkSystemImplConfigORM }

constructor TMarkSystemImplConfigORM.Create(
  const AFileName: string;
  const AIsReadOnly: Boolean;
  const AUserName: string;
  const APasswordPlain: string;
  const APassword: string;
  const ACacheSizeMb: Cardinal;
  const AForcedSchemaName: string
);
begin
  inherited Create(AFileName, AIsReadOnly);
  FCacheSizeMb := ACacheSizeMb;
  FForcedSchemaName := Trim(AForcedSchemaName);
  FSynUser := TSynUserPassword.Create;
  FSynUser.UserName := StringToUTF8(AUserName);
  if APasswordPlain <> '' then begin
    FSynUser.PasswordPlain := StringToUTF8(APasswordPlain);
  end else begin
    FSynUser.Password := StringToUTF8(APassword);
  end;
end;

destructor TMarkSystemImplConfigORM.Destroy;
begin
  FreeAndNil(FSynUser);
  inherited Destroy;
end;

function TMarkSystemImplConfigORM.GetUserName: string;
begin
  Result := UTF8ToString(FSynUser.UserName);
end;

function TMarkSystemImplConfigORM.GetPassword: string;
begin
  Result := UTF8ToString(FSynUser.Password);
end;

function TMarkSystemImplConfigORM.GetPasswordPlain: string;
begin
  Result := UTF8ToString(FSynUser.PasswordPlain);
end;

function TMarkSystemImplConfigORM.GetCacheSizeMb: Cardinal;
begin
  Result := FCacheSizeMb;
end;

function TMarkSystemImplConfigORM.GetForcedSchemaName: string;
begin
  Result := FForcedSchemaName;
end;

end.
