{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit u_MapCalibrationListBasic;

interface

uses
  i_InterfaceListStatic,
  i_MapCalibration,
  u_BaseInterfacedObject;

type
  TMapCalibrationListByInterfaceList = class(TBaseInterfacedObject, IMapCalibrationList)
  private
    FList: IInterfaceListStatic;
  private
    function GetCount: Integer;
    function Get(AIndex: Integer): IMapCalibration;
  public
    constructor Create(const AList: IInterfaceListStatic);
  end;

  TMapCalibrationListBasic = class(TMapCalibrationListByInterfaceList)
  public
    constructor Create;
  end;

implementation

uses
  i_InterfaceListSimple,
  u_InterfaceListSimple,
  u_MapCalibrationOzi,
  u_MapCalibrationDat,
  u_MapCalibrationKml,
  u_MapCalibrationTab,
  u_MapCalibrationWorldFiles;

{ TMapCalibrationListByInterfaceList }

constructor TMapCalibrationListByInterfaceList.Create(const AList: IInterfaceListStatic);
begin
  inherited Create;
  FList := AList;
end;

function TMapCalibrationListByInterfaceList.Get(
  AIndex: Integer
): IMapCalibration;
begin
  Result := IMapCalibration(FList.Items[AIndex]);
end;

function TMapCalibrationListByInterfaceList.GetCount: Integer;
begin
  if Assigned(FList) then begin
    Result := FList.Count;
  end else begin
    Result := 0;
  end;
end;

{ TMapCalibrationListBasic }

constructor TMapCalibrationListBasic.Create;
var
  VList: IInterfaceListSimple;
begin
  VList := TInterfaceListSimple.Create;
  VList.Add(IMapCalibration(TMapCalibrationOzi.Create));
  VList.Add(IMapCalibration(TMapCalibrationDat.Create));
  VList.Add(IMapCalibration(TMapCalibrationKml.Create));
  VList.Add(IMapCalibration(TMapCalibrationTab.Create));
  VList.Add(IMapCalibration(TMapCalibrationWorldFiles.Create));
  VList.Add(IMapCalibration(TMapCalibrationWorldFiles.Create(True)));
  inherited Create(VList.MakeStaticAndClear);
end;

end.
