{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit i_Bitmap32BufferFactory;

interface

uses
  Types,
  t_Bitmap32,
  i_Bitmap32Static;

type
  IBitmap32BufferFactory = interface
    ['{F110B8E7-76D3-48C4-BE8B-B75E5F374355}']
    function Build(
      const ASize: TPoint;
      const AData: PColor32Array
    ): IBitmap32Buffer;
    function BuildEmpty(const ASize: TPoint): IBitmap32Buffer;
    function BuildEmptyClear(
      const ASize: TPoint;
      const AColor: TColor32
    ): IBitmap32Buffer;
  end;

  IBitmap32StaticFactory = interface
    ['{44AAF1CE-E8F6-4724-B3E7-9EBBC9BAC1CB}']
    function GetBufferFactory: IBitmap32BufferFactory;
    property BufferFactory: IBitmap32BufferFactory read GetBufferFactory;

    function Build(
      const ASize: TPoint;
      const AData: PColor32Array
    ): IBitmap32Static;
    function BuildWithOwnBuffer(const ABuffer: IBitmap32Buffer): IBitmap32Static;
  end;

implementation

end.
