{******************************************************************************}
{* This file is part of SAS.Planet project.                                   *}
{*                                                                            *}
{* Copyright (C) 2007-2022, SAS.Planet development team.                      *}
{*                                                                            *}
{* SAS.Planet is free software: you can redistribute it and/or modify         *}
{* it under the terms of the GNU General Public License as published by       *}
{* the Free Software Foundation, either version 3 of the License, or          *}
{* (at your option) any later version.                                        *}
{*                                                                            *}
{* SAS.Planet is distributed in the hope that it will be useful,              *}
{* but WITHOUT ANY WARRANTY; without even the implied warranty of             *}
{* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               *}
{* GNU General Public License for more details.                               *}
{*                                                                            *}
{* You should have received a copy of the GNU General Public License          *}
{* along with SAS.Planet. If not, see <http://www.gnu.org/licenses/>.         *}
{*                                                                            *}
{* https://github.com/sasgis/sas.planet.src                                   *}
{******************************************************************************}

unit u_BenchmarkItemSyncRead;

interface

uses
  SysUtils,
  u_BenchmarkItemBase;

type
  TBenchmarkItemSyncRead = class(TBenchmarkItemBase)
  private
    FSync: IReadWriteSync;
    FData: Integer;
  protected
    function RunOneStep: Integer; override;
  public
    constructor Create(
      const ASyncName: string;
      const ASync: IReadWriteSync
    );
  end;

implementation

const CRepeatCount = 1000;

{ TBenchmarkItemSyncRead }

constructor TBenchmarkItemSyncRead.Create(
  const ASyncName: string;
  const ASync: IReadWriteSync
);
begin
  inherited Create(
    Assigned(ASync),
    'Sync ' + ASyncName + ' Read Lock',
    CRepeatCount
  );
  FSync := ASync;
end;

function TBenchmarkItemSyncRead.RunOneStep: Integer;
var
  i: Integer;
begin
  for i := 0 to CRepeatCount - 1 do begin
    FSync.BeginRead;
    try
      Inc(FData);
    finally
      FSync.EndRead;
    end;
  end;
  Result := FData;
end;

end.
