# Summise - Modern OpenAI GPT-4 Article Summarizer

![Modern OpenAI GPT-4 Article Summarizer](/.github/images/img_main.png "Modern OpenAI GPT-4 Article Summarizer")

[![Ask Me Anything!](https://img.shields.io/badge/Ask%20me-anything-1abc9c.svg)](https://github.com/Technical-Shubham-tech "Ask Me Anything!")
[![GitHub license](https://img.shields.io/github/license/Technical-Shubham-tech/ai-summarizer)](https://github.com/Technical-Shubham-tech/ai-summarizer/blob/main/LICENSE.md "GitHub license")
[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/Technical-Shubham-tech/ai-summarizer/commits/main "Maintenance")
[![GitHub branches](https://badgen.net/github/branches/Technical-Shubham-tech/ai-summarizer)](https://github.com/Technical-Shubham-tech/ai-summarizer/branches "GitHub branches")
[![Github commits](https://badgen.net/github/commits/Technical-Shubham-tech/ai-summarizer/main)](https://github.com/Technical-Shubham-tech/ai-summarizer/commits "Github commits")
[![Netlify Status](https://api.netlify.com/api/v1/badges/4b406197-21d8-4e96-9fdd-52c782540f0e/deploy-status)](https://summise.netlify.app/ "Netlify Status")
[![GitHub issues](https://img.shields.io/github/issues/Technical-Shubham-tech/ai-summarizer)](https://github.com/Technical-Shubham-tech/ai-summarizer/issues "GitHub issues")
[![GitHub pull requests](https://img.shields.io/github/issues-pr/Technical-Shubham-tech/ai-summarizer)](https://github.com/Technical-Shubham-tech/ai-summarizer/pulls "GitHub pull requests")

## ⚠️ Before you start

1. Make sure **Git** and **NodeJS** is installed.
2. Clone this repository to your local computer.
3. Create .env file in root folder.
4. Contents of **.env**:

```
VITE_RAPIDAPI_ARTICLE_KEY=XXXXXXXXXXXXXXXXXXXXXXX
```

5.  Now, to setup Article Summarizer API, go to [Rapid API Website](https://rapidapi.com/) and create an account.

6.  Enable this API to fetch music data: [API: Article Extractor and Summarizer by Anthony](https://rapidapi.com/restyler/api/article-extractor-and-summarizer "API: Article Extractor and Summarizer by Anthony").

![Copy API Key](/.github/images/step_api.png "Copy API Key")

7. After enabling you can get your API Keys and paste them in `.env` file in `VITE_RAPIDAPI_ARTICLE_KEY`.

8. Open terminal and run `npm install` or `yarn install` in root folder to install necessary packages.

9. Now app is fully configured :+1: and you can start using this app using `npm run dev` or `yarn dev`.

**NOTE:** Make sure you don't share these keys publicaly.

## :camera: Screenshots:

![Modern UI/UX](/.github/images/img1.png "Modern UI/UX")

![Generate Article Summary](/.github/images/img2.png "Generate Article Summary")

![Chat GPT-4 AI Model](/.github/images/img3.png "Chat GPT-4 AI Model")

## :gear: Built with

[![JavaScript](https://skillicons.dev/icons?i=js)](https://developer.mozilla.org/en-US/docs/Web/JavaScript "JavaScript") [![React JS](https://skillicons.dev/icons?i=react)](https://react.dev/ "React JS") [![Tailwind CSS](https://skillicons.dev/icons?i=tailwind)](https://tailwindcss.com/ "Tailwind CSS") [![Vite](https://skillicons.dev/icons?i=vite)](https://vitejs.dev/ "Vite")

## :wrench: Stats

[![Stats for this App](/.github/images/stats.svg)](https://pagespeed.web.dev/ "Stats for this App")

## :raised_hands: Contribute

You might encounter some bugs while using this app. You are more than welcome to contribute. Just submit changes via pull request and I will review them before merging. Make sure you follow community guidelines.

## Buy Me a Coffee 🍺

[<img src="https://img.shields.io/badge/Buy_Me_A_Coffee-FFDD00?style=for-the-badge&logo=buy-me-a-coffee&logoColor=black" width="200" />](https://www.buymeacoffee.com/sanidhy "Buy me a Coffee")

## :rocket: Follow Me

[![GitHub followers](https://img.shields.io/github/followers/Technical-Shubham-tech?style=social&label=Follow&maxAge=2592000)](https://github.com/Technical-Shubham-tech "Follow Me")
[![Twitter](https://img.shields.io/twitter/url?style=social&url=https%3A%2F%2Ftwitter.com%2FTechnicalShubam)](https://twitter.com/intent/tweet?text=Wow:&url=https%3A%2F%2Fgithub.com%2FTechnical-Shubham-tech%2Fmedical-chat-app "Tweet")
[![YouTube](https://img.shields.io/badge/YouTube-FF0000?style=for-the-badge&logo=youtube&logoColor=white)](https://www.youtube.com/channel/UCNAz_hUVBG2ZUN8TVm0bmYw "Subscribe my Channel")

## :star: Give A Star

You can also give this repository a star to show more people and they can use this repository.

## :books: Available Scripts

In the project directory, you can run:

### `yarn run dev`

Runs the app in the development mode.\
Open [http://localhost:3000](http://localhost:3000) to view it in your browser.

The page will reload when you make changes.\
You may also see any lint errors in the console.

### `yarn test`

Launches the test runner in the interactive watch mode.\
See the section about [running tests](https://facebook.github.io/create-react-app/docs/running-tests) for more information.

### `yarn run build`

Builds the app for production to the `dist` folder.\
It correctly bundles React in production mode and optimizes the build for the best performance.

The build is minified and the filenames include the hashes.\
Your app is ready to be deployed!

See the section about [deployment](https://facebook.github.io/create-react-app/docs/deployment) for more information.

### `yarn eject`

**Note: this is a one-way operation. Once you `eject`, you can't go back!**

If you aren't satisfied with the build tool and configuration choices, you can `eject` at any time. This command will remove the single build dependency from your project.

Instead, it will copy all the configuration files and the transitive dependencies (webpack, Babel, ESLint, etc) right into your project so you have full control over them. All of the commands except `eject` will still work, but they will point to the copied scripts so you can tweak them. At this point you're on your own.

You don't have to ever use `eject`. The curated feature set is suitable for small and middle deployments, and you shouldn't feel obligated to use this feature. However we understand that this tool wouldn't be useful if you couldn't customize it when you are ready for it.

## :page_with_curl: Learn More

You can learn more in the [Create React App documentation](https://facebook.github.io/create-react-app/docs/getting-started).

To learn React, check out the [React documentation](https://reactjs.org/).

### Code Splitting

This section has moved here: [https://facebook.github.io/create-react-app/docs/code-splitting](https://facebook.github.io/create-react-app/docs/code-splitting)

### Analyzing the Bundle Size

This section has moved here: [https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size](https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size)

### Making a Progressive Web App

This section has moved here: [https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app](https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app)

### Advanced Configuration

This section has moved here: [https://facebook.github.io/create-react-app/docs/advanced-configuration](https://facebook.github.io/create-react-app/docs/advanced-configuration)

### Deployment

This section has moved here: [https://facebook.github.io/create-react-app/docs/deployment](https://facebook.github.io/create-react-app/docs/deployment)

### `yarn run build` fails to minify

This section has moved here: [https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify](https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify)
