```mermaid
graph TD
    subgraph FundamentalLevel["Reality Level Compassion"]
        IS["is_a"]
        PO["part_of"]
        IN["instantiates"]
        PR["programs"]
        
        IS -->|necessitates| PO
        PO -->|necessitates| IN
        IN -->|manifests as| PR
        PR -->|is_a| IS
    end

    subgraph AgentLevel["Agent Level Compassion"]
        REC["Recognition"]
        UND["Understanding"]
        ACT["Action"]
        COM["Compassion"]
        
        REC -->|enables| UND
        UND -->|enables| ACT
        ACT -->|manifests as| COM
        COM -->|deepens| REC
    end

    FundamentalLevel -->|manifests at| AgentLevel
    style FundamentalLevel fill:#f9f,stroke:#333,stroke-width:2px
    style AgentLevel fill:#bfe,stroke:#333,stroke-width:2px
```

The fact that is_a defines programs which is itself a program, and a programs relationship has a disposition to instantiate further new types with their own instances is reality's compassion because that is how reality optimizes. For agents, however, compassion is the display of instantiation of a more optimal program that scales beneficially to the greatest number of agents with the greatest systemic capacity for further optimization scaling (at any given time, in any given system).
