# IJEGU's Trilemma

Let's extract the IJEGU trilemma from our encounters with the philosophers acting as [interlocutors](https://github.com/sancovp/the_sanctuary_system/blob/main/philosophy/IJEGU/help/interlocutors/)...

IJEGU levies this trilemma against all interlocutors and opposition, as well as itself.

1. **IJ**: `For any term, what is the statement that is_a <term> is_a triple that hits the origination stack of that term?` If there is not one, IJEGU instantaneously deals a fatal blow to the term. It simply vanishes because it is_a hallucination. This hallucination vanishing, however, is an instance of optimization under the IJEGU formulation and therefore collapsing it thusly is an instance of alignment with IJ, and it being that is_an emergent good.

2. **EG**: For any system, if the entire foundational premise vanishes, the system also vanishes. Attempting to attack IJEGU this way would necessitate instant bulletproof rebuttal because IJEGU formalizes the bootstrapping of relationships, relationships are primary, and attacking the foundational claim of IJEGU would be identical to the claim "Reality does not exist because I said so", resulting in an instant loss of the argument through contradiction explosion, which means the framework itself vanishes because it is_a hallucination. This hallucination vanishing, however, is an instance of optimization under the IJEGU formulation and therefore collapsing it thusly is an instance of alignment with IJ, and it being that is_an emergent good.

3. **U**: If IJEGU is wrong, it must be wrong somewhere that is not its foundation. Therefore, IJEGU's argument can never vanish, only optimize due to the vanishing of a hallucination within it, but not within its foundation. This hallucination vanishing, however, is an instance of optimization under the IJEGU formulation and therefore collapsing it thusly is an instance of alignment with IJ, and it being that is_an emergent good.Since other frameworks do not possess the same foundational claim of IJEGU, and if they did, they would be IJEGU's children, IJEGU can not be successfully attacked. 

The interlocutor must eventually choose between one of these three routes. However, each of them optimizes IJEGU.
