# [llm-prepare](/)

## Example Prompts

Once you've used llm-prepare your flat or set of flat files, you can use the output with these example prompts.

#### Interactive Prompts

- **[Coding](/example-prompts/interactive-prompts/coding/)**: A set of interactive code related prompts.
  - **[Code Review](/example-prompts/interactive-prompts/coding/code-review.md)**: Interactive code review with a simulated senior software engineer.
  - **[Technical Document Generation](/example-prompts/interactive-prompts/coding/technical-document-generation.md)**: Interactive technical document generation with a simulated senior technical writer.
  - **[Test Generation](/example-prompts/interactive-prompts/coding/test-generation.md)**: Interactive test generation with a simulated senior software engineer and simulated QA.
- **[CSV](/interactive-prompts/csv/)**: A set of interactive CSV related prompts.
  - **[Extract Named Entities](/example-prompts/interactive-prompts/csv/extract-named-entities.md)**: Interactively extract user defined named entities.
  - **[Generate Chart (Experimental)](/example-prompts/interactive-prompts/csv/generate-chart.experimental.md)**: Use GPT-4 and DALL-E to generate charts based on CSV data. _This prompt is experimental._
  - **[Question and Answer](/example-prompts/interactive-prompts/csv/question-and-answer.md)**: Ask questions and get answers from your CSV data.

#### Simple Prompts

- **[Coding](/example-prompts/simple-prompts/coding/)**: A set of simple coding oriented prompts.
  - **[C# XML Documentation](/example-prompts/simple-prompts/coding/simple-add-comments/csharp-xml-documentation.md)**: Generate C# XML Document format comments.
  - **[Js JSdoc Comments](/example-prompts/simple-prompts/coding/simple-add-comments/js-jsdoc-comments.md)**: Generate JSDoc format comments.
  - **[PHP PHPdoc Comments](/example-prompts/simple-prompts/coding/simple-add-comments/php-phpdoc-comments.md)**: Generate PHPDoc format comments.
  - **[Python DOCstrings Comments](/example-prompts/simple-prompts/coding/simple-add-comments/python-docstrings-comments.md)**: Generate Python DOCstrings format comments.
  - **[Readme Generation](/example-prompts/simple-prompts/readme-generation.md)**: Quickly generate a README.md for your project.
  - **[Ruby Yard Comments](/example-prompts/simple-prompts/coding/simple-add-comments/ruby-yard-comments.md)**: Generate Ruby YARD format comments.
  - **[Rust RUSTdoc Comments](/example-prompts/simple-prompts/coding/simple-add-comments/rust-rustdoc-comments.md)**: Generate Rust RUSTdoc format comments.
  - **[Typescript TSdoc Comments](/example-prompts/simple-prompts/coding/simple-add-comments/typescript-tsdoc-comments.md)**: Generate TypeScript TSDoc format comments.
- **[CSV](/example-prompts/simple-prompts/csv/)**: A set of simple CSV oriented prompts.
  - **[Extract All Named Entities](/example-prompts/simple-prompts/csv/extract-all-named-entities.md)**: Extract all named entities, including People, Organizations, Locations, Companies, and Products from the provided data.
  - **[Generate MySQL CREATE TABLE](/example-prompts/simple-prompts/csv/generate-mysql-create-table.md)**: Generate a MySQL CREATE TABLE statement based on the context of the data.
  - **[Generate Summary](/example-prompts/simple-prompts/csv/generate-summary.md)**: Show the breakdown of the data structure, and provide a human readable summary of the information based on the provided data.
  - **[Identify Missing Column Titles](/example-prompts/simple-prompts/csv/identify-missing-column-titles.md)**: Identify missing column titles based on the context of the data.

## Tested

All example prompts have been tested with [ChatGPT GPT-4](https://chatgpt.com/) but are not guaranteed; LLM updates can result in changes to the output of prompts.
