/* eslint-disable max-len */
import { labelForFilmSimulation } from '@/vendors/fujifilm';
import { CSSProperties } from 'react';
import { FilmSimulation } from '.';

const INTRINSIC_WIDTH = 28;
const INTRINSIC_HEIGHT = 16;

export default function PhotoFilmSimulationIcon({
  simulation,
  height = INTRINSIC_HEIGHT,
  className,
  style,
}: {
  simulation?: FilmSimulation
  height?: number
  className?: string
  style?: CSSProperties
}) {
  return (
    <svg
      className={className}
      style={style}
      aria-description={simulation
        ? labelForFilmSimulation(simulation).large
        : 'Film Simulation'}
      width={INTRINSIC_WIDTH * height / INTRINSIC_HEIGHT}
      height={height}
      viewBox="0 0 28 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      {(() => {
        // Self-calling switch function and non-fragment groups
        // necessary for ImageResponse compatibility
        switch (simulation) {
        case 'monochrome': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M16.25 14H22.5C22.6381 14 22.75 13.8881 22.75 13.75V10.5202C22.75 10.4539 22.7763 10.3903 22.8232 10.3434L25.677 7.48989C25.7238 7.44301 25.7502 7.37942 25.7502 7.31311V4.25C25.7502 4.11193 25.6383 4 25.5002 4H16.25C16.1119 4 16 4.11194 16 4.25002L16.0002 6.49998C16.0002 6.63806 15.8882 6.75 15.7502 6.75H14.7502C14.6121 6.75 14.5002 6.86192 14.5002 6.99999L14.5 11C14.5 11.1381 14.6119 11.25 14.75 11.25H15.75C15.8881 11.25 16 11.3619 16 11.5V13.75C16 13.8881 16.1119 14 16.25 14ZM18.75 5H17V6.5H18.75V5ZM17 11.5H18.75V13H17V11.5ZM21.75 5H20V6.5H21.75V5ZM20 11.5H21.75V13H20V11.5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.03232 4.7985H5.38982V13H9.36132C9.65899 13 9.92532 12.9412 10.1603 12.8237C10.3953 12.6984 10.5951 12.53 10.7596 12.3185C10.9241 12.107 11.0494 11.8602 11.1356 11.5782C11.2217 11.2884 11.2648 10.9829 11.2648 10.6617C11.2648 10.3328 11.2139 10.0547 11.1121 9.8275C11.0102 9.5925 10.8771 9.4045 10.7126 9.2635C10.5481 9.11467 10.364 9.00892 10.1603 8.94625C9.96449 8.88358 9.77257 8.85225 9.58457 8.85225V8.66425C9.7569 8.65642 9.92532 8.62508 10.0898 8.57025C10.2543 8.50758 10.3992 8.41358 10.5246 8.28825C10.6577 8.15508 10.7635 7.97883 10.8418 7.7595C10.928 7.53233 10.9711 7.24642 10.9711 6.90175C10.9711 6.26725 10.8105 5.75808 10.4893 5.37425C10.176 4.99042 9.69032 4.7985 9.03232 4.7985ZM8.89132 11.5782H7.07007V9.55725H8.89132C9.07932 9.55725 9.22815 9.61208 9.33782 9.72175C9.45532 9.83142 9.51407 10.0155 9.51407 10.274V10.8615C9.51407 11.12 9.45532 11.3041 9.33782 11.4137C9.22815 11.5234 9.07932 11.5782 8.89132 11.5782ZM8.62107 8.17075H7.07007V6.22025H8.62107C8.8169 6.22025 8.96965 6.27508 9.07932 6.38475C9.18899 6.49442 9.24382 6.67458 9.24382 6.92525V7.46575C9.24382 7.71642 9.18899 7.89658 9.07932 8.00625C8.96965 8.11592 8.8169 8.17075 8.62107 8.17075Z" fill="currentColor"/>
        </g>;
        case 'monochrome-ye': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.03732 4.7985H5.39482V13H9.36632C9.66399 13 9.93032 12.9412 10.1653 12.8237C10.4003 12.6984 10.6001 12.53 10.7646 12.3185C10.9291 12.107 11.0544 11.8602 11.1406 11.5782C11.2267 11.2884 11.2698 10.9829 11.2698 10.6617C11.2698 10.3328 11.2189 10.0547 11.1171 9.8275C11.0152 9.5925 10.8821 9.4045 10.7176 9.2635C10.5531 9.11467 10.369 9.00892 10.1653 8.94625C9.96949 8.88358 9.77757 8.85225 9.58957 8.85225V8.66425C9.7619 8.65642 9.93032 8.62508 10.0948 8.57025C10.2593 8.50758 10.4042 8.41358 10.5296 8.28825C10.6627 8.15508 10.7685 7.97883 10.8468 7.7595C10.933 7.53233 10.9761 7.24642 10.9761 6.90175C10.9761 6.26725 10.8155 5.75808 10.4943 5.37425C10.181 4.99042 9.69532 4.7985 9.03732 4.7985ZM8.89632 11.5782H7.07507V9.55725H8.89632C9.08432 9.55725 9.23315 9.61208 9.34282 9.72175C9.46032 9.83142 9.51907 10.0155 9.51907 10.274V10.8615C9.51907 11.12 9.46032 11.3041 9.34282 11.4137C9.23315 11.5234 9.08432 11.5782 8.89632 11.5782ZM8.62607 8.17075H7.07507V6.22025H8.62607C8.8219 6.22025 8.97465 6.27508 9.08432 6.38475C9.19399 6.49442 9.24882 6.67458 9.24882 6.92525V7.46575C9.24882 7.71642 9.19399 7.89658 9.08432 8.00625C8.97465 8.11592 8.8219 8.17075 8.62607 8.17075Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M18.1285 14.5V12.316L16.2165 8.916H17.5765L18.7765 11.14H18.7925L19.9445 8.916H21.2645L19.3525 12.308V14.5H18.1285ZM23.1673 14.596C22.8473 14.596 22.5619 14.5453 22.3113 14.444C22.0606 14.3373 21.8473 14.1907 21.6713 14.004C21.5006 13.812 21.3699 13.58 21.2793 13.308C21.1939 13.036 21.1513 12.732 21.1513 12.396C21.1513 12.0653 21.1939 11.7667 21.2793 11.5C21.3646 11.228 21.4899 10.996 21.6553 10.804C21.8259 10.612 22.0339 10.4653 22.2793 10.364C22.5246 10.2573 22.8046 10.204 23.1193 10.204C23.4659 10.204 23.7619 10.2627 24.0073 10.38C24.2579 10.4973 24.4606 10.6547 24.6153 10.852C24.7753 11.0493 24.8899 11.2787 24.9593 11.54C25.0339 11.796 25.0713 12.0653 25.0713 12.348V12.7H22.3753V12.764C22.3753 13.0413 22.4499 13.2627 22.5993 13.428C22.7486 13.588 22.9833 13.668 23.3033 13.668C23.5486 13.668 23.7486 13.62 23.9033 13.524C24.0579 13.4227 24.2019 13.3027 24.3353 13.164L24.9273 13.9C24.7406 14.1187 24.4953 14.2893 24.1913 14.412C23.8926 14.5347 23.5513 14.596 23.1673 14.596ZM23.1433 11.076C22.9033 11.076 22.7139 11.156 22.5753 11.316C22.4419 11.4707 22.3753 11.6787 22.3753 11.94V12.004H23.8473V11.932C23.8473 11.676 23.7886 11.4707 23.6713 11.316C23.5593 11.156 23.3833 11.076 23.1433 11.076Z" fill="currentColor"/>
        </g>;
        case 'monochrome-r': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.03732 4.7985H5.39482V13H9.36632C9.66399 13 9.93032 12.9412 10.1653 12.8237C10.4003 12.6984 10.6001 12.53 10.7646 12.3185C10.9291 12.107 11.0544 11.8602 11.1406 11.5782C11.2267 11.2884 11.2698 10.9829 11.2698 10.6617C11.2698 10.3328 11.2189 10.0547 11.1171 9.8275C11.0152 9.5925 10.8821 9.4045 10.7176 9.2635C10.5531 9.11467 10.369 9.00892 10.1653 8.94625C9.96949 8.88358 9.77757 8.85225 9.58957 8.85225V8.66425C9.7619 8.65642 9.93032 8.62508 10.0948 8.57025C10.2593 8.50758 10.4042 8.41358 10.5296 8.28825C10.6627 8.15508 10.7685 7.97883 10.8468 7.7595C10.933 7.53233 10.9761 7.24642 10.9761 6.90175C10.9761 6.26725 10.8155 5.75808 10.4943 5.37425C10.181 4.99042 9.69532 4.7985 9.03732 4.7985ZM8.89632 11.5782H7.07507V9.55725H8.89632C9.08432 9.55725 9.23315 9.61208 9.34282 9.72175C9.46032 9.83142 9.51907 10.0155 9.51907 10.274V10.8615C9.51907 11.12 9.46032 11.3041 9.34282 11.4137C9.23315 11.5234 9.08432 11.5782 8.89632 11.5782ZM8.62607 8.17075H7.07507V6.22025H8.62607C8.8219 6.22025 8.97465 6.27508 9.08432 6.38475C9.19399 6.49442 9.24882 6.67458 9.24882 6.92525V7.46575C9.24882 7.71642 9.19399 7.89658 9.08432 8.00625C8.97465 8.11592 8.8219 8.17075 8.62607 8.17075Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M19.8867 14.5H18.6707V8.916H21.3187C21.5747 8.916 21.8067 8.95867 22.0147 9.044C22.2227 9.12933 22.3987 9.252 22.5427 9.412C22.692 9.56667 22.8067 9.75333 22.8867 9.972C22.9667 10.1907 23.0067 10.4333 23.0067 10.7C23.0067 11.0787 22.9214 11.4093 22.7507 11.692C22.5854 11.9747 22.332 12.18 21.9907 12.308L23.0867 14.5H21.7347L20.7587 12.452H19.8867V14.5ZM21.1667 11.428C21.348 11.428 21.4894 11.3827 21.5907 11.292C21.6974 11.196 21.7507 11.0573 21.7507 10.876V10.524C21.7507 10.3427 21.6974 10.2067 21.5907 10.116C21.4894 10.02 21.348 9.972 21.1667 9.972H19.8867V11.428H21.1667Z" fill="currentColor"/>
        </g>;
        case 'monochrome-g': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.03732 4.7985H5.39482V13H9.36632C9.66399 13 9.93032 12.9412 10.1653 12.8237C10.4003 12.6984 10.6001 12.53 10.7646 12.3185C10.9291 12.107 11.0544 11.8602 11.1406 11.5782C11.2267 11.2884 11.2698 10.9829 11.2698 10.6617C11.2698 10.3328 11.2189 10.0547 11.1171 9.8275C11.0152 9.5925 10.8821 9.4045 10.7176 9.2635C10.5531 9.11467 10.369 9.00892 10.1653 8.94625C9.96949 8.88358 9.77757 8.85225 9.58957 8.85225V8.66425C9.7619 8.65642 9.93032 8.62508 10.0948 8.57025C10.2593 8.50758 10.4042 8.41358 10.5296 8.28825C10.6627 8.15508 10.7685 7.97883 10.8468 7.7595C10.933 7.53233 10.9761 7.24642 10.9761 6.90175C10.9761 6.26725 10.8155 5.75808 10.4943 5.37425C10.181 4.99042 9.69532 4.7985 9.03732 4.7985ZM8.89632 11.5782H7.07507V9.55725H8.89632C9.08432 9.55725 9.23315 9.61208 9.34282 9.72175C9.46032 9.83142 9.51907 10.0155 9.51907 10.274V10.8615C9.51907 11.12 9.46032 11.3041 9.34282 11.4137C9.23315 11.5234 9.08432 11.5782 8.89632 11.5782ZM8.62607 8.17075H7.07507V6.22025H8.62607C8.8219 6.22025 8.97465 6.27508 9.08432 6.38475C9.19399 6.49442 9.24882 6.67458 9.24882 6.92525V7.46575C9.24882 7.71642 9.19399 7.89658 9.08432 8.00625C8.97465 8.11592 8.8219 8.17075 8.62607 8.17075Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M22.035 13.612H21.995C21.9523 13.8947 21.8083 14.1293 21.563 14.316C21.3177 14.5027 20.9843 14.596 20.563 14.596C20.243 14.596 19.9443 14.5347 19.667 14.412C19.3897 14.2893 19.147 14.108 18.939 13.868C18.731 13.628 18.5683 13.3293 18.451 12.972C18.3337 12.6147 18.275 12.2013 18.275 11.732C18.275 11.2627 18.3363 10.8467 18.459 10.484C18.5817 10.1213 18.7523 9.81733 18.971 9.572C19.195 9.32667 19.4617 9.14 19.771 9.012C20.0803 8.884 20.4243 8.82 20.803 8.82C21.3043 8.82 21.7363 8.92933 22.099 9.148C22.4617 9.36133 22.747 9.684 22.955 10.116L21.963 10.684C21.8777 10.4653 21.7443 10.2813 21.563 10.132C21.3817 9.97733 21.1283 9.9 20.803 9.9C20.4243 9.9 20.123 10.0093 19.899 10.228C19.675 10.4467 19.563 10.7907 19.563 11.26V12.156C19.563 12.62 19.675 12.964 19.899 13.188C20.123 13.4067 20.4243 13.516 20.803 13.516C20.9523 13.516 21.0937 13.5 21.227 13.468C21.3603 13.4307 21.4777 13.3773 21.579 13.308C21.6803 13.2333 21.7577 13.1453 21.811 13.044C21.8697 12.9427 21.899 12.8227 21.899 12.684V12.404H20.859V11.388H23.059V14.5H22.035V13.612Z" fill="currentColor"/>
        </g>;
        case 'sepia': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.17097 11.8485C5.86814 12.7102 6.83164 13.141 8.06147 13.141C9.00147 13.141 9.71822 12.9138 10.2117 12.4595C10.7052 11.9973 10.952 11.3276 10.952 10.4502C10.952 10.1056 10.9089 9.804 10.8227 9.5455C10.7444 9.287 10.6112 9.06375 10.4232 8.87575C10.2431 8.68775 10.0081 8.535 9.71822 8.4175C9.43622 8.29217 9.09547 8.18642 8.69597 8.10025L7.94397 7.9475C7.65414 7.88483 7.44264 7.783 7.30947 7.642C7.18414 7.501 7.12147 7.29342 7.12147 7.01925C7.12147 6.70592 7.20372 6.47875 7.36822 6.33775C7.54056 6.19675 7.81472 6.12625 8.19072 6.12625C8.53539 6.12625 8.83306 6.18892 9.08372 6.31425C9.34222 6.43175 9.57331 6.61583 9.77697 6.8665L10.858 5.7855C10.2548 5.0335 9.37356 4.6575 8.21422 4.6575C7.30556 4.6575 6.61622 4.86508 6.14622 5.28025C5.67622 5.69542 5.44122 6.3025 5.44122 7.1015C5.44122 7.79083 5.61747 8.33133 5.96997 8.723C6.33031 9.10683 6.89039 9.36925 7.65022 9.51025L8.40222 9.65125C8.69989 9.71392 8.91922 9.82358 9.06022 9.98025C9.20122 10.1369 9.27172 10.3562 9.27172 10.6383C9.27172 11.3276 8.88006 11.6722 8.09672 11.6722C7.33689 11.6722 6.72197 11.3707 6.25197 10.7675L5.17097 11.8485Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M16.3113 14.5V8.916H20.1113V9.996H17.5273V11.14H19.7433V12.212H17.5273V13.42H20.1113V14.5H16.3113ZM21.1707 14.5V8.916H23.8107C24.072 8.916 24.3067 8.96133 24.5147 9.052C24.7227 9.13733 24.8987 9.25733 25.0427 9.412C25.192 9.56667 25.3067 9.756 25.3867 9.98C25.4667 10.1987 25.5067 10.4387 25.5067 10.7C25.5067 10.9667 25.4667 11.2093 25.3867 11.428C25.3067 11.6467 25.192 11.8333 25.0427 11.988C24.8987 12.1427 24.7227 12.2653 24.5147 12.356C24.3067 12.4413 24.072 12.484 23.8107 12.484H22.3867V14.5H21.1707ZM22.3867 11.428H23.6667C23.848 11.428 23.9894 11.3827 24.0907 11.292C24.1974 11.196 24.2507 11.0573 24.2507 10.876V10.524C24.2507 10.3427 24.1974 10.2067 24.0907 10.116C23.9894 10.02 23.848 9.972 23.6667 9.972H22.3867V11.428Z" fill="currentColor"/>
        </g>;
        case 'acros': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M16.25 14H22.5C22.6381 14 22.75 13.8881 22.75 13.75V10.5202C22.75 10.4539 22.7763 10.3903 22.8232 10.3434L25.677 7.48989C25.7238 7.44301 25.7502 7.37942 25.7502 7.31311V4.25C25.7502 4.11193 25.6383 4 25.5002 4H16.25C16.1119 4 16 4.11194 16 4.25002L16.0002 6.49998C16.0002 6.63806 15.8882 6.75 15.7502 6.75H14.7502C14.6121 6.75 14.5002 6.86192 14.5002 6.99999L14.5 11C14.5 11.1381 14.6119 11.25 14.75 11.25H15.75C15.8881 11.25 16 11.3619 16 11.5V13.75C16 13.8881 16.1119 14 16.25 14ZM18.75 5H17V6.5H18.75V5ZM17 11.5H18.75V13H17V11.5ZM21.75 5H20V6.5H21.75V5ZM20 11.5H21.75V13H20V11.5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.35779 10.9908L9.86304 13H11.5198L9.19329 4.7985H7.05479L4.72829 13H6.33804L6.84329 10.9908H9.35779ZM8.18279 6.326L8.44129 7.74775L8.94654 9.6395H7.25454L7.73629 7.74775L7.99479 6.326H8.18279Z" fill="currentColor"/>
        </g>;
        case 'acros-ye': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.36279 10.9908L9.86804 13H11.5248L9.19829 4.7985H7.05979L4.73329 13H6.34304L6.84829 10.9908H9.36279ZM8.18779 6.326L8.44629 7.74775L8.95154 9.6395H7.25954L7.74129 7.74775L7.99979 6.326H8.18779Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M18.1285 14.5V12.316L16.2165 8.916H17.5765L18.7765 11.14H18.7925L19.9445 8.916H21.2645L19.3525 12.308V14.5H18.1285ZM23.1673 14.596C22.8473 14.596 22.5619 14.5453 22.3113 14.444C22.0606 14.3373 21.8473 14.1907 21.6713 14.004C21.5006 13.812 21.3699 13.58 21.2793 13.308C21.1939 13.036 21.1513 12.732 21.1513 12.396C21.1513 12.0653 21.1939 11.7667 21.2793 11.5C21.3646 11.228 21.4899 10.996 21.6553 10.804C21.8259 10.612 22.0339 10.4653 22.2793 10.364C22.5246 10.2573 22.8046 10.204 23.1193 10.204C23.4659 10.204 23.7619 10.2627 24.0073 10.38C24.2579 10.4973 24.4606 10.6547 24.6153 10.852C24.7753 11.0493 24.8899 11.2787 24.9593 11.54C25.0339 11.796 25.0713 12.0653 25.0713 12.348V12.7H22.3753V12.764C22.3753 13.0413 22.4499 13.2627 22.5993 13.428C22.7486 13.588 22.9833 13.668 23.3033 13.668C23.5486 13.668 23.7486 13.62 23.9033 13.524C24.0579 13.4227 24.2019 13.3027 24.3353 13.164L24.9273 13.9C24.7406 14.1187 24.4953 14.2893 24.1913 14.412C23.8926 14.5347 23.5513 14.596 23.1673 14.596ZM23.1433 11.076C22.9033 11.076 22.7139 11.156 22.5753 11.316C22.4419 11.4707 22.3753 11.6787 22.3753 11.94V12.004H23.8473V11.932C23.8473 11.676 23.7886 11.4707 23.6713 11.316C23.5593 11.156 23.3833 11.076 23.1433 11.076Z" fill="currentColor"/>
        </g>;
        case 'acros-r': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.36279 10.9908L9.86804 13H11.5248L9.19829 4.7985H7.05979L4.73329 13H6.34304L6.84829 10.9908H9.36279ZM8.18779 6.326L8.44629 7.74775L8.95154 9.6395H7.25954L7.74129 7.74775L7.99979 6.326H8.18779Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M19.8867 14.5H18.6707V8.916H21.3187C21.5747 8.916 21.8067 8.95867 22.0147 9.044C22.2227 9.12933 22.3987 9.252 22.5427 9.412C22.692 9.56667 22.8067 9.75333 22.8867 9.972C22.9667 10.1907 23.0067 10.4333 23.0067 10.7C23.0067 11.0787 22.9214 11.4093 22.7507 11.692C22.5854 11.9747 22.332 12.18 21.9907 12.308L23.0867 14.5H21.7347L20.7587 12.452H19.8867V14.5ZM21.1667 11.428C21.348 11.428 21.4894 11.3827 21.5907 11.292C21.6974 11.196 21.7507 11.0573 21.7507 10.876V10.524C21.7507 10.3427 21.6974 10.2067 21.5907 10.116C21.4894 10.02 21.348 9.972 21.1667 9.972H19.8867V11.428H21.1667Z" fill="currentColor"/>
        </g>;
        case 'acros-g': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM9.36279 10.9908L9.86804 13H11.5248L9.19829 4.7985H7.05979L4.73329 13H6.34304L6.84829 10.9908H9.36279ZM8.18779 6.326L8.44629 7.74775L8.95154 9.6395H7.25954L7.74129 7.74775L7.99979 6.326H8.18779Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M22.035 13.612H21.995C21.9523 13.8947 21.8083 14.1293 21.563 14.316C21.3177 14.5027 20.9843 14.596 20.563 14.596C20.243 14.596 19.9443 14.5347 19.667 14.412C19.3897 14.2893 19.147 14.108 18.939 13.868C18.731 13.628 18.5683 13.3293 18.451 12.972C18.3337 12.6147 18.275 12.2013 18.275 11.732C18.275 11.2627 18.3363 10.8467 18.459 10.484C18.5817 10.1213 18.7523 9.81733 18.971 9.572C19.195 9.32667 19.4617 9.14 19.771 9.012C20.0803 8.884 20.4243 8.82 20.803 8.82C21.3043 8.82 21.7363 8.92933 22.099 9.148C22.4617 9.36133 22.747 9.684 22.955 10.116L21.963 10.684C21.8777 10.4653 21.7443 10.2813 21.563 10.132C21.3817 9.97733 21.1283 9.9 20.803 9.9C20.4243 9.9 20.123 10.0093 19.899 10.228C19.675 10.4467 19.563 10.7907 19.563 11.26V12.156C19.563 12.62 19.675 12.964 19.899 13.188C20.123 13.4067 20.4243 13.516 20.803 13.516C20.9523 13.516 21.0937 13.5 21.227 13.468C21.3603 13.4307 21.4777 13.3773 21.579 13.308C21.6803 13.2333 21.7577 13.1453 21.811 13.044C21.8697 12.9427 21.899 12.8227 21.899 12.684V12.404H20.859V11.388H23.059V14.5H22.035V13.612Z" fill="currentColor"/>
        </g>;
        case 'provia': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.17097 11.8485C5.86814 12.7102 6.83164 13.141 8.06147 13.141C9.00147 13.141 9.71822 12.9138 10.2117 12.4595C10.7052 11.9973 10.952 11.3276 10.952 10.4502C10.952 10.1056 10.9089 9.804 10.8227 9.5455C10.7444 9.287 10.6112 9.06375 10.4232 8.87575C10.2431 8.68775 10.0081 8.535 9.71822 8.4175C9.43622 8.29217 9.09547 8.18642 8.69597 8.10025L7.94397 7.9475C7.65414 7.88483 7.44264 7.783 7.30947 7.642C7.18414 7.501 7.12147 7.29342 7.12147 7.01925C7.12147 6.70592 7.20372 6.47875 7.36822 6.33775C7.54056 6.19675 7.81472 6.12625 8.19072 6.12625C8.53539 6.12625 8.83306 6.18892 9.08372 6.31425C9.34222 6.43175 9.57331 6.61583 9.77697 6.8665L10.858 5.7855C10.2548 5.0335 9.37356 4.6575 8.21422 4.6575C7.30556 4.6575 6.61622 4.86508 6.14622 5.28025C5.67622 5.69542 5.44122 6.3025 5.44122 7.1015C5.44122 7.79083 5.61747 8.33133 5.96997 8.723C6.33031 9.10683 6.89039 9.36925 7.65022 9.51025L8.40222 9.65125C8.69989 9.71392 8.91922 9.82358 9.06022 9.98025C9.20122 10.1369 9.27172 10.3562 9.27172 10.6383C9.27172 11.3276 8.88006 11.6722 8.09672 11.6722C7.33689 11.6722 6.72197 11.3707 6.25197 10.7675L5.17097 11.8485Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M18.569 9.996V14.5H17.353V9.996H15.841V8.916H20.081V9.996H18.569ZM20.9129 8.916H23.0169C23.3849 8.916 23.7209 8.97467 24.0249 9.092C24.3289 9.20933 24.5875 9.38533 24.8009 9.62C25.0142 9.84933 25.1795 10.14 25.2969 10.492C25.4142 10.8387 25.4729 11.244 25.4729 11.708C25.4729 12.172 25.4142 12.58 25.2969 12.932C25.1795 13.2787 25.0142 13.5693 24.8009 13.804C24.5875 14.0333 24.3289 14.2067 24.0249 14.324C23.7209 14.4413 23.3849 14.5 23.0169 14.5H20.9129V8.916ZM23.0169 13.42C23.3795 13.42 23.6649 13.3187 23.8729 13.116C24.0809 12.9133 24.1849 12.588 24.1849 12.14V11.276C24.1849 10.828 24.0809 10.5027 23.8729 10.3C23.6649 10.0973 23.3795 9.996 23.0169 9.996H22.1289V13.42H23.0169Z" fill="currentColor"/>
        </g>;
        case 'portrait': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M16.25 14H22.5C22.6381 14 22.75 13.8881 22.75 13.75V10.5202C22.75 10.4539 22.7763 10.3903 22.8232 10.3434L25.677 7.48989C25.7238 7.44301 25.7502 7.37942 25.7502 7.31311V4.25C25.7502 4.11193 25.6383 4 25.5002 4H16.25C16.1119 4 16 4.11194 16 4.25002L16.0002 6.49998C16.0002 6.63806 15.8882 6.75 15.7502 6.75H14.7502C14.6121 6.75 14.5002 6.86192 14.5002 6.99999L14.5 11C14.5 11.1381 14.6119 11.25 14.75 11.25H15.75C15.8881 11.25 16 11.3619 16 11.5V13.75C16 13.8881 16.1119 14 16.25 14ZM18.75 5H17V6.5H18.75V5ZM17 11.5H18.75V13H17V11.5ZM21.75 5H20V6.5H21.75V5ZM20 11.5H21.75V13H20V11.5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.42998 4.7985V13H7.11023V9.9685H8.97848C9.71482 9.9685 10.2749 9.7335 10.6587 9.2635C11.0426 8.7935 11.2345 8.16683 11.2345 7.3835C11.2345 6.60017 11.0426 5.9735 10.6587 5.5035C10.2749 5.0335 9.71482 4.7985 8.97848 4.7985H5.42998ZM8.76698 8.49975H7.11023V6.26725H8.76698C8.99415 6.26725 9.1704 6.326 9.29573 6.4435C9.4289 6.561 9.49548 6.75683 9.49548 7.031V7.736C9.49548 8.01017 9.4289 8.206 9.29573 8.3235C9.1704 8.441 8.99415 8.49975 8.76698 8.49975Z" fill="currentColor"/>
        </g>;
        case 'portrait-saturation': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.43498 4.7985V13H7.11523V9.9685H8.98348C9.71982 9.9685 10.2799 9.7335 10.6637 9.2635C11.0476 8.7935 11.2395 8.16683 11.2395 7.3835C11.2395 6.60017 11.0476 5.9735 10.6637 5.5035C10.2799 5.0335 9.71982 4.7985 8.98348 4.7985H5.43498ZM8.77198 8.49975H7.11523V6.26725H8.77198C8.99915 6.26725 9.1754 6.326 9.30073 6.4435C9.4339 6.561 9.50048 6.75683 9.50048 7.031V7.736C9.50048 8.01017 9.4339 8.206 9.30073 8.3235C9.1754 8.441 8.99915 8.49975 8.77198 8.49975Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M17.9396 14.596C17.449 14.596 17.033 14.5133 16.6916 14.348C16.3503 14.1773 16.0596 13.9587 15.8196 13.692L16.6196 12.884C16.9983 13.3107 17.465 13.524 18.0196 13.524C18.3183 13.524 18.5396 13.4627 18.6836 13.34C18.8276 13.2173 18.8996 13.0547 18.8996 12.852C18.8996 12.6973 18.857 12.5693 18.7716 12.468C18.6863 12.3613 18.513 12.2893 18.2516 12.252L17.6996 12.18C17.1076 12.1053 16.673 11.9267 16.3956 11.644C16.1236 11.3613 15.9876 10.9853 15.9876 10.516C15.9876 10.2653 16.0356 10.036 16.1316 9.828C16.2276 9.62 16.3636 9.44133 16.5396 9.292C16.721 9.14267 16.9396 9.028 17.1956 8.948C17.457 8.86267 17.753 8.82 18.0836 8.82C18.505 8.82 18.8756 8.88667 19.1956 9.02C19.5156 9.15333 19.7903 9.348 20.0196 9.604L19.2116 10.42C19.0783 10.2653 18.9156 10.14 18.7236 10.044C18.537 9.94267 18.2996 9.892 18.0116 9.892C17.7396 9.892 17.537 9.94 17.4036 10.036C17.2703 10.132 17.2036 10.2653 17.2036 10.436C17.2036 10.628 17.2543 10.7667 17.3556 10.852C17.4623 10.9373 17.633 10.9987 17.8676 11.036L18.4196 11.124C18.9956 11.2147 19.4223 11.3933 19.6996 11.66C19.977 11.9213 20.1156 12.2947 20.1156 12.78C20.1156 13.0467 20.0676 13.292 19.9716 13.516C19.8756 13.74 19.7343 13.932 19.5476 14.092C19.3663 14.252 19.1396 14.3773 18.8676 14.468C18.5956 14.5533 18.2863 14.596 17.9396 14.596ZM24.5638 14.5L24.1638 13.172H22.2998L21.8998 14.5H20.6678L22.5078 8.916H24.0118L25.8278 14.5H24.5638ZM23.2438 10.02H23.2038L22.5878 12.14H23.8678L23.2438 10.02Z" fill="currentColor"/>
        </g>;
        case 'astia': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M16.25 14H22.5C22.6381 14 22.75 13.8881 22.75 13.75V10.5202C22.75 10.4539 22.7763 10.3903 22.8232 10.3434L25.677 7.48989C25.7238 7.44301 25.7502 7.37942 25.7502 7.31311V4.25C25.7502 4.11193 25.6383 4 25.5002 4H16.25C16.1119 4 16 4.11194 16 4.25002L16.0002 6.49998C16.0002 6.63806 15.8882 6.75 15.7502 6.75H14.7502C14.6121 6.75 14.5002 6.86192 14.5002 6.99999L14.5 11C14.5 11.1381 14.6119 11.25 14.75 11.25H15.75C15.8881 11.25 16 11.3619 16 11.5V13.75C16 13.8881 16.1119 14 16.25 14ZM18.75 5H17V6.5H18.75V5ZM17 11.5H18.75V13H17V11.5ZM21.75 5H20V6.5H21.75V5ZM20 11.5H21.75V13H20V11.5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.16597 11.8485C5.86314 12.7102 6.82664 13.141 8.05647 13.141C8.99647 13.141 9.71322 12.9138 10.2067 12.4595C10.7002 11.9973 10.947 11.3276 10.947 10.4502C10.947 10.1056 10.9039 9.804 10.8177 9.5455C10.7394 9.287 10.6062 9.06375 10.4182 8.87575C10.2381 8.68775 10.0031 8.535 9.71322 8.4175C9.43122 8.29217 9.09047 8.18642 8.69097 8.10025L7.93897 7.9475C7.64914 7.88483 7.43764 7.783 7.30447 7.642C7.17914 7.501 7.11647 7.29342 7.11647 7.01925C7.11647 6.70592 7.19872 6.47875 7.36322 6.33775C7.53556 6.19675 7.80972 6.12625 8.18572 6.12625C8.53039 6.12625 8.82806 6.18892 9.07872 6.31425C9.33722 6.43175 9.56831 6.61583 9.77197 6.8665L10.853 5.7855C10.2498 5.0335 9.36856 4.6575 8.20922 4.6575C7.30056 4.6575 6.61122 4.86508 6.14122 5.28025C5.67122 5.69542 5.43622 6.3025 5.43622 7.1015C5.43622 7.79083 5.61247 8.33133 5.96497 8.723C6.32531 9.10683 6.88539 9.36925 7.64522 9.51025L8.39722 9.65125C8.69489 9.71392 8.91422 9.82358 9.05522 9.98025C9.19622 10.1369 9.26672 10.3562 9.26672 10.6383C9.26672 11.3276 8.87506 11.6722 8.09172 11.6722C7.33189 11.6722 6.71697 11.3707 6.24697 10.7675L5.16597 11.8485Z" fill="currentColor"/>
        </g>;
        case 'portrait-sharpness': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.43498 4.7985V13H7.11523V9.9685H8.98348C9.71982 9.9685 10.2799 9.7335 10.6637 9.2635C11.0476 8.7935 11.2395 8.16683 11.2395 7.3835C11.2395 6.60017 11.0476 5.9735 10.6637 5.5035C10.2799 5.0335 9.71982 4.7985 8.98348 4.7985H5.43498ZM8.77198 8.49975H7.11523V6.26725H8.77198C8.99915 6.26725 9.1754 6.326 9.30073 6.4435C9.4339 6.561 9.50048 6.75683 9.50048 7.031V7.736C9.50048 8.01017 9.4339 8.206 9.30073 8.3235C9.1754 8.441 8.99915 8.49975 8.77198 8.49975Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M17.7834 14.596C17.2927 14.596 16.8767 14.5133 16.5354 14.348C16.194 14.1773 15.9034 13.9587 15.6634 13.692L16.4634 12.884C16.842 13.3107 17.3087 13.524 17.8634 13.524C18.162 13.524 18.3834 13.4627 18.5274 13.34C18.6714 13.2173 18.7434 13.0547 18.7434 12.852C18.7434 12.6973 18.7007 12.5693 18.6154 12.468C18.53 12.3613 18.3567 12.2893 18.0954 12.252L17.5434 12.18C16.9514 12.1053 16.5167 11.9267 16.2394 11.644C15.9674 11.3613 15.8314 10.9853 15.8314 10.516C15.8314 10.2653 15.8794 10.036 15.9754 9.828C16.0714 9.62 16.2074 9.44133 16.3834 9.292C16.5647 9.14267 16.7834 9.028 17.0394 8.948C17.3007 8.86267 17.5967 8.82 17.9274 8.82C18.3487 8.82 18.7194 8.88667 19.0394 9.02C19.3594 9.15333 19.634 9.348 19.8634 9.604L19.0554 10.42C18.922 10.2653 18.7594 10.14 18.5674 10.044C18.3807 9.94267 18.1434 9.892 17.8554 9.892C17.5834 9.892 17.3807 9.94 17.2474 10.036C17.114 10.132 17.0474 10.2653 17.0474 10.436C17.0474 10.628 17.098 10.7667 17.1994 10.852C17.306 10.9373 17.4767 10.9987 17.7114 11.036L18.2634 11.124C18.8394 11.2147 19.266 11.3933 19.5434 11.66C19.8207 11.9213 19.9594 12.2947 19.9594 12.78C19.9594 13.0467 19.9114 13.292 19.8154 13.516C19.7194 13.74 19.578 13.932 19.3914 14.092C19.21 14.252 18.9834 14.3773 18.7114 14.468C18.4394 14.5533 18.13 14.596 17.7834 14.596ZM24.3116 12.212H22.1836V14.5H20.9676V8.916H22.1836V11.14H24.3116V8.916H25.5276V14.5H24.3116V12.212Z" fill="currentColor"/>
        </g>;
        case 'portrait-ex': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.43498 4.7985V13H7.11523V9.9685H8.98348C9.71982 9.9685 10.2799 9.7335 10.6637 9.2635C11.0476 8.7935 11.2395 8.16683 11.2395 7.3835C11.2395 6.60017 11.0476 5.9735 10.6637 5.5035C10.2799 5.0335 9.71982 4.7985 8.98348 4.7985H5.43498ZM8.77198 8.49975H7.11523V6.26725H8.77198C8.99915 6.26725 9.1754 6.326 9.30073 6.4435C9.4339 6.561 9.50048 6.75683 9.50048 7.031V7.736C9.50048 8.01017 9.4339 8.206 9.30073 8.3235C9.1754 8.441 8.99915 8.49975 8.77198 8.49975Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M16.2449 14.5V8.916H20.0449V9.996H17.4609V11.14H19.6769V12.212H17.4609V13.42H20.0449V14.5H16.2449ZM25.7443 14.5H24.3363L23.1283 12.444H23.1043L21.9283 14.5H20.6163L22.4083 11.612L20.7043 8.916H22.1203L23.2083 10.804H23.2323L24.3363 8.916H25.6483L23.9283 11.636L25.7443 14.5Z" fill="currentColor"/>
        </g>;
        case 'velvia': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M16.25 14H22.5C22.6381 14 22.75 13.8881 22.75 13.75V10.5202C22.75 10.4539 22.7763 10.3903 22.8232 10.3434L25.677 7.48989C25.7238 7.44301 25.7502 7.37942 25.7502 7.31311V4.25C25.7502 4.11193 25.6383 4 25.5002 4H16.25C16.1119 4 16 4.11194 16 4.25002L16.0002 6.49998C16.0002 6.63806 15.8882 6.75 15.7502 6.75H14.7502C14.6121 6.75 14.5002 6.86192 14.5002 6.99999L14.5 11C14.5 11.1381 14.6119 11.25 14.75 11.25H15.75C15.8881 11.25 16 11.3619 16 11.5V13.75C16 13.8881 16.1119 14 16.25 14ZM18.75 5H17V6.5H18.75V5ZM17 11.5H18.75V13H17V11.5ZM21.75 5H20V6.5H21.75V5ZM20 11.5H21.75V13H20V11.5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM4.75477 4.7985L7.16352 13H9.13752L11.4993 4.7985H9.80727L8.51477 9.7805L8.25627 11.4725H8.06827L7.80977 9.7805L6.49377 4.7985H4.75477Z" fill="currentColor"/>
        </g>;
        case 'pro-neg-std': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM6.75351 7.30125L7.27051 8.6055L9.33851 13H11.1715V4.7985H9.59701V9.1225L9.69101 10.4972H9.50301L8.98601 9.193L6.91801 4.7985H5.08501V13H6.65951V8.676L6.56551 7.30125H6.75351Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M20.6779 14.596C20.1872 14.596 19.7712 14.5133 19.4299 14.348C19.0886 14.1773 18.7979 13.9587 18.5579 13.692L19.3579 12.884C19.7366 13.3107 20.2032 13.524 20.7579 13.524C21.0566 13.524 21.2779 13.4627 21.4219 13.34C21.5659 13.2173 21.6379 13.0547 21.6379 12.852C21.6379 12.6973 21.5952 12.5693 21.5099 12.468C21.4246 12.3613 21.2512 12.2893 20.9899 12.252L20.4379 12.18C19.8459 12.1053 19.4112 11.9267 19.1339 11.644C18.8619 11.3613 18.7259 10.9853 18.7259 10.516C18.7259 10.2653 18.7739 10.036 18.8699 9.828C18.9659 9.62 19.1019 9.44133 19.2779 9.292C19.4592 9.14267 19.6779 9.028 19.9339 8.948C20.1952 8.86267 20.4912 8.82 20.8219 8.82C21.2432 8.82 21.6139 8.88667 21.9339 9.02C22.2539 9.15333 22.5286 9.348 22.7579 9.604L21.9499 10.42C21.8166 10.2653 21.6539 10.14 21.4619 10.044C21.2752 9.94267 21.0379 9.892 20.7499 9.892C20.4779 9.892 20.2752 9.94 20.1419 10.036C20.0086 10.132 19.9419 10.2653 19.9419 10.436C19.9419 10.628 19.9926 10.7667 20.0939 10.852C20.2006 10.9373 20.3712 10.9987 20.6059 11.036L21.1579 11.124C21.7339 11.2147 22.1606 11.3933 22.4379 11.66C22.7152 11.9213 22.8539 12.2947 22.8539 12.78C22.8539 13.0467 22.8059 13.292 22.7099 13.516C22.6139 13.74 22.4726 13.932 22.2859 14.092C22.1046 14.252 21.8779 14.3773 21.6059 14.468C21.3339 14.5533 21.0246 14.596 20.6779 14.596Z" fill="currentColor"/>
        </g>;
        case 'pro-neg-hi': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM6.75351 7.30125L7.27051 8.6055L9.33851 13H11.1715V4.7985H9.59701V9.1225L9.69101 10.4972H9.50301L8.98601 9.193L6.91801 4.7985H5.08501V13H6.65951V8.676L6.56551 7.30125H6.75351Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M21.8155 12.212H19.6875V14.5H18.4715V8.916H19.6875V11.14H21.8155V8.916H23.0315V14.5H21.8155V12.212Z" fill="currentColor"/>
        </g>;
        case 'classic-chrome': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM7.12616 12.9178C7.53349 13.0666 7.98391 13.141 8.47741 13.141C8.84557 13.141 9.17457 13.0979 9.46441 13.0118C9.75424 12.9256 10.0088 12.8003 10.2282 12.6357C10.4553 12.4634 10.6551 12.2558 10.8274 12.013C10.9997 11.7702 11.1564 11.496 11.2974 11.1905L9.91091 10.3915C9.85607 10.5717 9.79341 10.7401 9.72291 10.8967C9.65241 11.0456 9.56232 11.1788 9.45266 11.2963C9.34299 11.4059 9.20591 11.496 9.04141 11.5665C8.88474 11.6292 8.69674 11.6605 8.47741 11.6605C8.00741 11.6605 7.63924 11.5195 7.37291 11.2375C7.10657 10.9555 6.97341 10.5325 6.97341 9.9685V7.83C6.97341 7.266 7.10657 6.843 7.37291 6.561C7.63924 6.279 8.00741 6.138 8.47741 6.138C8.69674 6.138 8.88082 6.16933 9.02966 6.232C9.18632 6.28683 9.31557 6.36517 9.41741 6.467C9.51924 6.56883 9.59757 6.69417 9.65241 6.843C9.71507 6.99183 9.76991 7.15242 9.81691 7.32475L11.2739 6.57275C10.9997 5.93042 10.6472 5.45258 10.2164 5.13925C9.79341 4.81808 9.21374 4.6575 8.47741 4.6575C7.98391 4.6575 7.53349 4.73975 7.12616 4.90425C6.72666 5.06092 6.38199 5.31158 6.09216 5.65625C5.81016 6.00092 5.58691 6.44742 5.42241 6.99575C5.26574 7.53625 5.18741 8.19033 5.18741 8.958C5.18741 9.72567 5.26574 10.3758 5.42241 10.9085C5.58691 11.4412 5.81016 11.872 6.09216 12.201C6.38199 12.53 6.72666 12.7689 7.12616 12.9178Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M21.0165 14.596C20.6379 14.596 20.2965 14.5373 19.9925 14.42C19.6885 14.2973 19.4299 14.1187 19.2165 13.884C19.0032 13.644 18.8379 13.348 18.7205 12.996C18.6032 12.6387 18.5445 12.2227 18.5445 11.748C18.5445 11.2787 18.6032 10.8627 18.7205 10.5C18.8379 10.132 19.0032 9.82533 19.2165 9.58C19.4299 9.32933 19.6885 9.14 19.9925 9.012C20.2965 8.884 20.6379 8.82 21.0165 8.82C21.5339 8.82 21.9605 8.92667 22.2965 9.14C22.6325 9.348 22.9019 9.67867 23.1045 10.132L22.0565 10.676C21.9819 10.4413 21.8645 10.2547 21.7045 10.116C21.5499 9.972 21.3205 9.9 21.0165 9.9C20.6592 9.9 20.3712 10.0173 20.1525 10.252C19.9392 10.4813 19.8325 10.8173 19.8325 11.26V12.156C19.8325 12.5987 19.9392 12.9373 20.1525 13.172C20.3712 13.4013 20.6592 13.516 21.0165 13.516C21.3152 13.516 21.5525 13.436 21.7285 13.276C21.9099 13.1107 22.0432 12.9133 22.1285 12.684L23.1205 13.26C22.9125 13.6867 22.6379 14.0173 22.2965 14.252C21.9605 14.4813 21.5339 14.596 21.0165 14.596Z" fill="currentColor"/>
        </g>;
        case 'eterna': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M16.25 14H22.5C22.6381 14 22.75 13.8881 22.75 13.75V10.5202C22.75 10.4539 22.7763 10.3903 22.8232 10.3434L25.677 7.48989C25.7238 7.44301 25.7502 7.37942 25.7502 7.31311V4.25C25.7502 4.11193 25.6383 4 25.5002 4H16.25C16.1119 4 16 4.11194 16 4.25002L16.0002 6.49998C16.0002 6.63806 15.8882 6.75 15.7502 6.75H14.7502C14.6121 6.75 14.5002 6.86192 14.5002 6.99999L14.5 11C14.5 11.1381 14.6119 11.25 14.75 11.25H15.75C15.8881 11.25 16 11.3619 16 11.5V13.75C16 13.8881 16.1119 14 16.25 14ZM18.75 5H17V6.5H18.75V5ZM17 11.5H18.75V13H17V11.5ZM21.75 5H20V6.5H21.75V5ZM20 11.5H21.75V13H20V11.5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.69963 4.7985V13H10.7756V11.5312H7.37988V9.58075H10.2586V8.12375H7.37988V6.26725H10.7756V4.7985H5.69963Z" fill="currentColor"/>
        </g>;
        case 'classic-neg': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM6.75351 7.30125L7.27051 8.6055L9.33851 13H11.1715V4.7985H9.59701V9.1225L9.69101 10.4972H9.50301L8.98601 9.193L6.91801 4.7985H5.08501V13H6.65951V8.676L6.56551 7.30125H6.75351Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M21.0165 14.596C20.6379 14.596 20.2965 14.5373 19.9925 14.42C19.6885 14.2973 19.4299 14.1187 19.2165 13.884C19.0032 13.644 18.8379 13.348 18.7205 12.996C18.6032 12.6387 18.5445 12.2227 18.5445 11.748C18.5445 11.2787 18.6032 10.8627 18.7205 10.5C18.8379 10.132 19.0032 9.82533 19.2165 9.58C19.4299 9.32933 19.6885 9.14 19.9925 9.012C20.2965 8.884 20.6379 8.82 21.0165 8.82C21.5339 8.82 21.9605 8.92667 22.2965 9.14C22.6325 9.348 22.9019 9.67867 23.1045 10.132L22.0565 10.676C21.9819 10.4413 21.8645 10.2547 21.7045 10.116C21.5499 9.972 21.3205 9.9 21.0165 9.9C20.6592 9.9 20.3712 10.0173 20.1525 10.252C19.9392 10.4813 19.8325 10.8173 19.8325 11.26V12.156C19.8325 12.5987 19.9392 12.9373 20.1525 13.172C20.3712 13.4013 20.6592 13.516 21.0165 13.516C21.3152 13.516 21.5525 13.436 21.7285 13.276C21.9099 13.1107 22.0432 12.9133 22.1285 12.684L23.1205 13.26C22.9125 13.6867 22.6379 14.0173 22.2965 14.252C21.9605 14.4813 21.5339 14.596 21.0165 14.596Z" fill="currentColor"/>
        </g>;
        case 'eterna-bleach-bypass': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.70463 4.7985V13H10.7806V11.5312H7.38488V9.58075H10.2636V8.12375H7.38488V6.26725H10.7806V4.7985H5.70463Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M18.698 8.916H21.41C21.874 8.916 22.234 9.04667 22.49 9.308C22.7514 9.56933 22.882 9.916 22.882 10.348C22.882 10.5613 22.8527 10.7427 22.794 10.892C22.7407 11.0413 22.666 11.164 22.57 11.26C22.4794 11.356 22.37 11.428 22.242 11.476C22.1194 11.5187 21.986 11.5427 21.842 11.548V11.596C21.9754 11.596 22.114 11.62 22.258 11.668C22.4074 11.716 22.5434 11.7933 22.666 11.9C22.7887 12.0013 22.89 12.1347 22.97 12.3C23.0554 12.4653 23.098 12.668 23.098 12.908C23.098 13.1267 23.0607 13.3347 22.986 13.532C22.9167 13.724 22.818 13.892 22.69 14.036C22.562 14.18 22.41 14.2947 22.234 14.38C22.058 14.46 21.866 14.5 21.658 14.5H18.698V8.916ZM19.914 13.476H21.314C21.474 13.476 21.5994 13.4333 21.69 13.348C21.786 13.2573 21.834 13.132 21.834 12.972V12.7C21.834 12.54 21.786 12.4173 21.69 12.332C21.5994 12.2413 21.474 12.196 21.314 12.196H19.914V13.476ZM19.914 11.204H21.122C21.282 11.204 21.4074 11.1587 21.498 11.068C21.5887 10.9773 21.634 10.852 21.634 10.692V10.452C21.634 10.292 21.5887 10.1667 21.498 10.076C21.4074 9.98533 21.282 9.94 21.122 9.94H19.914V11.204Z" fill="currentColor"/>
        </g>;
        case 'nostalgic-neg': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM6.75351 7.30125L7.27051 8.6055L9.33851 13H11.1715V4.7985H9.59701V9.1225L9.69101 10.4972H9.50301L8.98601 9.193L6.91801 4.7985H5.08501V13H6.65951V8.676L6.56551 7.30125H6.75351Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M25.75 7.25V4.25C25.75 4.11193 25.6403 4 25.5023 4H16.2473C16.1092 4 15.9998 4.11194 15.9998 4.25001L16 7.25001C16 7.38808 16.1119 7.5 16.25 7.5H25.5C25.6381 7.5 25.75 7.38807 25.75 7.25ZM18.75 5H17V6.5H18.75V5ZM20 5H21.75V6.5H20V5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path d="M20.1755 11.86L19.6395 10.74H19.6155V14.5H18.4715V8.916H19.7995L21.3275 11.556L21.8635 12.676H21.8875V8.916H23.0315V14.5H21.7035L20.1755 11.86Z" fill="currentColor"/>
        </g>;
        case 'reala': return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M16.25 14H22.5C22.6381 14 22.75 13.8881 22.75 13.75V10.5202C22.75 10.4539 22.7763 10.3903 22.8232 10.3434L25.677 7.48989C25.7238 7.44301 25.7502 7.37942 25.7502 7.31311V4.25C25.7502 4.11193 25.6383 4 25.5002 4H16.25C16.1119 4 16 4.11194 16 4.25002L16.0002 6.49998C16.0002 6.63806 15.8882 6.75 15.7502 6.75H14.7502C14.6121 6.75 14.5002 6.86192 14.5002 6.99999L14.5 11C14.5 11.1381 14.6119 11.25 14.75 11.25H15.75C15.8881 11.25 16 11.3619 16 11.5V13.75C16 13.8881 16.1119 14 16.25 14ZM18.75 5H17V6.5H18.75V5ZM17 11.5H18.75V13H17V11.5ZM21.75 5H20V6.5H21.75V5ZM20 11.5H21.75V13H20V11.5ZM24.75 5H23V6.5H24.75V5Z" fill="currentColor"/>
          <path fillRule="evenodd" clipRule="evenodd" d="M5.25 3.49999L2 3.49999C1.86193 3.49999 1.75 3.61192 1.75 3.74999V5.24998C1.75 5.38806 1.86193 5.49998 2 5.49998H3.00001C3.13808 5.49998 3.25001 5.61191 3.25001 5.74999L3.25 12.25C3.25 12.3881 3.13807 12.5 3 12.5H2C1.86193 12.5 1.75 12.6119 1.75 12.75V14.25C1.75 14.3881 1.86193 14.5 2 14.5H14.25C14.3881 14.5 14.5 14.3881 14.5 14.25V12.75C14.5 12.6119 14.3881 12.5 14.25 12.5H13.25C13.1119 12.5 13 12.3881 13 12.25L13 5.75C13 5.61193 13.112 5.5 13.25 5.5H14.25C14.3881 5.5 14.5 5.38807 14.5 5.25V3.74999C14.5 3.61192 14.3881 3.49999 14.25 3.49999L11 3.49999C10.8619 3.49998 10.75 3.38806 10.75 3.24999V1.74998C10.75 1.61191 10.6381 1.49998 10.5 1.49998H5.75C5.61193 1.49998 5.5 1.61191 5.5 1.74998V3.24999C5.5 3.38806 5.38807 3.49998 5.25 3.49999ZM5.33818 13H7.01843V9.898H8.13469L9.40369 13H11.2249L9.79144 9.74525C10.2379 9.58075 10.5748 9.29092 10.8019 8.87575C11.0291 8.46058 11.1427 7.95142 11.1427 7.34825C11.1427 6.57275 10.9508 5.95392 10.5669 5.49175C10.1831 5.02958 9.62302 4.7985 8.88668 4.7985H5.33818V13ZM9.20393 8.33525C9.0786 8.44492 8.90235 8.49975 8.67518 8.49975H7.01843V6.26725H8.67518C8.90235 6.26725 9.0786 6.326 9.20393 6.4435C9.3371 6.55317 9.40369 6.749 9.40369 7.031V7.736C9.40369 8.018 9.3371 8.21775 9.20393 8.33525Z" fill="currentColor"/>
        </g>;
        default: return <g>
          <path fillRule="evenodd" clipRule="evenodd" d="M1.5 13H8.75001C8.88808 13 9.00001 12.8881 9.00001 12.75V9.52022C9.00001 9.45392 9.02635 9.39033 9.07324 9.34344L11.927 6.48989C11.9739 6.44301 12.0002 6.37942 12.0002 6.31311V3.25C12.0002 3.11193 11.8883 3 11.7502 3H1.5C1.36193 3 1.25 3.11193 1.25 3.25V12.75C1.25 12.8881 1.36193 13 1.5 13ZM4.50001 4H2.75001V5.5H4.50001V4ZM2.75001 10.5H4.50001V12H2.75001V10.5ZM7.50001 4H5.75001V5.5H7.50001V4ZM5.75001 10.5H7.50001V12H5.75001V10.5ZM10.5 4H8.75001V5.5H10.5V4Z" fill="currentColor"/>
        </g>;
        }
      })()}
    </svg>
  );
}
