/* eslint-disable quotes */
import {
  parseAiAutoGeneratedFieldsText,
  parseTitleAndCaption,
} from "@/photo/ai";

describe('AI parses', () => {
  describe('auto-generated fields', () => {
    it('with spaces', () => {
      expect(parseAiAutoGeneratedFieldsText())
        .toStrictEqual(['title', 'caption', 'tags', 'semantic']);
      expect(parseAiAutoGeneratedFieldsText('all'))
        .toStrictEqual(['title', 'caption', 'tags', 'semantic']);
      expect(parseAiAutoGeneratedFieldsText('title'))
        .toStrictEqual(['title']);
      expect(parseAiAutoGeneratedFieldsText('title, caption'))
        .toStrictEqual(['title', 'caption']);
      expect(parseAiAutoGeneratedFieldsText('title, caption, invalid'))
        .toStrictEqual(['title', 'caption']);
      expect(parseAiAutoGeneratedFieldsText('title, caption, invalid, tags'))
        .toStrictEqual(['title', 'caption', 'tags']);
      expect(parseAiAutoGeneratedFieldsText('none'))
        .toStrictEqual([]);
    });
    it('without spaces', () => {
      expect(parseAiAutoGeneratedFieldsText('title,caption'))
        .toStrictEqual(['title', 'caption']);
      expect(parseAiAutoGeneratedFieldsText('title,caption,invalid'))
        .toStrictEqual(['title', 'caption']);
      expect(parseAiAutoGeneratedFieldsText('title,caption,invalid,tags'))
        .toStrictEqual(['title', 'caption', 'tags']);
    });
  });
  it('received titles and captions', () => {
    // Complex case
    expect(parseTitleAndCaption(
      `'Title: "Ephemeral Beauty" Caption: "Roses bask in fleeting sunlight."'`
    )).toStrictEqual({
      title: 'Ephemeral Beauty',
      caption: 'Roses bask in fleeting sunlight',
    });
    // Without surrounding single quotes
    expect(parseTitleAndCaption(
      `Title: "Ephemeral Beauty"  Caption: "Roses bask in fleeting sunlight."`
    )).toStrictEqual({
      title: 'Ephemeral Beauty',
      caption: 'Roses bask in fleeting sunlight',
    });
    // Without trailing period
    expect(parseTitleAndCaption(
      `Title: "Ephemeral Beauty"  Caption: "Roses bask in fleeting sunlight"`
    )).toStrictEqual({
      title: 'Ephemeral Beauty',
      caption: 'Roses bask in fleeting sunlight',
    });
    // Without and quotes
    expect(parseTitleAndCaption(
      `Title: Ephemeral Beauty  Caption: Roses bask in fleeting sunlight`
    )).toStrictEqual({
      title: 'Ephemeral Beauty',
      caption: 'Roses bask in fleeting sunlight',
    });
    // With single space
    expect(parseTitleAndCaption(
      `Title: Ephemeral Beauty Caption: Roses bask in fleeting sunlight`
    )).toStrictEqual({
      title: 'Ephemeral Beauty',
      caption: 'Roses bask in fleeting sunlight',
    });
  });
});
