// =================================================================================
// This is auto-generated by GoFrame CLI tool only once. Fill this file as you wish.
// =================================================================================

package dao

import (
	"context"
	"github.com/bufanyun/hotgo/app/consts"
	"github.com/bufanyun/hotgo/app/service/internal/dao/internal"
	"github.com/gogf/gf/v2/container/gvar"
	"github.com/gogf/gf/v2/errors/gerror"
)

// sysProvincesDao is the data access object for table hg_sys_provinces.
// You can define custom methods on it to extend its functionality as you wish.
type sysProvincesDao struct {
	*internal.SysProvincesDao
}

var (
	// SysProvinces is globally public accessible object for table hg_sys_provinces operations.
	SysProvinces = sysProvincesDao{
		internal.NewSysProvincesDao(),
	}
)

//
//  @Title  获取省市编码对应的地区名称
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   province
//  @Param   city
//  @Param   spilt
//  @Return  string
//  @Return  error
//
func (dao *sysProvincesDao) GetRegion(ctx context.Context, province int, city int, spilt ...string) (string, error) {

	var (
		provinceName *gvar.Var
		cityName     *gvar.Var
		err          error
	)
	// TODO  默认分隔符
	spiltSymbol := "-"
	if len(spilt) > 0 {
		spiltSymbol = spilt[0]
	}

	if province > 0 {
		provinceName, err = dao.Ctx(ctx).Where("id", province).Fields("title").Value()
		if err != nil {
			err = gerror.Wrap(err, consts.ErrorORM)
			return "", err
		}

		if city > 0 {
			cityName, err = dao.Ctx(ctx).Where("id", city).Fields("title").Value()
			if err != nil {
				err = gerror.Wrap(err, consts.ErrorORM)
				return "", err
			}
		}
	} else {
		return "内网IP", nil
	}

	return provinceName.String() + spiltSymbol + cityName.String(), nil
}

// Fill with you ideas below.
