// =================================================================================
// This is auto-generated by GoFrame CLI tool only once. Fill this file as you wish.
// =================================================================================

package dao

import (
	"context"
	"github.com/bufanyun/hotgo/app/consts"
	"github.com/bufanyun/hotgo/app/model"
	"github.com/bufanyun/hotgo/app/model/entity"
	"github.com/bufanyun/hotgo/app/service/internal/dao/internal"
	"github.com/gogf/gf/v2/errors/gerror"
)

//  @Description
type adminMenuDao struct {
	*internal.AdminMenuDao //  }
}

var (
	// AdminMenu is globally public accessible object for table hg_admin_menu operations.
	AdminMenu = adminMenuDao{
		internal.NewAdminMenuDao(),
	}
)

//
//  @Title  判断名称是否唯一
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   id
//  @Param   name
//  @Return  bool
//  @Return  error
//
func (dao *adminMenuDao) IsUniqueName(ctx context.Context, id int64, name string) (bool, error) {
	var data *entity.AdminMenu
	m := dao.Ctx(ctx).Where("name", name)

	if id > 0 {
		m = m.WhereNot("id", id)
	}

	if err := m.Scan(&data); err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return false, err
	}

	if data == nil {
		return true, nil
	}

	return false, nil
}

//
//  @Title  判断编码是否唯一
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   id
//  @Param   code
//  @Return  bool
//  @Return  error
//
func (dao *adminMenuDao) IsUniqueCode(ctx context.Context, id int64, code string) (bool, error) {
	var data *entity.AdminMenu
	m := dao.Ctx(ctx).Where("code", code)

	if id > 0 {
		m = m.WhereNot("id", id)
	}

	if err := m.Scan(&data); err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return false, err
	}

	if data == nil {
		return true, nil
	}

	return false, nil
}

//
//  @Title  生成kl树列表
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   pid
//  @Param   lists
//  @Return  []*model.TreeMenu
//  @Return  error
//
func (dao *adminMenuDao) GenLabelTreeList(ctx context.Context, pid int64) ([]*model.LabelTreeMenu, error) {

	var (
		newLst []*model.LabelTreeMenu
	)
	if err := dao.Ctx(ctx).Where("pid", pid).Order("sort asc,id desc").Scan(&newLst); err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return nil, err
	}

	for i := 0; i < len(newLst); i++ {
		newLst[i].Key = newLst[i].Id
		newLst[i].Label = newLst[i].Name
		err := dao.Ctx(ctx).Where("pid", newLst[i].Id).Order("sort asc,id desc").Scan(&newLst[i].Children)
		if err != nil {
			err = gerror.Wrap(err, consts.ErrorORM)
			return nil, err
		}

		for i2 := 0; i2 < len(newLst[i].Children); i2++ {
			newLst[i].Children[i2].Key = newLst[i].Children[i2].Id
			newLst[i].Children[i2].Label = newLst[i].Children[i2].Name
		}
	}

	return newLst, nil
}

//
//  @Title  生成树列表
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   pid
//  @Param   lists
//  @Return  []*model.TreeMenu
//  @Return  error
//
func (dao *adminMenuDao) GenTreeList(ctx context.Context, pid int64, ids []int64) ([]*model.TreeMenu, error) {

	var (
		newLst []*model.TreeMenu
	)
	if err := dao.Ctx(ctx).Where("id", ids).Where("pid", pid).Order("sort asc,id desc").Scan(&newLst); err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return nil, err
	}

	for i := 0; i < len(newLst); i++ {
		err := dao.Ctx(ctx).Where("pid", newLst[i].Id).Order("sort asc,id desc").Scan(&newLst[i].Children)
		if err != nil {
			err = gerror.Wrap(err, consts.ErrorORM)
			return nil, err
		}
	}

	return newLst, nil
}

//
//  @Title  获取最上级pid
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   data
//  @Return  int64
//  @Return  error
//
func (dao *adminMenuDao) TopPid(ctx context.Context, data *entity.AdminMenu) (int64, error) {
	var pidData *entity.AdminMenu
	if data.Pid == 0 {
		return data.Id, nil
	}
	err := dao.Ctx(ctx).Where("id", data.Pid).Scan(&pidData)
	if err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return 0, err
	}

	return dao.TopPid(ctx, pidData)
}

// Fill with you ideas below.
