// =================================================================================
// This is auto-generated by GoFrame CLI tool only once. Fill this file as you wish.
// =================================================================================

package dao

import (
	"context"
	"github.com/bufanyun/hotgo/app/consts"
	"github.com/bufanyun/hotgo/app/model/entity"
	"github.com/bufanyun/hotgo/app/service/internal/dao/internal"
	"github.com/gogf/gf/v2/errors/gerror"
)

// adminMemberDao is the data access object for table hg_admin_member.
// You can define custom methods on it to extend its functionality as you wish.
type adminMemberDao struct {
	*internal.AdminMemberDao
}

var (
	// AdminMember is globally public accessible object for table hg_admin_member operations.
	AdminMember = adminMemberDao{
		internal.NewAdminMemberDao(),
	}
)

//
//  @Title  判断用户名是否唯一
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   id
//  @Param   name
//  @Return  bool
//  @Return  error
//
func (dao *adminMemberDao) IsUniqueName(ctx context.Context, id int64, name string) (bool, error) {
	var data *entity.AdminDept
	m := dao.Ctx(ctx).Where("username", name)

	if id > 0 {
		m = m.WhereNot("id", id)
	}

	if err := m.Scan(&data); err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return false, err
	}

	if data == nil {
		return true, nil
	}

	return false, nil
}

//
//  @Title  判断邮箱是否唯一
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   id
//  @Param   name
//  @Return  bool
//  @Return  error
//
func (dao *adminMemberDao) IsUniqueEmail(ctx context.Context, id int64, email string) (bool, error) {
	var data *entity.AdminMember
	m := dao.Ctx(ctx).Where("email", email)

	if id > 0 {
		m = m.WhereNot("id", id)
	}

	if err := m.Scan(&data); err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return false, err
	}

	if data == nil {
		return true, nil
	}

	return false, nil
}

//
//  @Title  判断手机号是否唯一
//  @Description
//  @Author  Ms <133814250@qq.com>
//  @Param   ctx
//  @Param   id
//  @Param   name
//  @Return  bool
//  @Return  error
//
func (dao *adminMemberDao) IsUniqueMobile(ctx context.Context, id int64, mobile string) (bool, error) {
	var data *entity.AdminMember
	m := dao.Ctx(ctx).Where("mobile", mobile)

	if id > 0 {
		m = m.WhereNot("id", id)
	}

	if err := m.Scan(&data); err != nil {
		err = gerror.Wrap(err, consts.ErrorORM)
		return false, err
	}

	if data == nil {
		return true, nil
	}

	return false, nil
}

// Fill with you ideas below.
