---
title: Introduction
weight: 1
group: start
---

Saleina CMS is an open source content management system for your Git workflow that enables you to provide editors with friendly UI and intuitive workflow. You can use it with any static site generator to create faster, more flexible web projects. Content is stored in your Git repository alongside your code for easier versioning, multi-channel publishing, and the option to handle content updates directly in Git.

At its core, Saleina CMS is an open-source Vue app that acts as a wrapper for the Git workflow, using the GitLab API. This provides many advantages, including:

* **Fast, web-based UI:** with tabbed UI, rich-text editing, and media uploads.
* **Platform agnostic:** works with most static site generators.
* **Easy installation:** add two files to your site and hook up the backend by linking to our CDN.
* **Modern authentication:** using GitLab.
* **Flexible content types:** specify an unlimited number of content types with custom fields.

## Find out more

- Configure your existing site by following a [tutorial](/docs/add-to-your-site/) or checking [configuration options](/docs/configuration-options).
- Ask questions and share ideas in the Saleina CMS community on [Telegram](tg://resolve?domain=saleinacmsdiscussions).
