# steroids
A collection of scripts for Blender to save a lot of clicks.

Steroids is a small project I started doing out of frustration of having to wander across the interface to do certain things in Blender. Setting up particle instances using hairs is one such example.

Some of the scripts are incomplete. Some are obsolete due to recent additions in Blender like Geometry Nodes. Those have to be updated to work with the new tools.

## List of current scripts
 - **Separate Parts and Reset Origins** -- Separates a mesh by loose parts and resets the origin of individual parts.
 - **Steroid Array** -- Incomplete/TODO
 - **Mirror Using Empty** -- Mirrors using an empty as pivot -- Incomplete/TODO
 - **Noise Displacement** -- Various options to work with noise-based displacement
 - **Toggle Subsurf** -- Toggles subsurf modifier on all objects in the scene
 - **Instance Collection Using Hairs** -- Scatter collections using particle hairs
 - **Instance Objects Using Hairs** -- Scatter an object using particle hairs
 - **Particle Density Texture** -- Setup a various noise textures to control particle distribution
 - **Adjust Camera Shift** -- Adjust camera shift directly in the viewport from camera view
 - **Reset Camera Shift** -- Resets camera shift X/Y
 - **Add HDR Environment** -- Add an empty controlled HDR environment
 - **Add Sun (Blackbody)** -- Add a Sun lamp with Blackbody temperature control
 - **Enable Intel Denoiser** -- Enables denoising data passes and sets up Denoise node in the compositor

## Interface
![steroids_001](https://user-images.githubusercontent.com/12907695/110675897-6702ab00-81f9-11eb-8cd8-3d9c64c19014.gif)

## Noise Displacement
![steroids_002](https://user-images.githubusercontent.com/12907695/110676802-60286800-81fa-11eb-8889-792295b75cf7.gif)

## Quick scattering
To be updated with geometry nodes.
![steroids_004](https://user-images.githubusercontent.com/12907695/110679267-49cfdb80-81fd-11eb-86d7-212c874b4dd2.gif)

## Add HDR Environment
Add an empty-controlled HDR

![steroids_003](https://user-images.githubusercontent.com/12907695/110677692-7682f380-81fb-11eb-9417-fdc6b9092204.gif)

## TODO
 - Update scripts to work newer tools, especially, Geometry Nodes.
 - Update incomplete scripts.
 - Add more steroids!
