let util = require('util');

module.exports.addImport = function addImport(tree, mod, name) {
  tree.children.unshift({
    type: 'import',
    value: `import { ${name} as _${name} } from '${mod}'`,
  });
  return `_${name}`;
};

module.exports.addDefaultImport = function addImport(tree, mod, name) {
  tree.children.unshift({
    type: 'import',
    value: `import _${name} from '${mod}'`,
  });
  return `_${name}`;
};

module.exports.addExport = function addExport(tree, name, value) {
  tree.children.push({
    type: 'export',
    value: `export const ${name} = ${JSON.stringify(value)}`,
  });
};

module.exports.prettyPrint = obj => {
  console.log(
    util.inspect(obj, { showHidden: false, depth: null, color: 'auto' })
  );
};
