import React from 'react';
import Head from 'next/head';

export default () => (
  <Head>
    <title>RWieruch</title>
    <meta name="description" content="Courses by Robin Wieruch" />
    <meta name="robots" content="all,follow" />
    <meta name="googlebot" content="index,follow,snippet,archive" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0"
    />
    <meta itemProp="name" content="RWieruch" />
    <meta itemProp="description" content="Courses by Robin Wieruch" />
    <meta itemProp="image" content="/facebook.png" />
    <meta name="twitter:card" content="summary" />
    <meta name="twitter:site" content="@rwieruch" />
    <meta name="twitter:title" content="RWieruch" />
    <meta
      name="twitter:description"
      content="Courses by Robin Wieruch"
    />
    <meta name="twitter:image:src" content="/twitter.png" />
    <meta name="twitter:image:alt" content="RWieruch" />
    <meta name="og:site_name" content="RWieruch" />
    <meta name="og:type" content="website" />
    <meta name="og:title" content="RWieruch" />
    <meta name="og:description" content="Courses by Robin Wieruch" />
    <meta name="og:image" content="/facebook.png" />
    <link
      rel="apple-touch-icon"
      sizes="57x57"
      href="/favicon/apple-icon-57x57.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="60x60"
      href="/favicon/apple-icon-60x60.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="72x72"
      href="/favicon/apple-icon-72x72.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="76x76"
      href="/favicon/apple-icon-76x76.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="114x114"
      href="/favicon/apple-icon-114x114.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="120x120"
      href="/favicon/apple-icon-120x120.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="144x144"
      href="/favicon/apple-icon-144x144.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="152x152"
      href="/favicon/apple-icon-152x152.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="180x180"
      href="/favicon/apple-icon-180x180.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="192x192"
      href="/favicon/android-icon-192x192.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="32x32"
      href="/favicon/favicon-32x32.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="96x96"
      href="/favicon/favicon-96x96.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="16x16"
      href="/favicon/favicon-16x16.png"
    />
    <link rel="manifest" href="/favicon/manifest.json" />
    <meta name="msapplication-TileColor" content="#823eb7" />
    <meta
      name="msapplication-TileImage"
      content="/favicon/ms-icon-144x144.png"
    />
    <meta name="theme-color" content="#823eb7" />
  </Head>
);
