# Code Conventions & Best Practices

The purpose of this and related documents is to outline the established programming conventions for the various languages of this application.

Each language and framework are broken into their own child document.

-   [CSharp](code-conventions-csharp.md)
-   [Dotnet](code-conventions-dotnet.md)
-   [React](code-conventions-react.md)
-   [TypeScript](code-conventions-typescript.md)

## IDE Setup

For both frontend and backend development, the andculture team has preferred [Visual Studio Code](https://code.visualstudio.com/), since it is free, open source, cross-platform, and widely adopted.

## Extensions

We use a few extensions available on the market place for language support, linting, formatting, and snippet generation. When you open the repository in VS Code, it should recommend the extensions listed in [.vscode/extensions.json](../.vscode/extensions.json).

-   [ESLint](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint)
    -   ESLint plugin for linting
-   [Prettier - Code formatter](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode)
    -   Prettier plugin for formatting
-   [C# XML Documentation Comments](https://marketplace.visualstudio.com/items?itemName=k--kato.docomment)
    -   CSharp XML doc generation
-   [C#](https://marketplace.visualstudio.com/items?itemName=ms-vscode.csharp)
    -   CSharp plugin for language support, intellisense, etc
-   [TSLint](https://marketplace.visualstudio.com/items?itemName=ms-vscode.vscode-typescript-tslint-plugin)
    -   TSLint plugin for language support
-   [Debugger for Chrome](https://marketplace.visualstudio.com/items?itemName=msjsdiag.debugger-for-chrome)
    -   Enables attaching to Chrome processes for frontend debugging
-   [Trailing Spaces](https://marketplace.visualstudio.com/items?itemName=shardulm94.trailing-space)
    -   Highlights & deletes trailing whitespace characters
