-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.5
-- Date : 2021-12-07 16:34:41
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1638858983', '127.0.0.1', '243', '', '0', '1', 'cn', '1', '1', '1586479354', '1636420548');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '作品/摄影展示', 'gallery', 'gallery', '0', '', '1', '1', '1', '1001', 'list', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638860397');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '城市/风景/摄影', '', 'gallery/chengshi_fengjing_sheying', '1', '/storage/images/20211207/c1.jpg', '1,2', '2', '1', '10011001', 'case', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1638864800');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '生活/产品/摄影', '', 'gallery/shenghuo_chanpin_sheying', '1', '/storage/images/20211207/c2.jpg', '1,3', '2', '2', '10011002', 'case', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1638864813');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '时尚/模特/摄影', '', 'gallery/shishang_mote_sheying', '1', '/storage/images/20211207/c3.jpg', '1,4', '2', '3', '10011003', 'case', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1638864824');
INSERT INTO `rrz_article_nodes` VALUES ('5', '1', '新闻列表', 'news', 'news', '0', '', '5', '1', '2', '1002', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'true', '1638860397');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '关于我们', 'about', 'about', '0', '', '6', '1', '3', '1003', 'about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '                以人为本，追求卓越                以人为本，首先体现在视觉对待客户朋友的态度。视觉自始至终把客户当成有缘相识、相知的朋友，因此视觉关注客户的每一处要求，率先推出一对一个性拍摄模式，并且一直致力于拍摄模式', '', '<div class=\"content-inner\" style=\"background-image: url(/storage/images/20211207/harrison-120601-2542.jpg)\"><!--关于我们开始--><div class=\"block block-about\"><div class=\"about-thumb\" style=\"padding:40px;padding-bottom:0\"><img alt=\"\" src=\"/storage/images/20211207/img-6289-v1.jpg\"/></div><div class=\"about-content editor-format\"><h3>                \r\n				以人为本，追求卓越</h3><p>                \r\n				以人为本，首先体现在视觉对待客户朋友的态度。视觉自始至终把客户当成有缘相识、相知的朋友，因此视觉关注客户的每一处要求，率先推出一对一个性拍摄模式，并且一直致力于拍摄模式的改进，不断为客户朋友们带来惊喜。其中许多创新模式为同行所效仿，带动了整个行业的发展，例如“先拍照、后付款”；“不满意无条件退款”等。长期以来，视觉的诚意与诚恳赢得了朋友们的尊重，也为视觉的自身发展打下了良好基础。</p><h5>                \r\n				志存高远追求</h5><p>                \r\n				卓越，更体现在DEMO视觉长远而宏伟发展目标。DEMO视觉不仅在影像艺术、产品质量方面精益求精，更关注企业的正规化、现代化与国际化发展。DEMO视觉在2006年已经形成了现代化企业制度，其制度初稿为诸多同行效仿。2009年3月，DEMO视觉邀请北京大学光华管理学院国际MBA项目组作为企业的管理咨询顾问，全方位提升企业管理实力。步入2010年，DEMO视觉已经形成全方位、国际化的发展战略。</p><h5>                \r\n				社会责任—时刻不忘</h5><p>                \r\n				以人为本，更体现在DEMO视觉对于企业社会责任的关注。DEMO视觉首先是一个优秀视觉企业的代表，以其“言必行、行必果”的诚信态度，提升影像行业在公众心目中的形象；其次，DEMO视觉关注环境保护与企业可持续发展，每次外出拍摄均强调对外景地的环境保护，在产品制造上也讲究使用环保工艺；今后，DEMO视觉还将设定一定比例的公益拍摄活动，担负更多企业社会责任。</p><video controls=\"controls\" height=\"500\" loop=\"loop\" src=\"/storage/images/20211207/wows3.mp4\" width=\"800\">                \r\n				&nbsp;</video></div></div><!--关于我们结束--></div>', '', 'true', '1638862913');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', '纯文本页面', 'other', 'other', '0', '', '7', '1', '4', '1004', 'about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '<div class=\"content-inner\" style=\"background-color:#fff\">\r\n	<!--关于我们开始-->\r\n	<div class=\"block block-about\">\r\n		<div class=\"about-content editor-format\">\r\n			<figure>\r\n				<img alt=\"3\" src=\"/storage/images/20211207/3.jpg\" /></figure>\r\n			<h3>\r\n				Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod</h3>\r\n			<p>\r\n				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,<br />\r\n				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo<br />\r\n				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse<br />\r\n				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non<br />\r\n				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n		</div>\r\n	</div>\r\n	<!--关于我们结束--></div>\r\n', '', 'true', '1638860398');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '联系我们', 'contact', 'contact', '0', '', '8', '1', '5', '1005', 'contact', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '媒体与商务合作邮箱：hezuo@qq.com地址：某某省某某市某某园区松科苑16号楼邮编：523808自2012年加入DEMO，一直以來我都是一个「冷眼旁观」的人。我目睹过很多诸如引号的争论、大号的退出、侵权维权等大事件，而此前做得最多就是阅读，阅读', '', '<p>\r\n	媒体与商务合作<br/>\r\n	邮箱：hezuo@qq.com<br/>\r\n	地址：某某省某某市某某园区松科苑16号楼<br/>\r\n	邮编：523808<br/>\r\n	自2012年加入DEMO，一直以來我都是一个「冷眼旁观」的人。我目睹过很多诸如引号的争论、大号的退出、侵权维权等大事件，而此前做得最多就是阅读，阅读完我通常会收起或者点赞，顶多就是到点赞为止了。</p><h5 class=\"contact-title\">\r\n	给我们留言</h5>', '', 'true', '1638865444');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '幻灯片', '', 'huandengpian', '0', '', '10', '1', '7', '1007', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'false', '1638860398');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  `tb1_background` varchar(255) NOT NULL DEFAULT '' COMMENT '背景图像',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '2', '摄影一', '', '/storage/images/20211207/01.jpg', '', '', '', 'admin', '', '1477930528', '1477930528', 'true', '', '', '摄影,一,摄影,一,', '138', '1477930484', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('2', '2', '摄影二', '', '/storage/images/20211207/02.jpg', '', '', '', 'admin', '', '1477930548', '1477930548', 'true', '', '', '摄影,二,摄影,二,', '114', '1477930535', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('3', '2', '摄影三', '', '/storage/images/20211207/03.jpg', '', '', '', 'admin', '', '1477930567', '1477930567', 'true', '', '', '摄影,三,摄影,三,', '117', '1477930556', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('4', '2', '摄影四', '', '/storage/images/20211207/city-art-graffiti-wall-large.jpg', '', '', '', 'admin', '', '1477930586', '1477930586', 'true', '', '', '摄影,四,摄影,四,', '113', '1477930574', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('5', '2', '摄影五', '', '/storage/images/20211207/city-bridge-canal-river-large.jpg', '', '', '', 'admin', '', '1477930603', '1477930603', 'true', '', '', '摄影,五,摄影,五,', '90', '1477930591', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('6', '2', '摄影六', '', '/storage/images/20211207/light-city-streets-golden-hour-large.jpg', '', '', '', 'admin', '', '1477930642', '1477930642', 'true', '', '', '摄影,六,摄影,六,', '183', '1477930662', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('7', '2', '摄影七', '', '/storage/images/20211207/pexels-photo-large.jpg', '', '', '', 'admin', '', '1477930694', '1477930694', 'true', '', '', '摄影,七,摄影,七,', '78', '1477930675', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('8', '2', '摄影八', '', '/storage/images/20211207/pexels-photo-large-1.jpg', '', '', '', 'admin', '', '1477930711', '1477930711', 'true', '', '', '摄影,八,摄影,八,', '112', '1477930697', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('9', '2', '摄影九', '', '/storage/images/20211207/street-car-vehicle-vintage-large.jpg', '', '', '', 'admin', '', '1477930729', '1477930729', 'true', '', '', '摄影,九,摄影,九,', '94', '1477930715', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('10', '3', '摄影十', '', '/storage/images/20211207/man-coffee-cup-pen-large.jpg', '', '', '', 'admin', '', '1477930802', '1477930802', 'true', '', '', '摄影,十,摄影,十,', '132', '1477930773', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('11', '3', '摄影十一', '', '/storage/images/20211207/man-hands-working-technology-large.jpg', '', '', '', 'admin', '', '1477930844', '1477930844', 'true', '', '', '摄影,十一,摄影,十一,', '154', '1477930824', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('12', '3', '摄影十二', '', '/storage/images/20211207/notes-macbook-study-conference-large.jpg', '', '', '', 'admin', '', '1477930867', '1477930867', 'true', '', '', '摄影,十二,摄影,十二,', '84', '1477930848', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('13', '3', '摄影十三', '', '/storage/images/20211207/people-apple-iphone-writing-large.jpg', '', '', '', 'admin', '', '1477930893', '1477930893', 'true', '', '', '摄影,十三,摄影,十三,', '168', '1477930876', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('14', '3', '摄影十四', '', '/storage/images/20211207/people-office-group-team-large.jpg', '', '', '', 'admin', '', '1477930915', '1477930915', 'true', '', '', '摄影,十四,摄影,十四,', '97', '1477930896', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('15', '3', '摄影十六', '', '/storage/images/20211207/person-apple-laptop-notebook-large.jpg', '', '', '', 'admin', '', '1477930954', '1477930954', 'true', '', '', '摄影,十六,摄影,十六,', '85', '1477930921', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('16', '3', '摄影十七', '', '/storage/images/20211207/photography-vintage-technology-photo-large.jpg', '', '', '', 'admin', '', '1477930970', '1477930970', 'true', '', '', '摄影,十七,摄影,十七,', '138', '1477930957', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('17', '3', '摄影十八', '', '/storage/images/20211207/typing-vintage-technology-keyboard.jpg', '', '', '', 'admin', '', '1477930987', '1477930987', 'true', '', '', '摄影,十八,摄影,十八,', '86', '1477930973', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('18', '3', '摄影十九', '', '/storage/images/20211207/woman-girl-technology-music-large.jpg', '', '', '', 'admin', '', '1477931004', '1477931004', 'true', '', '', '摄影,十九,摄影,十九,', '105', '1477930990', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('19', '3', '摄影二十', '', '/storage/images/20211207/woman-hand-technology-phone.jpg', '', '', '', 'admin', '', '1477931020', '1477931020', 'true', '', '', '摄影,二十,摄影,二十,', '139', '1477931008', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('20', '3', '摄影二十二', '', '/storage/images/20211207/woman-typing-writing-windows-large.jpg', '', '', '', 'admin', '', '1477931038', '1477931038', 'true', '', '', '摄影,二十二,摄影,二十二,', '135', '1477931023', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('21', '4', '摄影二十三', '', '/storage/images/20211207/d.jpg', '', '', '', 'admin', '', '1477931173', '1477931173', 'true', '', '', '摄影,二十三,摄影,二十三,', '171', '1477931112', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('22', '4', '摄影二十四', '', '/storage/images/20211207/goodwoodax.jpg', '', '', '', 'admin', '', '1477931275', '1477931275', 'true', '', '', '摄影,二十四,摄影,二十四,', '155', '1477931246', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('23', '4', '摄影二十五', '', '/storage/images/20211207/gw.jpg', '', '', '', 'admin', '', '1477931296', '1477931296', 'true', '', '', '摄影,二十五,摄影,二十五,', '144', '1477931278', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('24', '4', '摄影二十六', '', '/storage/images/20211207/gw4.jpg', '', '', '', 'admin', '', '1477931314', '1477931314', 'true', '', '', '摄影,二十六,摄影,二十六,', '137', '1477931300', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('25', '4', '摄影二十七', '', '/storage/images/20211207/gw6.jpg', '', '', '', 'admin', '', '1477931337', '1477931337', 'true', '', '', '摄影,二十七,摄影,二十七,', '181', '1477931318', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('26', '4', '摄影二十八', '', '/storage/images/20211207/gw9.jpg', '', '', '', 'admin', '', '1477931359', '1477931359', 'true', '', '', '摄影,二十八,摄影,二十八,', '108', '1477931342', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('27', '4', '摄影二十九', '', '/storage/images/20211207/launch-02.jpg', '', '', '', 'admin', '', '1477931388', '1477931388', 'true', '', '', '摄影,二十九,摄影,二十九,', '73', '1477931363', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('28', '4', '摄影三十', '', '/storage/images/20211207/launch-07.jpg', '', '', '', 'admin', '', '1477931406', '1477931406', 'true', '', '', '摄影,三十,摄影,三十,', '55', '1477931392', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('29', '4', '摄影三十一', '', '/storage/images/20211207/launch-08.jpg', '', '', '', 'admin', '', '1477931426', '1477931426', 'true', '', '', '摄影,三十一,摄影,三十一,', '76', '1477931411', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('30', '4', '摄影三十二', '', '/storage/images/20211207/light-person-woman-fire-large.jpg', '', '', '', 'admin', '', '1477931509', '1477931509', 'true', '', '', '摄影,三十二,摄影,三十二,', '100', '1477931494', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('31', '4', '摄影三十三', '', '/storage/images/20211207/person-beach-holiday-vacation-large.jpg', '', '', '', 'admin', '', '1477931526', '1477931526', 'true', '', '', '摄影,三十三,摄影,三十三,', '143', '1477931513', '0', '0', '0', '100', '未知', '', '');
INSERT INTO `rrz_articles` VALUES ('32', '5', 'Hospital Vall d\'Hebron Barcelona', '', '/storage/images/20211207/tedemmons-fashioneditorials5.jpg', '', '<p>\r\n	【环球网综合报道】据外媒11月3日消息，英国资深超模凯特·莫斯(Kate Moss)近日为全球著名化妆品牌芮谜(Rimmel)拍摄圣诞系列宣传片。片中凯特·莫斯金发蓬松散落大露香肩，金色系眼影打造深邃眼眸，朱红色唇妆香艳性感，完美诠释了此次皇家系列彩妆的动人效果。与此次新彩妆系列一同推出的还有指甲油系列，凯特展示了自己亲自设计的闪亮凝胶状漆红色指甲油。<br />\r\n	　　全球历史最悠久的化妆品牌芮谜与凯特·莫斯可谓缘分深远，2001年起，芮谜和超模凯特·莫斯(Kate Moss)就签署了全球代言合约。凯特是地地道道的伦敦女孩。她亲切可人、独立有魅力的伦敦街头风格，完全概括了芮谜自由尝试和无拘无束的美容哲学。</p>\r\n', '', 'admin', '', '1477933772', '1477933772', 'true', '', '据外媒11月3日消息，英国资深超模凯特·莫斯(Kate Moss)近日为全球著名化妆品牌芮谜(Rimmel)拍摄圣诞系列宣传片。片中凯特·莫斯金发蓬松散落大露香肩，金色系眼影打造深邃眼眸，朱红色唇妆香', 'Hospital,Vall,Hebron,Barcelona', '186', '1477934032', '0', '0', '0', '100', '未知', '', '/storage/images/20211207/nation-book21.jpg');
INSERT INTO `rrz_articles` VALUES ('33', '5', '乔安娜kustra', '', '/storage/images/20211207/5.jpg', '', '<p>据外媒11月13日报道，“黑珍珠”娜奥尔·坎贝尔10日晒出其与好友艾莉森·萨罗芬参加马尔法慈善舞会的照片，此次活动在纽约乔治王子舞会厅举行。<br />\r\n　　参加舞会的还有卢克·威尔逊和女友梅格·辛普森，玛莎·斯图沃特和导演索菲亚·科波拉。马尔法舞会是德克萨斯州文化艺术界的前沿，以其视觉艺术，电影和音乐而著名。参加此次舞会的主要是捐赠作品的知名艺人。<br />\r\n　　拍卖会展示的作品各不相同。但这不是娜奥尔本周首次亮相拍卖会现场，她还参加了此前举行的铂金包拍卖会，还将自己携带的手提包拿出来拍卖，并以17.5万美元的高价售出。</p>', '', 'admin', '', '1477934123', '1477934123', 'true', '', '参加舞会的还有卢克·威尔逊和女友梅格·辛普森，玛莎·斯图沃特和导演索菲亚·科波拉。马尔法舞会是德克萨斯州文化艺术界的前沿，以其视觉艺术，电影和音乐而著名。参加此次舞会', '乔安娜,乔,安娜,kustra,据,外媒,11月,13日,报', '162', '1477934055', '0', '0', '0', '100', '未知', '', '/storage/images/20211207/vunabaka-fiji-resort-creativedirection-wedge-and-lever13.jpg');
INSERT INTO `rrz_articles` VALUES ('34', '5', 'My Photography', '', '/storage/images/20211207/twiceshy-754.jpg', '', '<p>英国顶级皮具品牌玛百莉Mulberry由罗杰·索尔(Roger Saul)成立于1970年，其包包造型古朴，以真皮制造和原创性而著称，是英国时尚界的姣姣者。2012年五月份，正值玛百莉的发展高峰期，股价市值接近2500英磅，而上个月股价却低于700英镑。在过去一年半里玛百莉遭遇三次盈利预警，去年六月份，前任创意总监艾玛·希尔(Emma Hill)宣布离开玛百莉，她曾为品牌打造出新的明星产品——著名的“Alexa”包。总裁布鲁诺·吉隆(Bruno Guillon)也在今年三月份辞职。玛百莉可谓遭遇着前所未有的危机，它能卷土重来吗？<br />\r\n　　玛百莉拒绝承认失败，于是推出了宝辰(Blossom)新品系列如平价奢侈品手提包和英国宠物名店芒戈&amp;莫德(Mungo &amp; Maud)合作制作的狗狗项圈等，希望通过这些相对廉价、颜色各异的新品来迎合年轻一代的消费需求。为此，玛百莉还专门制作了圣诞节广告来宣传他们的产品。圣诞节这一天家人之间争相送礼物，最终奶奶因送给孙女一个新款的玛百莉包包而胜出，这突出了玛百莉更加现代的新方向。宝辰系列产品的价格相对以往更加亲民，手机壳和狗狗项圈都是80英镑，流苏钥匙链90英镑。卡拉•迪瓦伊手提包起价495英镑，这无疑是爱包人士的福音。此外，圣诞节期间，玛百莉还将提供免费的图案花纹服务，店门前还将摆放圣诞树，以小礼物，花枝，雪花等装饰来吸引消费者。</p>', '', 'admin', '', '1477934196', '1477934196', 'true', '', '英国顶级皮具品牌玛百莉Mulberry由罗杰·索尔(Roger Saul)成立于1970年，其包包造型古朴，以真皮制造和原创性而著称，是英国时尚界的姣姣者。2012年五月份，正值玛百莉的发展高峰期，股', 'Photography,英国,顶级,皮具,品牌,玛,百莉,M', '52', '1477934146', '0', '0', '0', '100', '未知', '', '/storage/images/20211207/vunabaka-fiji-wedgeandlever-2.jpg');
INSERT INTO `rrz_articles` VALUES ('35', '5', '高级专业摄影师Kitty', '', '/storage/images/20211207/dsc8236-crop.jpg', '', '<p>心理学家曾说，面试、约会时应多以绿色作为整身look的主色调。绿色能带给人平和、安详、谦逊的好印象，如果加以军装版型辅助，或许还能招引来“兵哥哥控”的姑娘。帅气洒脱的穿衣配以一双橄榄绿的时尚军靴，更可让男性威武气概缭绕姑娘的心头。今季，PALLADIUM推出多款橄榄绿军靴鞋履，为你打造优雅迷人的都市风格。<br />\r\n　　橄榄绿可随意百搭，但也要注意别把自己搞得老气横秋，时不时利用它调个色还是不错的选择。在颜色搭配上下点功夫，会给你意想不到的致命诱惑。橄榄绿的小配饰有时候很讨女孩子的喜欢，比如一双橄榄绿色的靴子，只要它干干净净，颜色中又带着份男性的调皮与稳重，一定会让你的整体形象加分。<br />\r\n当然，军靴并非男生的专利，女生的日常造型搭配一双橄榄绿的靴子，既硬朗帅气，又运动气息十足，还可以修饰腿型。与女生那独有的气场，完全的相得益彰。那一抺舒服的橄榄绿诠释出了，活泼轻松的冬日小情调。</p>', '', 'admin', '', '1477934255', '1477934255', 'true', '', '心理学家曾说，面试、约会时应多以绿色作为整身look的主色调。绿色能带给人平和、安详、谦逊的好印象，如果加以军装版型辅助，或许还能招引来“兵哥哥控”的姑娘。帅气洒脱的穿', '高级,专业,摄影师,Kitty,心理学家,曾,说,面试,', '159', '1477934208', '0', '0', '0', '100', '未知', '', '/storage/images/20211207/vunabaka-fiji-resort-creativedirection-wedge-and-lever2.jpg');
INSERT INTO `rrz_articles` VALUES ('36', '10', 'Welcome To Maker Cloud', '百度云设计', '/storage/images/20211207/bcs-ducks-0497.jpg', '', '', '', 'admin', '', '1638862441', '1477928869', 'true', '', '', 'Welcome,Maker,Cloud,Welcome,Ma', '123', '1487757855', '0', '0', '0', '100', '未知', 'http://www.rrzcms.com', '');
INSERT INTO `rrz_articles` VALUES ('37', '10', 'Hospital Vall d\'Hebron Barcelona', '百度云设计', '/storage/images/20211207/dw25605.jpg', '', '', '', 'admin', '', '1638862435', '1477928950', 'true', '', '', 'Hospital,Vall,Hebron,Barcelona', '198', '1487757839', '0', '0', '0', '100', '未知', 'http://www.rrzcms.com', '');
INSERT INTO `rrz_articles` VALUES ('38', '10', 'Hospital Vall d\'Hebron', 'DIY链接文本', '/storage/images/20211207/e-9899-edit.jpg', '', '', '', 'admin', '', '1638862430', '1477928994', 'true', '', '', 'Hospital,Vall,Hebron,Hospital,', '81', '1487757826', '0', '0', '0', '100', '未知', 'http://www.rrzcms.com', '');
INSERT INTO `rrz_articles` VALUES ('39', '10', 'SEIKO MANUFACTURE', '百度云设计', '/storage/images/20211207/jj9458.jpg', '', '', '', 'admin', '', '1638862422', '1477929027', 'true', '', '', 'SEIKO,MANUFACTURE,SEIKO,MANUFA', '53', '1487757794', '0', '0', '0', '100', '未知', 'http://www.rrzcms.com', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';

-- -----------------------------
-- Records of `rrz_channelfield`
-- -----------------------------
INSERT INTO `rrz_channelfield` VALUES ('1', 'tb1_background', '1', 'articles', '背景图像', 'img', 'varchar(255)', '255', '', '', '', '0', '0', '100', '1638860397', '1638860397');

-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';

-- -----------------------------
-- Records of `rrz_channeltype`
-- -----------------------------
INSERT INTO `rrz_channeltype` VALUES ('1', '新闻', 'articles', '1638860397', '0');

-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网站', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20211207/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20211207/logo.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2050 某某网站 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', 'ICP备*******号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '响应式户外景色摄影类网站人人站模板', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'hide_plugin', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '1e71ca64986dec963bd66fb3663077d3', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '00000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'email@rrzcms.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '某某省某某市某某区某某地', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '39.903970449129694,116.39786991534426', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '2', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '3', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '1300000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'wx000000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', 'http://g.kbscdn.cn/kbcms/Public/images/wxaqrrrz.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_suffix', 'html', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('53', 'app_debug', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('54', 'switch', '1', 'webcache', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('55', 'browser', '1', 'webcache', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('56', 'html', '1', 'webcache', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('57', 'data', '1', 'webcache', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '联系我们', 'a:4:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"名称\";s:8:\"required\";i:1;}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"邮箱\";s:8:\"required\";i:1;}i:2;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"电话\";s:8:\"required\";i:1;}i:3;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:6:\"内容\";s:8:\"required\";i:0;}}', '1638860428', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');
INSERT INTO `rrz_site_links` VALUES ('5', '淘进微博', 'http://weibo.kbstore.cn/', 'http://weibo.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244551', '1631698452');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '作品/摄影展示', 'gallery', 'gallery', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '新闻列表', 'news', 'news', '0', '3', '1', '/node/5.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '关于我们', 'about', 'about', '0', '4', '1', '/node/6.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '纯文本页面', 'other', 'other', '0', '5', '1', '/node/7.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '联系我们', 'contact', 'contact', '0', '6', '1', '/node/8.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '购买模板', 'link', 'goumaimoban', '0', '7', '1', 'http://www.rrzcms.com', '7', '1007', 'true', '');
