-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.7.26
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.3.4
-- Date : 2021-12-01 16:17:25
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', '21232f297a57a5a743894a0e4a801fc3', '/static/images/dfboy.png', '1638339781', '127.0.0.1', '50', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', '', 'guanyuwomen', '0', '/storage/images/20211201/e88b9783ce05fd0307a942361d06925c.jpg', '1', '1', '1', '1001', 'about', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '关于我们', '公司成立的PPP咨询团队，具有专业能力和相应资质，能够为政府以及社会资本提供系统、综合的全生命周期专业咨询服务。成员包括管理咨询、法律、财务、管理、税务等领域的专家，他们均参与过众多政府类、公共事业类、工程类等大型融资项目，对PPP具有深刻的理解，拥', '', '<p>&nbsp;公司成立的PPP咨询团队，具有专业能力和相应资质，能够为政府以及社会资本提供系统、综合的全生命周期专业咨询服务。成员包括管理咨询、法律、财务、管理、税务等领域的专家，他们均参与过众多政府类、公共事业类、工程类等大型融资项目，对PPP具有深刻的理解，拥有丰富的理论基础和实践经验。</p>', '', 'true', '1638329130');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '业务领域', 'Introduce Busness', 'chanpinzhongxin', '0', '', '2', '1', '2', '1002', 'portfolio', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1638329252');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '新闻资讯', 'News Center', 'xinwenzixun', '0', '', '6', '1', '3', '1003', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '新闻资讯', '一所方方的庭院，几棵青郁的果树，几株素雅的小花。午后，享受着小院东墙上，暖暖的阳光。', '', '', '', 'true', '1638329282');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', '案例', 'Cooperative Partner', 'anli', '0', '/storage/images/20211201/d2a413166f1bdab53f0137b134d22d76.jpg', '7', '1', '4', '1004', 'case', 'case', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '案例', '经常去河边散步。晨起看枝头含苞欲放的花蕾，暮里看枝头一朵朵闲花，在晚风中兀自悠扬。', '', '', '', 'true', '1638329456');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '平面设计', '', 'anli/pingmiansheji', '7', '', '7,10', '2', '1', '10041001', 'case', 'case', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '路旁的麦穗与夏日雨水的较量，仿佛用尽心力，生出了一些晦涩之气来。缺少阳光的麦穗，早早的枯萎了起来。', '', '&nbsp;', '', 'true', '1638322778');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '摄影艺术', '', 'anli/sheyingyishu', '7', '', '7,11', '2', '2', '10041002', 'case', 'case', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '', '', 'true', '1638322778');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '联系', 'Contact Us', 'lianxi', '0', '', '8', '1', '5', '1005', 'contacts', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '联系', '最喜欢半夏时光，夜晚乘凉，午后听书，荷塘蛙声一片，漫出阵阵清香。更是郊外院落，小轩窗里细思量，一展愁眉夜已凉。也有人儿，叹一声岁月薄凉。想那遥远的长安城外，赴京赶考的状元郎，翻越秦岭之时，与红颜相对一见，再后来，漫长的等待填满了相思的半亩花田。', '', '<table class=\"table table-bordered table-hover table-striped table-responsive\" width=\"1250\"><tbody><tr class=\"firstRow\" style=\"background-color: rgba(243, 247, 249, 0.298);\"><td style=\"line-height: 1.57143; border-color: rgb(228, 234, 236); word-break: break-all;\" valign=\"top\" width=\"808\"><p><span style=\"font-family: 微软雅黑, &quot;Microsoft YaHei&quot;;\">客服服务</span></p><ul class=\"list list-paddingleft-2\" style=\"list-style-type: square;\"><li><p><span style=\"font-family: 微软雅黑, &quot;Microsoft YaHei&quot;;\">联系电话：666-888-8888</span></p></li><li><p><span style=\"font-family: 微软雅黑, &quot;Microsoft YaHei&quot;;\">Email：lianxiwomen@web.net</span></p></li></ul></td><td style=\"line-height: 1.57143; border-color: rgb(228, 234, 236); word-break: break-all;\" valign=\"top\" width=\"808\"><p><span style=\"font-family: 微软雅黑, &quot;Microsoft YaHei&quot;;\">网盟合作 / 广告投放&nbsp;</span></p><ul class=\"list list-paddingleft-2\" style=\"list-style-type: square;\"><li><p><span style=\"font-family: 微软雅黑, &quot;Microsoft YaHei&quot;;\">联系人：赵先生 / 张女士</span></p></li><li><p><span style=\"font-family: 微软雅黑, &quot;Microsoft YaHei&quot;;\">Email：zhaoshanghezuo@web.net</span></p><div>\r\n							&nbsp;</div></li></ul></td></tr></tbody></table><p><br/>\r\n </p>', '', 'true', '1638330090');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '幻灯片', '', 'huandengpian', '0', '', '9', '1', '6', '1006', '', '', '{typedir}/{aid}.html', '{typedir}/list_{tid}_{page}.html', '', '', '', '&nbsp;', '', 'false', '1638322778');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `source` varchar(100) NOT NULL DEFAULT '' COMMENT '来源',
  `source_url` varchar(255) NOT NULL DEFAULT '' COMMENT '来源URL',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '2', '城市开发', 'Trust Insurance', '/storage/images/20211201/slide2.jpg', '', '城市开发是以城市土地使用为核心的一种经济性活动，主要以城市物业（土地和房屋）、市政基础设施（市政公用设施和公共服务设施）为对象，通过资金和劳动的投入，形成与城市功能相适应的城市空间，达成经济效益、社会效益或环境效益的目标。 传统模式下城市开发由政府全权负责，覆盖设计、规划、建设、管理等各个环节。由于城市开发涉及的范围广、开发时间长、资金需求量巨大，引入各类社会资源，有助于政府更好的开展和推进城市开发建设，因此将PPP模式运用于城市开发项目是整合各方资源和提升效率的有效途径。 PPP模式在城市开发中的应用，是将传统模式中由政府单独承担的工作，转由政府与社会资本方共同合作，以SPV公司为主体开展相关工作。 ', '', 'admin', '', '1529659907', '1529659907', 'true', '', '等待的过程，相当漫长，一分的钟摆，相当于一个世纪，真实的长短，一点不知道；但我有的是信心，倍儿般暖洋洋。因为有你一一潇洒的雨儿，我的新娘；有我，帅气的新郎，任天地', '城市,开发,城市,开发,是以,土地,使,用为,核心,', '145', '1529664862', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('2', '2', '生态环保', 'Introduce Busness', '/storage/images/20211201/fashionable.jpg', '', '指转变观念和思路，加强引导，树立绿色低碳发展观，发展绿色低碳经济、促进生态健康可持续发展。生态环保是人类社会未来发展的必然选择。政府部门要从政策层面上支持和引导大力发展绿色低碳产业，引导、支持社会树立绿色发展和低碳发展的理念。以发展绿色低碳经济实践和探索为起点，寻求适合国情的绿色低碳经济发展模式。为遏止气候变化不断恶化的势头，积极采取自主行动，从多种环节入手，节能减排降耗，减轻环境灾害，切实履行量化减排义务。 ', '', 'admin', '', '1529659941', '1529659941', 'true', '', '雨幕，我从未思想过，能与之融入，并成为主角。因为，从撑伞那一刻，就注定，我的深呼吸，令淅淅沥沥雨丝，不会将我窒息。', '生态,环保,指,转变,观念,和,思路,加强,引导,', '117', '1529664822', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('3', '2', '园区工程', 'Wheel hub wheel', '/storage/images/20211201/shopstart.jpg', '', '园区土地开发运营、园区基础设施建设及维护运营、园区产业发展、园区招商引资、园区物业运营、园区产业配套服务、园区创业孵化支持等组成了园区运营的产业价值链，价值链上的多个环节均有采用PPP模式运作和推进的可能。 园区土地开发运营：包括园区土地规划、整理开发、运营管理等；园区基础设施建设及维护运营：园区道路、管网等基础设施建设与维护；园区产业发展：包括产业园区的发展战略规划、项目概念规划、总体发展规划、产业发展规划以及项目详细规划等；园区招商引资：包括投资融资策划、招商政策策划、招商策略策划、主题招商策划及招商活动筹划；园区物业运营：包括园区扫保环卫、物业管理等运作；园区产业配套服务：包括园区内相关产业的配套服务；园区创业孵化支持：园区内企业和项目的创业孵化等。 ', '', 'admin', '', '1529659984', '1529659984', 'true', '', '我多想这一秒，它能早来到；可雨的淅沥，分明在嘲笑。作为万物灵长的人类，难道都如我一样，草包一个，没啥份量。非也，非也，没有如此的低调；所有的估计，需要现实的等待，', '园区,工程,园区,土地开发,运营,、,基础设施,', '128', '1529664753', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('4', '6', 'PPP配套融资难', '', '/storage/images/20211201/1522312758.jpg', '', '雨声如潮，淹没了这一切，我想浮出来，能看一眼街市、公园，看一眼田野、村庄。我寻到了，看到了，挽回的只是没完没了的默想。雨如同诅咒，在痴心妄想，以为一直的下，让地球变海洋。所有的生命，所有的万物，终成一只只刍狗，苟且偷生，残延低喘，屈服于它魔爪。我没有惊悸，没有感动，没有诧异，这又不是平生第一遭，再肆虐的雨，终有停歇的一秒，天空开始放晴，大地开始浪笑，阳光和空气，尽情去梳妆，无数的生命，能够跳跃；无数的繁衍，能够去生长；再被太阳一照，月亮一晃；那样的世界，肯定万分美妙……', '', 'admin', '', '1529650318', '1529650318', 'true', '', '雨幕，我从未思想过，能与之融入，并成为主角。因为，从撑伞那一刻，就注定，我的深呼吸，令淅淅沥沥雨丝，不会将我窒息。', 'PPP,配套,融资,难,雨声,如潮,淹,没了,这,一切,', '110', '1529650346', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('5', '6', '西安大明宫店隆重启幕', '', '/storage/images/20211201/1522311589.jpg', '', '　　心弦紧绷，强抑下无尽感慨。我是一个正常人，只知去嘹望；少生一口气，活上百多岁；啥子都能赚回，还在乎这点小委屈，影响了情绪，弄得不愉快，这样的微小，简直不值一提。 其实还甭说，下雨还有美，美丽的词语，我至今未寻觅。<br />\r\n<br />\r\n　　雨流如丝，滴流成河；五颜六色的伞花，开遍大街小巷；视野一瞧，觑一觑眼眸，有几分沉醉，有几分袅俏，说不定那伞下，就有迷人的姑娘，勾魂摄魄的眼，魅力性感的腰，特别是雪白大腿，不想入非非，不心花儿怒放，真的难做到。只是自己年过半百，只好打抿笑，纵然如此，也是罪恶的根源，枉自辜负平生愿望。', '', 'admin', '', '1529650486', '1529650486', 'true', '', '我多想这一秒，它能早来到；可雨的淅沥，分明在嘲笑。作为万物灵长的人类，难道都如我一样，草包一个，没啥份量。', '西安,大明,宫店,隆,重启,幕,心弦,紧绷,强抑下,', '193', '1529650429', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('6', '6', 'PPP配套融资难', '', '/storage/images/20211201/1522312758.jpg', '', '雨声如潮，淹没了这一切，我想浮出来，能看一眼街市、公园，看一眼田野、村庄。我寻到了，看到了，挽回的只是没完没了的默想。雨如同诅咒，在痴心妄想，以为一直的下，让地球变海洋。所有的生命，所有的万物，终成一只只刍狗，苟且偷生，残延低喘，屈服于它魔爪。我没有惊悸，没有感动，没有诧异，这又不是平生第一遭，再肆虐的雨，终有停歇的一秒，天空开始放晴，大地开始浪笑，阳光和空气，尽情去梳妆，无数的生命，能够跳跃；无数的繁衍，能够去生长；再被太阳一照，月亮一晃；那样的世界，肯定万分美妙……', '', 'admin', '', '1529650318', '1529650318', 'true', '', '雨幕，我从未思想过，能与之融入，并成为主角。因为，从撑伞那一刻，就注定，我的深呼吸，令淅淅沥沥雨丝，不会将我窒息。', 'PPP,配套,融资,难,雨声,如潮,淹,没了,这,一切,', '110', '1529650346', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('7', '6', '西安大明宫店隆重启幕', '', '/storage/images/20211201/1522311589.jpg', '', '　　心弦紧绷，强抑下无尽感慨。我是一个正常人，只知去嘹望；少生一口气，活上百多岁；啥子都能赚回，还在乎这点小委屈，影响了情绪，弄得不愉快，这样的微小，简直不值一提。 其实还甭说，下雨还有美，美丽的词语，我至今未寻觅。<br />\r\n<br />\r\n　　雨流如丝，滴流成河；五颜六色的伞花，开遍大街小巷；视野一瞧，觑一觑眼眸，有几分沉醉，有几分袅俏，说不定那伞下，就有迷人的姑娘，勾魂摄魄的眼，魅力性感的腰，特别是雪白大腿，不想入非非，不心花儿怒放，真的难做到。只是自己年过半百，只好打抿笑，纵然如此，也是罪恶的根源，枉自辜负平生愿望。', '', 'admin', '', '1529650486', '1529650486', 'true', '', '我多想这一秒，它能早来到；可雨的淅沥，分明在嘲笑。作为万物灵长的人类，难道都如我一样，草包一个，没啥份量。', '西安,大明,宫店,隆,重启,幕,心弦,紧绷,强抑下,', '193', '1529650429', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('8', '6', 'PPP配套融资难', '', '/storage/images/20211201/1522312758.jpg', '', '雨声如潮，淹没了这一切，我想浮出来，能看一眼街市、公园，看一眼田野、村庄。我寻到了，看到了，挽回的只是没完没了的默想。雨如同诅咒，在痴心妄想，以为一直的下，让地球变海洋。所有的生命，所有的万物，终成一只只刍狗，苟且偷生，残延低喘，屈服于它魔爪。我没有惊悸，没有感动，没有诧异，这又不是平生第一遭，再肆虐的雨，终有停歇的一秒，天空开始放晴，大地开始浪笑，阳光和空气，尽情去梳妆，无数的生命，能够跳跃；无数的繁衍，能够去生长；再被太阳一照，月亮一晃；那样的世界，肯定万分美妙……', '', 'admin', '', '1529650318', '1529650318', 'true', '', '雨幕，我从未思想过，能与之融入，并成为主角。因为，从撑伞那一刻，就注定，我的深呼吸，令淅淅沥沥雨丝，不会将我窒息。', 'PPP,配套,融资,难,雨声,如潮,淹,没了,这,一切,', '110', '1529650346', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('9', '6', '西安大明宫店隆重启幕', '', '/storage/images/20211201/1522311589.jpg', '', '　　心弦紧绷，强抑下无尽感慨。我是一个正常人，只知去嘹望；少生一口气，活上百多岁；啥子都能赚回，还在乎这点小委屈，影响了情绪，弄得不愉快，这样的微小，简直不值一提。 其实还甭说，下雨还有美，美丽的词语，我至今未寻觅。<br />\r\n<br />\r\n　　雨流如丝，滴流成河；五颜六色的伞花，开遍大街小巷；视野一瞧，觑一觑眼眸，有几分沉醉，有几分袅俏，说不定那伞下，就有迷人的姑娘，勾魂摄魄的眼，魅力性感的腰，特别是雪白大腿，不想入非非，不心花儿怒放，真的难做到。只是自己年过半百，只好打抿笑，纵然如此，也是罪恶的根源，枉自辜负平生愿望。', '', 'admin', '', '1529650486', '1529650486', 'true', '', '我多想这一秒，它能早来到；可雨的淅沥，分明在嘲笑。作为万物灵长的人类，难道都如我一样，草包一个，没啥份量。', '西安,大明,宫店,隆,重启,幕,心弦,紧绷,强抑下,', '193', '1529650429', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('10', '6', 'PPP配套融资难', '', '/storage/images/20211201/1522312758.jpg', '', '雨声如潮，淹没了这一切，我想浮出来，能看一眼街市、公园，看一眼田野、村庄。我寻到了，看到了，挽回的只是没完没了的默想。雨如同诅咒，在痴心妄想，以为一直的下，让地球变海洋。所有的生命，所有的万物，终成一只只刍狗，苟且偷生，残延低喘，屈服于它魔爪。我没有惊悸，没有感动，没有诧异，这又不是平生第一遭，再肆虐的雨，终有停歇的一秒，天空开始放晴，大地开始浪笑，阳光和空气，尽情去梳妆，无数的生命，能够跳跃；无数的繁衍，能够去生长；再被太阳一照，月亮一晃；那样的世界，肯定万分美妙……', '', 'admin', '', '1529650318', '1529650318', 'true', '', '雨幕，我从未思想过，能与之融入，并成为主角。因为，从撑伞那一刻，就注定，我的深呼吸，令淅淅沥沥雨丝，不会将我窒息。', 'PPP,配套,融资,难,雨声,如潮,淹,没了,这,一切,', '110', '1529650346', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('11', '6', '西安大明宫店隆重启幕', '', '/storage/images/20211201/1522311589.jpg', '', '　　心弦紧绷，强抑下无尽感慨。我是一个正常人，只知去嘹望；少生一口气，活上百多岁；啥子都能赚回，还在乎这点小委屈，影响了情绪，弄得不愉快，这样的微小，简直不值一提。 其实还甭说，下雨还有美，美丽的词语，我至今未寻觅。<br />\r\n<br />\r\n　　雨流如丝，滴流成河；五颜六色的伞花，开遍大街小巷；视野一瞧，觑一觑眼眸，有几分沉醉，有几分袅俏，说不定那伞下，就有迷人的姑娘，勾魂摄魄的眼，魅力性感的腰，特别是雪白大腿，不想入非非，不心花儿怒放，真的难做到。只是自己年过半百，只好打抿笑，纵然如此，也是罪恶的根源，枉自辜负平生愿望。', '', 'admin', '', '1529650486', '1529650486', 'true', '', '我多想这一秒，它能早来到；可雨的淅沥，分明在嘲笑。作为万物灵长的人类，难道都如我一样，草包一个，没啥份量。', '西安,大明,宫店,隆,重启,幕,心弦,紧绷,强抑下,', '193', '1529650429', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('12', '6', 'PPP配套融资难', '', '/storage/images/20211201/1522312758.jpg', '', '雨声如潮，淹没了这一切，我想浮出来，能看一眼街市、公园，看一眼田野、村庄。我寻到了，看到了，挽回的只是没完没了的默想。雨如同诅咒，在痴心妄想，以为一直的下，让地球变海洋。所有的生命，所有的万物，终成一只只刍狗，苟且偷生，残延低喘，屈服于它魔爪。我没有惊悸，没有感动，没有诧异，这又不是平生第一遭，再肆虐的雨，终有停歇的一秒，天空开始放晴，大地开始浪笑，阳光和空气，尽情去梳妆，无数的生命，能够跳跃；无数的繁衍，能够去生长；再被太阳一照，月亮一晃；那样的世界，肯定万分美妙……', '', 'admin', '', '1529650318', '1529650318', 'true', '', '雨幕，我从未思想过，能与之融入，并成为主角。因为，从撑伞那一刻，就注定，我的深呼吸，令淅淅沥沥雨丝，不会将我窒息。', 'PPP,配套,融资,难,雨声,如潮,淹,没了,这,一切,', '110', '1529650346', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('13', '6', '西安大明宫店隆重启幕', '', '/storage/images/20211201/1522311589.jpg', '', '　　心弦紧绷，强抑下无尽感慨。我是一个正常人，只知去嘹望；少生一口气，活上百多岁；啥子都能赚回，还在乎这点小委屈，影响了情绪，弄得不愉快，这样的微小，简直不值一提。 其实还甭说，下雨还有美，美丽的词语，我至今未寻觅。<br />\r\n<br />\r\n　　雨流如丝，滴流成河；五颜六色的伞花，开遍大街小巷；视野一瞧，觑一觑眼眸，有几分沉醉，有几分袅俏，说不定那伞下，就有迷人的姑娘，勾魂摄魄的眼，魅力性感的腰，特别是雪白大腿，不想入非非，不心花儿怒放，真的难做到。只是自己年过半百，只好打抿笑，纵然如此，也是罪恶的根源，枉自辜负平生愿望。', '', 'admin', '', '1529650486', '1529650486', 'true', '', '我多想这一秒，它能早来到；可雨的淅沥，分明在嘲笑。作为万物灵长的人类，难道都如我一样，草包一个，没啥份量。', '西安,大明,宫店,隆,重启,幕,心弦,紧绷,强抑下,', '202', '1529650429', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('14', '10', '服饰加工网站建设案例', '', '/storage/images/20211201/1-1G025145K1K8.jpg', '', '花开的声音清溢有致，花开的声音飘逸泛香，花开的声音独特不凡。它，悄然而至，倏然回归，仿佛若远古的旷音，丝毫没有经我们人类批准，就潇潇洒洒地将花儿推向了世界。然而，它毕竟还是像天上的星辰般闪烁。任我们人类们，不断将它所欣赏，所微笑，所恣意飞扬。如同适逢有月光的夜晚，那圆圆的，弯弯的，椭圆的，想必自是月亮高挂苍穹，是我们人类自己被自己眼睛欺骗，才有了月亮的各种不同形状。但真正的月亮当是没有发生任何变化，可这样的，还是误区众多，任人揣评。然而，还是有美妙享受，并将幸福茁现。', '', 'admin', '', '1529658031', '1529658031', 'true', '', '花开的声音，真正有一种慵懒的气息，蓓蕾地绽放，如同少女对镜梳妆，轻抹慢擦，待梳妆完毕，自是光彩照人。', '服饰,加工,网站建设,案例,花开,的,声音,清溢,', '135', '1529657984', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('15', '10', 'GUI设计定制网站开发', '', '/storage/images/20211201/cloud_59_2.jpg', '', '若要记住，请听清了，花开的声音，是几乎记不住的，可真要记，那就须年年相逢花开日，季季花开逢靓时，岁岁关注不错过，那种与花亲密接触的机会，当是多多益善，需要时日去窥之悟之。不然，当一场失之交臂的错过花期，你有悔，又能怎样，毕竟，相拥相离，叹为观止矣。', '', 'admin', '', '1529658176', '1529658176', 'true', '', '花开的声音，真正有一种慵懒的气息，蓓蕾地绽放，如同少女对镜梳妆，轻抹慢擦，待梳妆完毕，自是光彩照人。', 'GUI,设计,定制,网站开发,若要,记住,请,听清,了,', '71', '1529658447', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('16', '10', '简约网站建设Dede人人站模板', '', '/storage/images/20211201/iElakYd.png', '', '自适应，强大选项面板，页面/文章选项，页面搭建，简码生成，轻松安装使用，一键导入数据，MEGA菜单，自定义背景，WooCommerce购物商城，CSS3动画，无限颜色，高级头部和底部选项，分层幻灯片，10000+图标，宽和窄布局，WPML支持，高级博客和作品设置选项，SEO，无限侧边栏等，百度源码提供演示数据和说明文档等。', '', 'admin', '', '1529658302', '1529658302', 'true', '', '徜徉花开，没有二样。可要做到的，能有几何？但思想花开的声音，必有少年时的游玩，在清晰地为我送出一瞬之记忆。', '简约,网站建设,Dede,人人站,模板,自,适应,强大,', '103', '1529658269', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('17', '10', '摄影相册WordPress主题', '', '/storage/images/20211201/bZ6WJ2Y.jpg', '', '如今，坐在城市的高楼里，空调下的温度适宜，而心中却像长了草一样的难以安静。总是忍不住关心网络上的资讯，虽然很多与自己没有半毛钱的关系。于是，习静成了寻找的避暑之地。古人有“山中习静朝观槿，松下清斋折露葵。”而今于我们，寻找心中的一份宁静之气，才能安然于岁月。泡上一杯茶，点上一支烟，坐在沙发里，或独坐几时，或翻阅闲书，让心平静下来，此刻，静思往事，如在目底。习于安静，并不是不理尘世，而是在沉静的心底，接纳包容世事，然后，在生活的浪潮里摸打滚爬。', '', 'admin', '', '1529658410', '1529658410', 'true', '', '这就是我的少年时代之花开声音，但可不知，是花开之声音交染，还是花开之声音闪亮，才将我之走过人生的四十多年光阴。', '摄影,相册,WordPress,主题,如今,坐在,城市,的,', '152', '1529658432', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('18', '9', '基于互联网思维', '查看详情', '/storage/images/20211201/1522306048.jpg', '', '', '', 'admin', '', '1529642990', '1529642990', 'true', '', '提供全生命周期的综合性咨询服务', '基于,互联网,思维,基于,互联网,思维,', '158', '1529643616', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('19', '9', '拥有PPP领域资深的专家团队', 'Smart Grid', '/storage/images/20211201/1522311320.jpg', '', '', '', 'admin', '', '1529643125', '1529643125', 'true', '', '让专业领域服务变得更加完善', '拥有,PPP,领域,资,深的,专家,团队,拥有,PPP,', '131', '1529643076', '0', '0', '0', '100', '未知', '');
INSERT INTO `rrz_articles` VALUES ('20', '9', '丰富的PPP咨询经验', '查看详情', '/storage/images/20211201/1522311589.jpg', '', '', '', 'admin', '', '1529643296', '1529643296', 'true', '', '雨如同诅咒，在痴心妄想，以为一直的下，让地球变海洋。', '丰富,的,PPP,咨询,经验,丰富,的,PPP,咨询,经验,', '53', '1529643236', '0', '0', '0', '100', '未知', '');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某网络科技有限公司', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20211201/3b1016260d0a9f8db73ef5427b343107.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20211201/d265e6baaea32eed63b09b1b1212214f.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '/storage/images/20200509/9e9ffe4e859c185d063363237637f296.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2018 某某公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '响应式网站建设推广优化类网站人人站模板(自适应手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '广州某某公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '广东省广州市天河区88号', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|品牌|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|冠军|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|军方|军事|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'WX8888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', '/storage/images/20211201/dd879e181bdbeabb3a2720ba703e44b5.png', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('49', 'nav_hide_suffix', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('50', 'url_level_dir', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('51', 'app_debug', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('52', 'hide_plugin', '0', 'admin', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `subtitle` varchar(255) DEFAULT '' COMMENT '副标题',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `brand_id` int(10) unsigned DEFAULT '0' COMMENT '产品品牌id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE,
  KEY `idx_brand_id` (`brand_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_brand`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_brand`;
CREATE TABLE `rrz_goods_brand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌表',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌名称',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌logo',
  `desc` text COMMENT '备注介绍',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '品牌地址',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='产品品牌';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `en_title` varchar(255) NOT NULL DEFAULT '' COMMENT '分类英文名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `view_route` varchar(255) NOT NULL DEFAULT '{typedir}/{aid}.html' COMMENT '详情页路由',
  `list_route` varchar(255) NOT NULL DEFAULT '{typedir}/list_{tid}_{page}.html' COMMENT '列表页路由',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_plugin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_plugin`;
CREATE TABLE `rrz_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `desc` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `version` varchar(20) NOT NULL DEFAULT '' COMMENT '版本号',
  `author` varchar(30) NOT NULL DEFAULT '' COMMENT '作者',
  `isadmin` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否存在后台（0否1是）',
  `ishome` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否存在前台（0否1是）',
  `isload` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自动加载（0手动加载、1自动加载）',
  `loadtemp` text COMMENT '自动加载在指定模板，空白默认全部',
  `config` text COMMENT '额外参数',
  `data` text COMMENT '配置存储数据，简单插件可以不创建表',
  `saflag` varchar(500) DEFAULT NULL COMMENT '标示内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0未安装、1启用、2禁用）',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='插件表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481203', '1627543172');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', 'http://taobao.kbstore.cn/Public/images/logo-1.png', '100', '1', '', '', '1', 'cn', '1590481246', '1627543144');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', 'http://g.kbscdn.cn/kbcms/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1590481266', '1627543178');
INSERT INTO `rrz_site_links` VALUES ('4', '抖进微信', 'http://dou.kbstore.cn/', 'http://dou.kbstore.cn/Public/images/logo.png', '100', '1', '', '', '1', 'cn', '1621244482', '1627543197');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `en_title` varchar(100) NOT NULL DEFAULT '' COMMENT '英文标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '首页', 'Home', 'index', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', '', 'guanyuwomen', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '业务领域', '', 'chanpinzhongxin', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '新闻资讯', '', 'xinwenzixun', '0', '4', '1', '/node/6.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '案例', '', 'anli', '0', '5', '1', '/node/7.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '联系', '', 'lianxi', '0', '6', '1', '/node/8.html', '6', '1006', 'false', '');
