-- ----------------------------------------
-- RRZCMS MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.53
-- Database       : rrzcms
-- 
-- Part : #1
-- Version : #v1.1.9
-- Date : 2020-12-15 19:29:57
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- Table structure for `rrz_admin`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin`;
CREATE TABLE `rrz_admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `head_pic` varchar(255) DEFAULT '' COMMENT '头像',
  `last_login` int(11) unsigned DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) unsigned DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) unsigned DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `syn_users_id` int(10) unsigned DEFAULT '0' COMMENT '同步注册到会员表',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员表';

-- -----------------------------
-- Records of `rrz_admin`
-- -----------------------------
INSERT INTO `rrz_admin` VALUES ('1', 'admin', '', 'admin', '', '', 'e10adc3949ba59abbe56e057f20f883e', '/static/images/dfboy.png', '1608031750', '127.0.0.1', '253', '', '0', '1', 'cn', '1', '1', '1586479354', '1588751715');

-- ----------------------------
-- Table structure for `rrz_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_log`;
CREATE TABLE `rrz_admin_log` (
  `id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) NOT NULL DEFAULT '-1' COMMENT '管理员id',
  `log_info` text COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT '' COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT '' COMMENT 'url',
  `log_time` int(11) DEFAULT '0' COMMENT '日志时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='管理员日志表';


-- ----------------------------
-- Table structure for `rrz_admin_role`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_admin_role`;
CREATE TABLE `rrz_admin_role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) DEFAULT NULL COMMENT '角色名称',
  `act_list` text COMMENT '权限列表',
  `role_desc` varchar(255) DEFAULT NULL COMMENT '角色描述',
  PRIMARY KEY (`role_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='用户角色表';

-- -----------------------------
-- Records of `rrz_admin_role`
-- -----------------------------
INSERT INTO `rrz_admin_role` VALUES ('1', '超级管理员', 'all', '管理全站');

-- ----------------------------
-- Table structure for `rrz_article_nodes`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_article_nodes`;
CREATE TABLE `rrz_article_nodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '栏目图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '栏目深度',
  `sort` smallint(6) unsigned DEFAULT '50' COMMENT '排序',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '发布',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章类目';

-- -----------------------------
-- Records of `rrz_article_nodes`
-- -----------------------------
INSERT INTO `rrz_article_nodes` VALUES ('1', '0', '关于我们', '', '0', '/storage/images/20201215/inav1.jpg', '1', '1', '1', '1001', 'single', '', '', '关于创业邦创业邦成立于2007年，是中国领先的专业创业服务平台，致力于帮助创业者实现创业梦想，推动各领域高成长企业快速发展。创业邦为创业者提供高价值的资讯与服务，推动中国创新创业。旗下拥有传媒互动、创业孵化、融资服务等业务。产品与服务创业邦传媒包括 ', 'about us', '<p>关于创业邦</p><p>创业邦成立于2007年，是中国领先的专业创业服务平台，致力于帮助创业者实现创业梦想，推动各领域高成长企业快速发展。</p><p>创业邦为创业者提供高价值的资讯与服务，推动中国创新创业。旗下拥有传媒互动、创业孵化、融资服务等业务。</p><h4>产品与服务</h4><p>创业邦传媒</p><p>包括 创业邦网站、杂志、App、微信公众号、微博、数据库、创业创新榜单、研究报告及峰会等，为创业者提供全方位、高价值的资讯与数据服务。 创业邦100未来领袖峰会每年一届，发布“ 创业邦100”榜单，致力于挖掘具备独角兽潜质的创新公司。</p><p>创新中国DEMO CHINA</p><p>创新产品服务、商业模式的展示平台。2006年开始举办，2015年，每届峰会已达万人规模，超过1500位一线投资人列席、100余个创新项目进行展示。已累计助力500余家企业融资超过30亿美元。</p><p>创业邦成长营BANG CAMP</p><p>每期成长营为60个创新项目提供90天的孵化加速服务。通过产品打磨、商业模式梳理、融资演练、推广分析、领导力沙盘等系统实战培训，助力创业者思维通道和能力结构的快速搭建。2016年计划开办5期。</p><p>创业邦创新空间DEMO SPACE</p><p>创业邦旗下实体创新孵化空间，集创业邦媒体、活动、投资、导师、社群等资源优势，为初创企业提供优质办公空间和全面孵化加速服务。2016年，创业邦孵化器已在北京、上海、深圳、广州、杭州、苏州、成都、重庆、南京、常州等10个城市开放。</p><p>创业邦天使基金</p><p>专注于早期高科技领域的投资，并为所投资公司提供公司治理、人才引进、资源合作、融资咨询等增值服务。 创业邦天使基金同时拥有美元及人民币基金，截止到2015年底，已投资30余个创业项目。</p><p><br/></p>', '      ', 'true', '1608018132');
INSERT INTO `rrz_article_nodes` VALUES ('2', '0', '新闻动态', '', '0', '', '2', '1', '2', '1002', '', '', '', '  ', 'news', '    ', '    ', 'true', '1608019447');
INSERT INTO `rrz_article_nodes` VALUES ('3', '0', '招生简章', '', '0', '/storage/images/20201215/inav2.jpg', '3', '1', '3', '1003', 'single', '', '', '人才管理人才管理从战略和组织发展需求出发，围绕人才队伍建设，针对不同人才群体形成差异化的管理系统，构成人才标准、规划、选拔、培养、使用和保留的管理闭环。推动关键岗位员工进行多岗位、跨职能、跨行业历练，不断优化人与岗位、人与团队、人与组织的匹配度，完善', '', '<p>人才管理</p><ul style=\"list-style-type: none;\" class=\" list-paddingleft-2\"><li><p>人才管理从战略和组织发展需求出发，围绕人才队伍建设，针对不同人才群体形成差异化的管理系统，构成人才标准、规划、选拔、培养、使用和保留的管理闭环。</p></li><li><p>推动关键岗位员工进行多岗位、跨职能、跨行业历练，不断优化人与岗位、人与团队、人与组织的匹配度，完善人才队伍的结构和水平，保持组织的激情与活力。</p></li></ul><p>&nbsp;</p><p>人才观</p><ul style=\"list-style-type: none;\" class=\" list-paddingleft-2\"><li><p>秉持“尊重人的价值、开发人的潜能、升华人的心灵”人才工作宗旨，把打造成一个海纳百川的组织，在这个组织里，普通的人变成优秀的人，优秀的人变成卓越的人，源源不断的人在这里实现自己的人生梦想。</p></li><li><p>培养和造就一支赢得市场领先、创造组织优势、引领价值导向、有使命感与责任感的人才队伍，支持战略目标的实现，是持续不断的人才追求。</p></li><li><p>从生活、情感、成长环节关爱员工。</p></li><li><p>人珍视自己内心的梦想和追求，因为有梦想才更加有活力、更加有创造力、更加有超越其他组织和个人的推动力，实现自我境界的升华。</p></li></ul><p><br/></p>', '    ', 'true', '1608017609');
INSERT INTO `rrz_article_nodes` VALUES ('4', '0', '外教团队', '', '0', '', '4', '1', '4', '1004', 'img', '', '', '  ', 'TEACHER TEAM', '      ', '      ', 'true', '1608017887');
INSERT INTO `rrz_article_nodes` VALUES ('5', '0', '学员风采', '', '0', '', '5', '1', '5', '1005', 'img', '', '', '  ', 'TRAINEES', '    ', '    ', 'true', '1608017892');
INSERT INTO `rrz_article_nodes` VALUES ('6', '0', '就业指南', '', '0', '', '6', '1', '6', '1006', '', '', '', '  ', 'CAREERS', '    ', '    ', 'true', '1608018001');
INSERT INTO `rrz_article_nodes` VALUES ('7', '0', '在线报名', '', '0', '', '7', '1', '7', '1007', 'liuyan', '', '', '  ', '', '    ', '    ', 'true', '1608020520');
INSERT INTO `rrz_article_nodes` VALUES ('8', '0', '联系我们', '', '0', '/storage/images/20201215/inav3.jpg', '8', '1', '8', '1008', 'single', '', '', '地址：这里是您的公司地址电话：400-0000-9988传真：400-0000-9988邮编：000000邮箱：这里是您公司的邮箱地址', 'contact us', '<p>地址：这里是您的公司地址<br style=\"white-space: normal; color: rgb(81, 93, 107); font-family: Simsun; line-height: 30px;\"/>电话：400-0000-9988<br style=\"white-space: normal; color: rgb(81, 93, 107); font-family: Simsun; line-height: 30px;\"/>传真：400-0000-9988<br style=\"white-space: normal; color: rgb(81, 93, 107); font-family: Simsun; line-height: 30px;\"/>邮编：000000<br style=\"white-space: normal; color: rgb(81, 93, 107); font-family: Simsun; line-height: 30px;\"/>邮箱：这里是您公司的邮箱地址</p>', '      ', 'true', '1608018095');
INSERT INTO `rrz_article_nodes` VALUES ('9', '0', '公司新闻', '', '2', '', '2,9', '2', '1', '10021001', '', '', '', '', '', '  ', '  ', 'true', '1608000723');
INSERT INTO `rrz_article_nodes` VALUES ('10', '0', '行业动态', '', '2', '', '2,10', '2', '2', '10021002', '', '', '', '', '', '  ', '  ', 'true', '1608000731');
INSERT INTO `rrz_article_nodes` VALUES ('11', '0', '团队一类', '', '4', '', '4,11', '2', '1', '10041001', 'img', '', '', '  ', '', '    ', '    ', 'true', '1608000750');
INSERT INTO `rrz_article_nodes` VALUES ('12', '0', '团队二类', '', '4', '', '4,12', '2', '2', '10041002', 'img', '', '', '', '', '  ', '  ', 'true', '1608000761');
INSERT INTO `rrz_article_nodes` VALUES ('13', '0', '团队三类', '', '4', '', '4,13', '2', '3', '10041003', 'img', '', '', '', '', '  ', '  ', 'true', '1608000769');
INSERT INTO `rrz_article_nodes` VALUES ('14', '0', '团队四类', '', '4', '', '4,14', '2', '4', '10041004', 'img', '', '', '', '', '  ', '  ', 'true', '1608000778');

-- ----------------------------
-- Table structure for `rrz_articles`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_articles`;
CREATE TABLE `rrz_articles` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `node_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '类别ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '文章标题',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '文章配图',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `content` longtext COMMENT '文章内容',
  `wap_content` longtext COMMENT '手机端内容',
  `author` varchar(100) NOT NULL DEFAULT '' COMMENT '文章作者',
  `author_email` varchar(60) NOT NULL DEFAULT '' COMMENT '作者邮箱',
  `uptime` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  `pubtime` int(10) unsigned DEFAULT '0' COMMENT '文章发布时间',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '发布',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '文章创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_node_id` (`node_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_ifpub` (`ifpub`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='文章';

-- -----------------------------
-- Records of `rrz_articles`
-- -----------------------------
INSERT INTO `rrz_articles` VALUES ('1', '9', '本田预计2025年推无人驾驶汽车 比其他公司晚5年', '', '', '<p>\r\n	6月9日消息，据CNET报道，过去在谈论无人驾驶汽车和其他未来计划时，日本汽车巨头本田公司都显得特别谨慎。现在，它终于放开了！本田公司预计在2025年推出无人驾驶汽车。这些汽车将支持4级无人驾驶功能，即仅在特定驾驶模式下需要人类干预，其余时间都由汽车自主驾驶，并可监控环境。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	图：本田公司的硬件战略与其他竞争对手没有太大区别，主要依赖摄像头、雷达以及激光雷达</p>\r\n<p>\r\n	但在此之前，本田也不会毫无作为。本田计划在2020年推出半自动无人驾驶系统，帮助汽车在高速公路上实现无人驾驶。本田公司于本周在日本对这套系统进行了早期演示，给人留下深刻印象。与此同时，本田还试图通过增加研发和制造部门之间的协调合作，以控制研发成本，该公司也正研发先进的安全系统和电动系统。</p>\r\n<p>\r\n	目前还不清楚哪些本田汽车最终会实现电动化，但到2030年，电动车型（包括混合动力车、电池电能和氢燃料电池车）将占本田所有汽车产品的2/3。目前，这个数字约占5%。</p>\r\n<p>\r\n	本田计划在2025年将4级无人驾驶汽车投放到公路上，比其他汽车制造商估计的时间晚了五年。但在这个新兴市场上，率先上市并不意味着是最明智之举。看看特斯拉电动汽车公司，所有的眼睛都在盯着它，任何事故都会在整个互联网上引发喧嚣。特斯拉或许能够渡过难关，但传统汽车制造商将面临更困难的挑战。</p>\r\n<p>\r\n	以阿波罗13号为例，当出现问题时，所有舆论都呈现负面形态，导致人类文明几十年来始终在围绕蓝色地球运行。直到现在，我们才开始认真考虑把人类送往火星。类似的挫折很容易发生在无人驾驶汽车领域，而且很可能这个领域的“某个先驱者”将承受最大损失。在这种情况下，“迟到”可能是最明智的选择。（小小）</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '6月9日消息，据CNET报道，过去在谈论无人驾驶汽车和其他未来计划时，日本汽车巨头本田公司都显得特别谨慎。现在，它终于放开了！本田公司预计在2025年推出无人驾驶汽车。这些汽车', '本田,预计,2025年,推,无人,驾驶,汽车,比,其他,', '186', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('2', '9', '针对日本市场推出Link移动 VR 头盔:U11专属', '', '', '<p>\r\n	在智能手机行业节节败退的 HTC 在 VR 市场混的还不错，今天它们又推出了名为 Link 的移动 VR 头戴设备，而在一周前，雷锋网报道它们刚刚携手谷歌推出了 Vive 独立头戴设备（基于 Daydream 平台，HTC 也有支持 Daydream 的手机）。不过，Link 并不归属于 Vive 品牌下。</p>\r\n<p>\r\n	2015年3 月发布以来，Vive 已经帮 HTC 奠定了在 VR 界的地位。为了推动自家的 VR 项目，HTC 还专门为 Vive 成立了分公司，因此 Link 并未归属于 Vive 品牌着实让人惊讶。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	HTC 为何要做出这样的决定呢？雷锋网了解到，因为此前 HTC Vive 副总裁鲍永哲曾透露称，这款产品只是外部团队的实验性行为，跟 HTC 和 Vive 关系不大，而且该机只在日本市场上市。不过，HTC 还是给这款设备贴上了 U11 智能机专用的标签，也许 HTC 是想拉自家智能手机业务一把吧。值得注意的是，要想使用位置追踪功能（六轴动态感应），用户还得使用外置的追踪系统（套件中附送），这对性能普遍较弱的移动 VR 设备可是破天荒的第一次。</p>\r\n<p>\r\n	据雷锋网(公众号：雷锋网)了解，这套外置追踪系统由 Ximmerse 研发，此前他们曾在 CES 上展示过原型。其中由三部分组成：无线手柄、头部信标和双目跟踪器，可支持 3x3 米使用范围。</p>\r\n<p>\r\n	在使用上，Link 也与市场上的移动 VR 头盔有所不同，手机无需插在头盔上，而是通过 USB-C 与头盔联机。这就意味着手机是这套设备的处理系统，而 Link 则自带屏幕充当显示系统。硬件方面，Link 搭载 3.6 英寸 OLED 屏幕，分辨率为 1080x1200，视场可达 110 度，刷新率为 90Hz， 重 554 克。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	虽然在 VR 界有了不少建树，但 HTC 的智能机部门和 VR 部门却很少有互动，HTC 官网主页上甚至都很难找到 Vive 这款明星产品的信息，想关注 Vive，你还得点击链接跳转到 Vive 的官网。</p>\r\n<p>\r\n	总的来说，Link 就像是 Facebook 发布了一款打着社交巨头 Logo 的 VR 设备，而这款设备却与 Oculus 没有任何关系。</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '在智能手机行业节节败退的 HTC 在 VR 市场混的还不错，今天它们又推出了名为 Link 的移动 VR 头戴设备，而在一周前，雷锋网报道它们刚刚携手谷歌推出了 Vive 独立头戴设备（基于 Dayd', '针对,日本,市场,推出,Link,移动,头盔,U11,专属,', '94', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('3', '9', '普及太快！我们该不该对机器人征税呢', '/storage/images/20201215/13345S949-0.jpg', '', '<p>\r\n	你听说过对机器人征税这种科幻小说一样的事吗？《日本经济新闻》5月25日报道称，之所以讨论对机器人征税，是因为如果配备了人工智能(AI)等的高功能机器人在工厂和企业普及，会导致很多人失业。因此有意见认为，为了支援失业者，有必要对机器人征税。</p>\r\n<p>\r\n	2016年，欧盟议会提出了对机器人征税的提案。这也引发了各界对这一话题的广泛热议。尽管该提案在2017年2月被否决，但据称为了抑制机器人的过度使用，欧盟议会正在就相关法律的制定进行探讨。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	美国微软创始人比尔?盖茨对向机器人征税的提案表示了赞同。诺贝尔经济学奖获得者、美国耶鲁大学教授罗伯特?席勒也表示理解称，“如果将来自机器人的税收用于劳动者的职业培训，将有助于缓解他们心理上的痛楚”。据预测，美国将有近半劳动者因机器人的出现而失业。对于大量失业影响经济运行的危机感引发了人们对机器人税的关注。</p>\r\n<p>\r\n	在日本，了解税收制度的东京财团首席研究员森信茂树指出，“现在已经到了制定新的税收制度来应对大量失业的时期了”。他提倡对由政府支持技术开发的AI及机器人的专利等无形资产征税的机制。但目前尚未在日本国内引发广泛的讨论。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	日本是机器人大国。制造工序的机械化提高了生产效率，增强了竞争力。有数据显示，日本汽车制造业机器人的利用规模是美国和德国的约1.4倍。也许正因为机器人是竞争力的基础，对其征税这一话题才难以引发讨论。日本经济产业研究所首席研究员岩本晃一指出，“对机器人征税的话，使用机器人最多的汽车产业会把工厂转移到海外，相关就业状况将陷入恶化”。</p>\r\n<p>\r\n	32年前，日本也有过对机器人征税的相关提案，当时的日本社会党议员安恒良一在国会提案称，“必须认真讨论对机器人征税”。后来，新兴的服务业创造了大量工作岗位，吸收了就业，安恒的顾虑没有成为现实。但是，今后机器人能够从事的工作越来越多，这样的忧虑未必是杞人忧天。</p>\r\n<p>\r\n	在笑称机器人税是“无稽之谈”的时候，可能有一天，我们的税金也会由AI来计算。</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '你听说过对机器人征税这种科幻小说一样的事吗？《日本经济新闻》5月25日报道称，之所以讨论对机器人征税，是因为如果配备了人工智能(AI)等的高功能机器人在工厂和企业普及，会导', '普及,太快,我们,该,不该,对,机器人,征税,呢,', '122', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('4', '9', '解放人类的双手 机器人尝试自主学习抓取物体', '', '', '<p>\r\n	98%的情况下机器人抓取都是成功的。训练机器人如何在不掉落的情况下抓住各种物体，通常需要大量的练习。</p>\r\n<p>\r\n	不过，加州大学伯克利分校和西门子的研究人员联合设计并在即将发表的论文中描述了一款新型的机器人，它可以通过研究一个3D形状的数据库来学习如何抓牢新物体。该机器人连接了一个3D传感器和一个可以深度学习神经网络，研究人员就是通过这两者来为其提供物体的图像信息。这些信息包括物体形状、视觉外观以及如何抓住它们的物理知识。</p>\r\n<p>\r\n	因此，当一个新物体放置在机器人面前时，后者只需将物体与数据库中的一个类似对象做相应的匹配。在实际操作中，当机器人有超过50%的自信能够抓住一个新物体时，98%的情况下都会取得成功。不过要是机器人的自信不足50%，它就会先试探性地抓取这个物体，然后形成一个抓取策略。在这种情况下，机器人有99%成功的机会。所以克服机器人缺乏自信的方法就是做一个快速的小检查。</p>\r\n<p>\r\n	这种训练方法可以减少大量机器学习的时间，并且使机器人变得更加灵活。Jeff Mahler，一位研究这个项目的博士后向麻省理工科技技术评论表示“我们可以在一天内为深度神经网络生成足够的训练数据，从而免去了在一个真正的机器人上运行几个月物理实验的麻烦。”目前在工厂中投入使用的机器人对已知物体的抓取已经非常精确，但是其面对新物体时仍不能很好的适应。这种训练策略的效率和机器人握力的可靠性使该方法在未来的商业应用中能够很好地发挥作用。</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '98%的情况下机器人抓取都是成功的。训练机器人如何在不掉落的情况下抓住各种物体，通常需要大量的练习。 不过，加州大学伯克利分校和西门子的研究人员联合设计并在即将发表的论', '解放,人类,的,双手,机器人,尝试,自主,学习,98%,', '59', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('5', '9', '从肉体变机器，我们这代人或能见证人类进化加', '', '', '<p>\r\n	5月26日消息，据Futurism报道，美国哥伦比亚大学天体生物学教授卡里布·沙尔夫（Caleb Sharf）认为，我们很快就能亲眼见证人类进化加速的现象。他相信，新兴技术将改变当前人类的进化方式，人类进化的重点不再是柔软的有机物质部分，而是变成超越肉体束缚的机器，然后可进行编程或升级。</p>\r\n<p>\r\n	在接受采访时，沙尔夫表示：“我们可能亲眼见证新的生命起源事件。”由于人类与我们所创造的技术互动不断加强，进化的耐力竞赛已经进入冲刺阶段，而且冲刺的速度正不断加快。沙尔夫认为，互联网可能是人类物种进入“新状态”的开端。他说：“我们的部分集体智慧已经被上传到互联网上，并被放置在数据无处不在的云端。可是，这会怎样推动我们进化还不明显，但很可能促使我们产生蜂群思维状态，这种有机体类似白蚁或裸鼹鼠的群体生存状态。”</p>\r\n<p>\r\n	但沙尔夫也称，生物的机械化可能是生命迈向生物与机械状态进化漫长过程中的一小部分。他说：“将来有一天，我们可能会发现，地球上智慧未来需要的是生物体，而非机械计算。”</p>\r\n<p>\r\n	认为进化正走向终点是个错误的观点：进化并非是像路线图式的过程，而是适应环境的过程，无论环境如何。那些能在新环境中幸存下来的人就可以将基因传下去，无法适应环境的人基因也会随之消失。因此，我们不应该询问什么样的技术正让我们变得更强、更快，而是哪些技术赋予我们适应能力，以便适应任何环境需求生存下来。</p>\r\n<p>\r\n	首先是仿生学。虽然今天的仿生学研究目的旨在模仿人类的肢体功能，而我们也正接近实现这个目标。但当这个目标达成时，仿生学工程师们的目标可能是继续超越它。我们中的每个人都面临一种有趣的现象，那就是我们对人的定义。维持自然体征的人被视为正常人类，而集成技术的人往往被视为“超人”。如果四肢变成机器，且这些肢体可以定制，那么无论环境如何变化，我们都能适应。</p>\r\n<p>\r\n	其次是脑机接口(BCI)。这些技术可让大脑与电脑直接对话，它们打开了新的大门，人类思维可被植入到各种各样的机器人形态中。举例来说，如果环境变得非常热，那我们就可以设计出足够耐热的机器人身体，随后将其与人脑相结合，并利用脑机接口技术控制它。</p>\r\n<p>\r\n	除了打造更强大的身体，我们认为人类智力也拥有巨大潜能可挖。脑机接口不仅仅能够发挥单向作用，还可以让电脑向大脑传递信息。这为我们提供了另外一把适应环境的“金钥匙”，即上传的知识允许我们预测环境变化，然后改变我们自身的生存方式。虽然这看起来可能很古怪，但我们必须记住，消息的传递是Facebook和伊隆·马斯克（Elon Musk）脑机接口概念的宗旨，尽管它们只是扭曲了通信而非信息。不管最初我们如何利用这些技术，最终它们可能引领我们进入人类进化的新时代。（小小）</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '5月26日消息，据Futurism报道，美国哥伦比亚大学天体生物学教授卡里布沙尔夫（Caleb Sharf）认为，我们很快就能亲眼见证人类进化加速的现象。他相信，新兴技术将改变当前人类的进化方', '从,肉体,变,机器,我们,这,代人,或能,见证,5月,', '64', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('6', '9', '强大技术做支撑 谷歌输入法背后的机器智能', '', '', '<p>\r\n	很多人每天花费大量时间使用移动设备键盘：撰写电子邮件，发短信，参与社交媒体等。 然而，移动键盘仍然在处理速度方面处于劣势。 用户平均在移动设备上的打字速度比在物理键盘上慢35％。 为了改变这一点，最近谷歌团队为Gboard for Android提供了许多改进，致力于创建一个智能机制的 键盘，能够为用户以任何选择的语言提供建议和纠正错误，从而实现更快更高质量的输入。</p>\r\n<p>\r\n	事实上，移动键盘将触摸输入转换为文本的方式类似于语音识别系统将语音输入转换为文本的方式，雷锋网了解到，该团队将利用语音识别的经验来实现触摸输入。</p>\r\n<p>\r\n	团队首先创建了一个强大的空间模型，将原始触摸点的模糊序列映射到键盘上的按键，就像用声学模型将声音定位到语音单元的顺序一样。</p>\r\n<p>\r\n	第二，构建一个基于有限状态传感器（FST）的核心解码引擎，以确定给定输入触摸序列的最有可能的字符序列。 随着数学形式主义和语音应用的广泛成功， FST解码器将提供支持各种复杂键盘输入行为以及语言特性所需的灵活性。 在这篇文章中，将为您详细介绍这两个系统的发展。</p>\r\n<p>\r\n	神经空间模型</p>\r\n<p>\r\n	移动键盘输入的错误通常归结于“胖手指打字”（fat finger typing，或在滑动打字中定位到空间位置相似的词，如下图所示）以及认知和操作错误（表现为拼写错误，字符插入，删除或互换等）。 智能键盘需要能够解决这些错误，并且可以快速准确地预测正确的单词。 据雷锋网了解，该团队为Gboard构建了一个空间模型，用于在字符级别处理这些错误，将屏幕上的触摸点映射到实际按键。</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '很多人每天花费大量时间使用移动设备键盘：撰写电子邮件，发短信，参与社交媒体等。 然而，移动键盘仍然在处理速度方面处于劣势。 用户平均在移动设备上的打字速度比在物理键', '强大,技术,做,支撑,谷歌,输入法,背,后的,机器,', '200', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('7', '9', '程序员陷传销组织写代码求救：同事秒懂', '', '', '<p>\r\n	程序员这个职业总是给人一种“高深莫测”的感觉，而近日南京某软件公司的一名程序员就用实际行动告诉大家，掌握一门编程技术不仅可以吃饭，关键时刻还能救命。</p>\r\n<p>\r\n	据《南京日报》报道，南京某软件公司程序员小张（化名）在今年五一期间前往天津游玩时不慎落入传销组织圈套。而就在自己被控制的情况下，小张通过向同事发送编程代码而最终求救成功。</p>\r\n<p>\r\n	报道介绍称，传销组织为了避免用人单位怀疑而曾经允许小张和同事通过电话，就是利用这个机会，小张向一名经验丰富的同时传递信息称“项目里有一个测试类软件可能会影响生产系统，代码路径为：src\\ordercenter\\service的一个类testjs，其中还提及“控制类”字样。”</p>\r\n<p>\r\n	但实际上该代码早已上线，而且代码正确路径是ordercenter\\src\\xxx\\service，且测试类正常情况下不会影响生产系统。据此，小张的同事开始对信息内容产生怀疑，并展开“解码”。</p>\r\n<p>\r\n	经过一番梳理之后，同事们识别出首字母组合“SOS”为求救信号。于是便给小张回拨电话，又传递出另一串代码，其中含有“6”，并且着重提到“转换”这个字眼。小张明白，编程用的是二进制，数字6转换成二级制就是“110”，也就是说公司已经理解了他所传递信息的意思，并报了警。</p>\r\n<p>\r\n	与此同时，小张的同事还通过专业技术锁定了小张被困地点方圆5公里的范围，最终在与当地警方的合作下成功将小张解救。</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '程序员这个职业总是给人一种高深莫测的感觉，而近日南京某软件公司的一名程序员就用实际行动告诉大家，掌握一门编程技术不仅可以吃饭，关键时刻还能救命。 据《南京日报》报道', '程序员,陷,传销,组织,写,代码,求救,同事,秒懂,', '124', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('8', '9', 'AlphaGo 2.0没实质突破 AI革命任重道远', '', '', '<p>\r\n	科技讯5月25日消息，人机大战第二局落幕，柯洁在与AlphaGo的对弈中出现失误，最终以155手中盘投子认负。对此，猎豹移动CEO傅盛认为，AlphaGo 2.0未有实质突破，“从零开始”AI革命任重道远。傅盛认为Deepmind作为世界最顶尖的深度学习机构，引领着人类在深度学习上的探索。但一年的时间，AlphaGo 2.0本质上只优化了算法，提升了运算能力。这也提醒广大的AI从业者，不要仅仅寄希望于爆炸性的技术突破，落脚当下应该聚焦AI与应用相结合。</p>\r\n<p>\r\n	赛前猎豹移动CEO傅盛预测AlphaGo目前版本并未做脱离监督学习，如果能做到，新版本的技术突破其实不亚于第一版AlphaGo的意义。从零开始训练，意味着利用增强学习从零开始演化，纯粹靠对局最后的Reward（胜负）来学习。“用RL模型在初始没有监督的情况下想要收敛到接近最优解还是一个很开放的问题，哪怕对于红白机的一些游戏也不能完全做到。如果AlphaGo 2能够完成从零开始学习，很可能意味着对于增强学习算法本身有比较重大的突破，而这种突破可能不仅用于围棋，也有大量对其他应用的可能，所以意义会不亚于AlphaGo 1的横空出世。”</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	傅盛的观点在赛后得以认证，AlphaGo的核心作者之一Aja Huang(黄士杰)在首战后声明“此次AlphaGo是单机版，但仍有人类知识的训练。”</p>\r\n<p>\r\n	“AlphaGo 2.0并没有本质性突破，我们期待的无监督学习并没有到来。Deepmind作为世界最顶尖的深度学习机构，引领着人类在深度学习上的探索。但一年的时间，AlphaGo 2.0本质上只优化了算法，提升了运算能力。这也提醒广大的AI从业者，不要仅仅寄希望于爆炸性的技术突破，落脚当下应该聚焦AI与应用相结合”傅盛说。</p>\r\n<p>\r\n	而这一AI应用结合论“由来已久”，傅盛曾多次公开指出深度学习的机会在于和应用的集合而不仅仅是技术输出。他认为深度学习是算法革命，本质上降低了技术壁垒。由于基本算法模型的固定化，算法的驱动力已经大大地降低了，算法驱动变成了数据驱动。因此，深度学习的核心是数据驱动，虽然有模型调参的机构会有自己的优势，但更多的数据调参会很快拉平优势。</p>\r\n<p>\r\n	本质上，虽然AI是一个技术和工具 ，但是由于互联网的加速发展，今天一个独立的技术本身已经很难成为一个完全的行业。很难想像一家公司通过技术输出就能成功，未来深度学习是基础的技术运用，很多公司都会具备深度学习的研发能力。所有的公司都将是科技公司。科技是基础点，需要和应用结合。</p>\r\n<p>\r\n	而这一论调并非空穴来风，猎豹去年收购了法国一家新闻产品News Republic，把用户的点击行为变成数据的标注部分，神经网络会找到自动的相关新闻进行推送。猎豹还做了直播类应用Live.me，现在是美国最大的第三方直播平台，每天有几十万的美国用户开播，产生几百万、上千万张标准人脸，这个数据使得猎豹能够找到精准的数据。猎豹研发的人脸识别技术，在色情和儿童识别上有大量应用。在最近的 LFW 人脸识别的评测中，猎豹取得了前三名的成绩。</p>\r\n<p>\r\n	从深蓝到阿法狗，棋牌类游戏一直被用来检验人类与人工智能的差距，追溯原因，一方面棋类历史悠久，人类有足够的积累，围棋拥有的变化足够多，暴力搜索不能解决问题，必须要让AI有＂直觉＂；另一方面在博弈中属于完全信息博弈（Complete information），其实是最方便拿来验证AI能力。傅盛预测，未来AI所扮演的是助手的角色，而不是对抗的角色，将是人机共存的时代。</p>\r\n', '', '', '', '1608001866', '1608001866', 'true', '', '科技讯5月25日消息，人机大战第二局落幕，柯洁在与AlphaGo的对弈中出现失误，最终以155手中盘投子认负。对此，猎豹移动CEO傅盛认为，AlphaGo 2.0未有实质突破，从零开始AI革命任重道远', 'AlphaGo,2.0,没,实质,突破,革命,任重道远,科技', '199', '1608001866', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('9', '11', '产品名称五', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001897', '1608001897', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,五,案例分析,题,是,向,考生,提供,', '154', '1608001897', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('10', '11', '外教名称四', '/storage/images/20201215/1-1FQ4111I2M0.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001897', '1608001897', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,四,案例分析,题,是,向,考生,提供,', '78', '1608001897', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('11', '11', '外教名称三', '/storage/images/20201215/1-1FQ4111GL14.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001897', '1608001897', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,三,案例分析,题,是,向,考生,提供,', '137', '1608001897', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('12', '11', '外教名称一', '/storage/images/20201215/1-1FQ4111631N8.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001897', '1608001897', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,二,案例分析,题,是,向,考生,提供,', '141', '1608001897', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('13', '11', '外教名称二', '/storage/images/20201215/1-1FQ41116143K.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/uploads/allimg/170603/1-1F6031233553V.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001897', '1608001897', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,一,案例分析,题,是,向,考生,提供,', '166', '1608001897', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('14', '12', '产品名称十二', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001914', '1608001914', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,十二,案例分析,题,是,向,考生,提供,', '113', '1608001914', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('15', '12', '产品名称十一', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001914', '1608001914', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,十一,案例分析,题,是,向,考生,提供,', '66', '1608001914', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('16', '12', '产品名称十', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001914', '1608001914', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,十,案例分析,题,是,向,考生,提供,', '86', '1608001914', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('17', '12', '产品名称九', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001914', '1608001914', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,九,案例分析,题,是,向,考生,提供,', '78', '1608001914', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('18', '12', '产品名称八', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001914', '1608001914', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,八,案例分析,题,是,向,考生,提供,', '69', '1608001914', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('19', '12', '产品名称七', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001914', '1608001914', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,七,案例分析,题,是,向,考生,提供,', '50', '1608001914', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('20', '13', '产品名称六', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001925', '1608001925', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,六,案例分析,题,是,向,考生,提供,', '155', '1608001925', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('21', '13', '产品名称十六', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001925', '1608001925', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,十六,案例分析,题,是,向,考生,提供,', '82', '1608001925', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('22', '13', '产品名称十五', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001925', '1608001925', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,十五,案例分析,题,是,向,考生,提供,', '154', '1608001925', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('23', '13', '产品名称十四', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001925', '1608001925', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,十四,案例分析,题,是,向,考生,提供,', '172', '1608001925', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('24', '13', '产品名称十三', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/storage/images/20201215/13345S949-0.jpg\" src=\"/storage/images/20201215/13345S949-0.jpg\" style=\"border: 0px;\" /><br />\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001925', '1608001925', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '产品,名称,十三,案例分析,题,是,向,考生,提供,', '185', '1608001925', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('25', '5', '案例展示六', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/uploads/allimg/170603/1-1F603124I6128.jpg\" src=\"/storage/images/20201215/1344494621-0.jpg\" style=\"border: 0px;\" /></div>\r\n<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001945', '1608001945', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '案例,展示,六,案例分析,题,是,向,考生,提供,', '195', '1608001945', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('26', '5', '案例展示五', '/storage/images/20201215/1-1F6091334530-L.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/uploads/allimg/170603/1-1F603124I6128.jpg\" src=\"/storage/images/20201215/1344494621-0.jpg\" style=\"border: 0px;\" /></div>\r\n<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001945', '1608001945', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '案例,展示,五,案例分析,题,是,向,考生,提供,', '181', '1608001945', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('27', '5', '学院风采四', '/storage/images/20201215/1-1FQ4111934K4.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/uploads/allimg/170603/1-1F603124I6128.jpg\" src=\"/storage/images/20201215/1344494621-0.jpg\" style=\"border: 0px;\" /></div>\r\n<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001945', '1608001945', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '案例,展示,四,案例分析,题,是,向,考生,提供,', '199', '1608001945', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('28', '5', '学院风采三', '/storage/images/20201215/1-1FQ4111915D3.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/uploads/allimg/170603/1-1F603124I6128.jpg\" src=\"/storage/images/20201215/1344494621-0.jpg\" style=\"border: 0px;\" /></div>\r\n<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001945', '1608001945', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '案例,展示,三,案例分析,题,是,向,考生,提供,', '146', '1608001945', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('29', '5', '学院风采二', '/storage/images/20201215/1-1FQ4111UJ19.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/uploads/allimg/170603/1-1F603124I6128.jpg\" src=\"/storage/images/20201215/1344494621-0.jpg\" style=\"border: 0px;\" /></div>\r\n<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001945', '1608001945', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '案例,展示,二,案例分析,题,是,向,考生,提供,', '102', '1608001945', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('30', '5', '学院风采一', '/storage/images/20201215/1-1FQ4111T0Z6.jpg', '', '<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	<img alt=\"\" original=\"/uploads/allimg/170603/1-1F603124I6128.jpg\" src=\"/storage/images/20201215/1344494621-0.jpg\" style=\"border: 0px;\" /></div>\r\n<div style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见等。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	案例分析题属于综合性较强的题目类型，考察的是高层次的认知目标。它不仅能考察考生了解知识的程度，而且能考察考生理解、运用知识的能力，更重要的是它能考察考生综合、分析、评价方面的能力。因此，案例分析是区分度很高的题目类型。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	并且大型企业如四大会计师事务所、越来越重视舞台展示型的案例分析中涌现的优异学子。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	当然，案例分析也有它的不足之处，主要有三点：</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	1、 编制比较困难。案例分析题对背景资料有很高的要求，这给编制带来较大的困难。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	2、 在一份试卷中所占的篇幅或分数较大，但题量较小，因而影响到整卷对知识面的覆盖。</div>\r\n<div label-module=\"para\" style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(85, 85, 85); font-family: Simsun; font-size: 14px; line-height: 28px; text-align: center;\">\r\n	3、 评分上容易受阅卷者主观因素的干扰，所以评分信度不易高。</div>\r\n', '', '', '', '1608001945', '1608001945', 'true', '', '案例分析题是向考生提供一段背景资料，然后提出问题，在问题中要求考生阅读分析给定的资料，依据一定的理论知识，或做出决策，或作出评价，或提出具体的解决问题的方法或意见', '案例,展示,一,案例分析,题,是,向,考生,提供,', '166', '1608001945', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('31', '6', '毕业生就业季：专家帮你写求职简历', '', '', '<p>\r\n	◆1、不要与人事部门的人闲谈</p>\r\n<p>\r\n	　　人事部门可不是专门为你设立的，所以你不能毫无保留地把你的所有想法、问题或者是负担都跟他们说。要知道，和他们讨论工作上的问题基本上就相当于坐在公司大老板的对面。</p>\r\n<p>\r\n	　　◆2、不要谈论公司的负面言论</p>\r\n<p>\r\n	　　一旦你成为了一个公司的员工，那么你就要在任何公开场合都坚定不移地表示对公司的支持，更不能抱怨上司、老板，或者公司的政策。如果你觉得在某个方面有疑问或者有好的建议，那么直接找相关的决策者一对一地交谈。</p>\r\n<p>\r\n	　　◆3、不要站错阵营</p>\r\n<p>\r\n	　　如果你进入了一家有严重“阵营政治”的公司，那么就一定要擦亮眼睛，不要站错了队伍。在仔细观察之后，要高调地站在你所向往的比较高层的阵营，这样你才不会被别人当成攻击对象。</p>\r\n<p>\r\n	　　◆4、不要将消息发送给错误的人</p>\r\n<p>\r\n	　　为了避免将一个笑话网页发给上司，又或者把跟朋友抱怨工作的消息发给了人事部门等情况的发生，一定要将每一封邮件当做是可以在公司内部传阅的文件来写，也尽量避免和朋友在上班时间聊天。</p>\r\n<p>\r\n	　　◆5、不要爱出风头</p>\r\n<p>\r\n	　　在还没有获得相应的权力之前，虽然贸然出谋划策或许会帮助上司解决燃眉之急，但当危机过后，你的上司说不定就会觉得你的存在对他来说是种威胁。所以，除非你确定你的上司是那种不怕其他人才威胁的人，否则最好不要轻举妄动。</p>\r\n<p>\r\n	　　◆6、不要过分关注八卦消息</p>\r\n<p>\r\n	　　偶尔在私下参与讨论八卦消息或许无伤大雅，但如果你热衷于各种蜚短流长，还和与你有共同爱好的人混在一起，那就太危险了，你失去的不仅是同事的信任，可能还有自己的前途。</p>\r\n', '', '', '', '1608001957', '1608001957', 'true', '', '◆1、不要与人事部门的人闲谈 人事部门可不是专门为你设立的，所以你不能毫无保留地把你的所有想法、问题或者是负担都跟他们说。要知道，和他们讨论工作上的问题基本上就相当', '毕业,生就业,季,专家,帮你,写,求职,简历,◆,', '61', '1608001957', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('32', '6', 'HR为何“看不见”你的简历', '', '', '<p>\r\n	每发出一份求职简历，相信你的内心就多了一份期盼与渴望，但往往事与愿违，因为我们发出的简历，有时如同石沉大海，毫无音信，这会屡屡打击我们的求职信心，但究竟是什么原因会造成这种情况呢?</p>\r\n<p>\r\n	　　一、求职信不注明应聘岗位名称</p>\r\n<p>\r\n	　　有的简历不注明应聘岗位名称，对于每天接收成百上千封简历的招聘人员，可能这样的简历一下就被DEL了，谁让你不明确应聘目标，与人提供方便呢。</p>\r\n<p>\r\n	　　二、简历与招聘岗位要求明显不符</p>\r\n<p>\r\n	　　有的简历呈现出来的工作经验与应聘岗位差异太大，也是瞬间被DEL的对象。如企业招聘软件开发人员，求职简历里却呈现出做销售或客户开发的工作经历。我曾经收到过同时应聘三个岗位的简历，基本得出这样的结论：什么都能干的人，可能什么都干不好。因为这样的简历没有突出任何方面的技能或专长，自己对自身的发展不清楚，如无头的苍蝇乱撞，这样的人企业不会感兴趣的。当然，对于刚毕业的学生，求职心切，需要企业帮他们来定位，希望多获得一份机会，可以另当别论，但对于有工作经验的人，出现这种情况是不应该的。</p>\r\n<p>\r\n	　　三、简历内容简单，凸现不了招聘岗位需要的内容</p>\r\n<p>\r\n	　　有的简历只是程序化地列出接受教育、参加工作的时间段，对涉及到的实质内容则轻描淡写，让人无法了解其干过哪些工作，具备什么样的知识、经验、技能，这样的简历呈现出来的信息很有限，不会引起招聘人员的注意。</p>\r\n<p>\r\n	　　四、简历出现错误或时间顺序混乱情形</p>\r\n<p>\r\n	　　简历好比求职者的“脸面”，如果出现错字、时间顺序混乱或内容错误等情况，无疑会让人觉得连自己&quot;脸面&quot;都收拾不好的人，工作也好不到哪儿去。所以，简历填写完毕，作为求职者要反复查阅，核对无误。</p>\r\n<p>\r\n	　　五、简历呈现出“频繁跳槽”的经历</p>\r\n<p>\r\n	　　用人单位普遍不喜欢“频繁跳槽”者，往往因其频繁更换工作，而将其拒之门外，除非你本人所拥有的技能市场替代性很小。当然，求职者如隐瞒&quot;频繁跳槽&quot;经历，造成简历不真实，则更是弄巧成拙。</p>\r\n<p>\r\n	　　六、其它不可预见的因素</p>\r\n<p>\r\n	　　有时，招聘岗位非常急缺，可能先发求职简历的人就先被录用了，后面发简历的人既使知识、经验、技能更高一筹，也可能失去了机会，所以，时机也很重要;有时，招聘人员看到求职者在该企业的竞争对手企业工作过，为了了解更多的信息，可能优先安排面试。总之，不可预见的主观因素有时也是影响求职成否的重要因素。</p>\r\n', '', '', '', '1608001957', '1608001957', 'true', '', '每发出一份求职简历，相信你的内心就多了一份期盼与渴望，但往往事与愿违，因为我们发出的简历，有时如同石沉大海，毫无音信，这会屡屡打击我们的求职信心，但究竟是什么原因', '为何,“,看不见,”,你的,简历,每,发出,一份,', '158', '1608001957', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('33', '6', '面试时如何机智地回答“优缺点”的问题？', '', '', '<p>\r\n	Managershare：求职面试时，面试官经常会问一个问题：“请简单说一下你的优点和缺点。”对于这个问题，网络上流行着很多答题策略，有的职场新人直接套用，把“自己的优缺点”流利地背诵出来。在回答此类问题时切忌死记硬背，要根据职位特点有针对性地回答。</p>\r\n<p>\r\n	　　关于优点</p>\r\n<p>\r\n	　　面试官问应聘者这个问题有两个目的：第一，判断应聘者是否真实地阐述了自己的优点。第二，应聘者所阐述的优点是否是这个职位所需要的素质。</p>\r\n<p>\r\n	　　准备工作：</p>\r\n<p>\r\n	　　在面试之前就找出自己的3-5个优点;</p>\r\n<p>\r\n	　　为每个优点找出几个例子，最好来自学习、工作和生活等三个方面;</p>\r\n<p>\r\n	　　在这3-5个优点之中，精选出一两个和所申请职位最吻合的优点。</p>\r\n<p>\r\n	　　关于缺点</p>\r\n<p>\r\n	　　表述缺点时，既要结合本人实际，并选择无碍面试的那些，并力争把缺点转化为优点。</p>\r\n<p>\r\n	　　面试时谈及个人缺点，可以遵循以下几个原则：</p>\r\n<p>\r\n	　　坦然承认，博得认同</p>\r\n<p>\r\n	　　如果是自己的缺点，最好的办法还是坦然地承认它。为自己的缺点辩驳也无济于事，重要的是如何使别人在感情上认同你谈及自身缺点的态度。</p>\r\n<p>\r\n	　　消除误会，缩小隔阂</p>\r\n<p>\r\n	　　有的“缺点”并不是缺点，而是一般意义上的误会造成的，这时你应及时澄清，缩小与面试官的心理隔阂。</p>\r\n', '', '', '', '1608001957', '1608001957', 'true', '', 'Managershare：求职面试时，面试官经常会问一个问题：请简单说一下你的优点和缺点。对于这个问题，网络上流行着很多答题策略，有的职场新人直接套用，把自己的优缺点流利地背诵出', '面试,时,如何,机智,地,回答,“,优缺点,”,的,', '154', '1608001957', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('34', '6', '如何让自己在面试中“秒杀”面试官', '', '', '<p>\r\n	从求职者走进企业开始，整个面试就已经步入那关键的“一分钟”了。虽然个人能力对面试成败起着关键作用，不过求职者所呈现出的精神面貌在面试中也同样具备十足的杀伤力。如何让自己在面试中产生强大的气场以镇住面试官呢?</p>\r\n<p>\r\n	　　面试“秒杀”——用精神面貌镇住面试官</p>\r\n<p>\r\n	　　“台下十年功，台上一分钟”，仪表仪容方面的准备工作属于求职者在台下的“十年功”，求职者所呈现出的精神面貌在面试中也同样具备十足的杀伤力。</p>\r\n<p>\r\n	　　第一招：仪容仪表大检查</p>\r\n<p>\r\n	　　在出门的时候或许你已经做足了准备，不过经历了一路的颠簸，难免发型会乱，衣角会出现微小的褶皱，当然匆忙之中还可能会存在其他方面的疏忽，所以在见到面试官之前，可以去洗手间再做一次仪表仪容大检查，以确保万无一失。</p>\r\n<p>\r\n	　　第二招：让微笑释放出阳光般的正能量</p>\r\n<p>\r\n	　　面试并非只是求职者与面试官之间的“促膝长谈”，也许从求职者进入企业的那一刻，面试已经悄然开始，所以请拿出你最自然的微笑，与前台、面试官打招呼。</p>\r\n<p>\r\n	　　第三招：懂得与面试官“眉目传情”</p>\r\n<p>\r\n	　　所谓的“眉目传情”不是让你对面试官飞媚眼，而是你要懂得与面试官进行适当的眼神交流。面试中，既不能刻意逃避面试官的眼神，又不能以咄咄逼人之势紧盯着面试官;在交谈过程中，可以看着面试官的眼部，并不时地舒眉、微笑与其进行互动。</p>\r\n<p>\r\n	　　第四招：让肢体语言为你加分</p>\r\n<p>\r\n	　　虽然你的工作能力主要通过言语沟通在面试中展示出来，可是一些肢体动作却能影响面试官对你的评判，因为肢体语言可以成为面试官考察求职者个人修养的依据。因此，你需要注意：进门要示意，入座要平稳，坐下后不要两腿叉开，交谈时切勿抖腿，还有生活中的一些小动作，也要避免在面试中出现。</p>\r\n<p>\r\n	　　温馨提醒：其实，精神面貌并不是很玄很虚的东西，它主要是从穿着打扮、面部表情、肢体动作中展示出来，是留给别人的一种整体的感觉。面试中，之所以要强调微笑、眼神交流、肢体动作，就是要尽可能地把积极、自信、阳光的精神面貌展示给面试官，发挥其锦上添花的作用。</p>\r\n', '', '', '', '1608001957', '1608001957', 'true', '', '从求职者走进企业开始，整个面试就已经步入那关键的一分钟了。虽然个人能力对面试成败起着关键作用，不过求职者所呈现出的精神面貌在面试中也同样具备十足的杀伤力。如何让自', '如何,让,自己,在,面试,中,“,秒杀,”,官,从,', '73', '1608001957', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('35', '6', '面试时，老板们最想听到你问什么问题？', '', '', '<p>\r\n	当老板在面试中问道：“你有没有什么想要问我们的问题?”时，他们最希望听到面试者说些什么呢?如果你是一个马上就要毕业的大学生，很快就要参加面试，你该如何回答这样一个问题呢?</p>\r\n<p>\r\n	　　Ambra Benjamin对上述问题进行了解答，他是Facebook公司的工程师招聘专员，之前曾在LivingSocial，谷歌，以及Expedia三家公司工作过。</p>\r\n<p>\r\n	　　我 认为不管是现在，还是你整个职业生涯，在你面试的时候正确回答上述问题是非常重要的，当这家公司面试你的时候，其实你也一样在面试这家公司。在面试过程 中，如果面试官这么问你，那么一个经过慎重考虑后产生的问题会给你有不少加分。这不仅需要你对这家公司有所认识，同时也能帮助你进一步了解这家公司，或是 工作角色是否适合自己。在我自己的职业生涯中，关于这个问题我考虑过很多次。</p>\r\n<p>\r\n	　　我相信你已经为面试做了大量准备，而且对所属行业、相关岗位、以及应聘公司、甚至是要面试你的人都做了不少研究。如果面试过程中，面试官真的问你有没有问题问他们，那么你心里需要有两到三个预先准备的问题。在此我会给出一些建议：</p>\r\n<p>\r\n	　　· “在您看来，怎么样才能算胜任这个岗位呢?” 或者, “如何评估员工在这个岗位上是否胜任呢?”</p>\r\n<p>\r\n	　　· “您为什么会加入这家公司，是什么原因让你一直在此工作?”</p>\r\n<p>\r\n	　　· “在这里工作您最喜欢的，还有最不喜欢的是什么?”</p>\r\n<p>\r\n	　　· “您认为这个岗位最大的挑战是什么?”</p>\r\n<p>\r\n	　　· “明年这家公司需要完成的三个最主要的工作目标是什么?”</p>\r\n<p>\r\n	　　你要向面试官问的问题，要显示出你认真考虑过这个岗位或这家公司。你可以询问这个岗位的工作职责，公司融资状况，或是岗位、公司、以及企业文化的优势，以及企业的发展方向等等。</p>\r\n<p>\r\n	　　这些都是很好的问题，因为可以让你用一种非官方的、或是很自然的方式，向面试官展示你已经预先对这家公司有所了解了。</p>\r\n<p>\r\n	　　· 你可以问一些之前面试官已经提到过的问题，这表示你注意聆听他说话。</p>\r\n<p>\r\n	　　· 你可以问问面试官他/她在这家公司待了多久，最喜欢公司什么地方。这其实是在恭维面试官，而且最重要的是，你可能因此了解一些他人所不知道的企业文化。</p>\r\n<p>\r\n	　　· 你可以问面试官下一步会如何操作。问他是否能够得到公司的回复，谁会联系你，是通过电子邮件还是电话通知。你也可以问他下一轮面试官是谁，你有权知道这些问题的细节，因为有时面试官自己可能会忘记告诉你这些信息。</p>\r\n<p>\r\n	　　· 最后，不要询问那些在求职信息上已经发布了的问题。</p>\r\n', '', '', '', '1608001957', '1608001957', 'true', '', '当老板在面试中问道：你有没有什么想要问我们的问题?时，他们最希望听到面试者说些什么呢?如果你是一个马上就要毕业的大学生，很快就要参加面试，你该如何回答这样一个问题呢', '面试,时,老板,们最,想,听到,你问,什么,问题,', '62', '1608001957', '0', '0', '0', '100');
INSERT INTO `rrz_articles` VALUES ('36', '6', '面试千万别犯的7个愚蠢错误', '', '', '<p>\r\n	在我这四年短暂的职业生涯中，从高管到经理，从15人的小公司到超过10000人的跨国企业，我曾参与过不同组织、不同职位的很多场面试。</p>\r\n<p>\r\n	　　我有幸见到各类HR经理，我以不同程度的成功通过了这些面试。不管结果怎样，我总是试着从HR那里得到一些或好或坏的反馈。这些反馈不仅是我个人观察总结出的，还包括HR经理的建议和一些小常识。</p>\r\n<p>\r\n	　　1)差劲的握手</p>\r\n<p>\r\n	　　在握手时不要表现得特别不情愿或是过于热情。一次轻轻地握手可能会显得你很羞怯，但过于用力也会适得其反吓到对方。</p>\r\n<p>\r\n	　　一个礼貌合理的握手大概是你的手臂向外展开、大拇指竖起。</p>\r\n<p>\r\n	　　2)绕圈子说话</p>\r\n<p>\r\n	　　在面试中，我们都很难说出口“我不知道”，相比起顾左右而言他，如果坦然承认你不知道，或许面试官会更尊重你。如果你绕着圈子说话，面试官很快就会否定你。</p>\r\n<p>\r\n	　　唯一需要担心的是你不要太频繁展露你的无知。</p>\r\n<p>\r\n	　　3)自我炫耀伪造简历</p>\r\n<p>\r\n	　　在激烈的竞争中，你可能很想在各个小细节都稍作润饰。你可能会想，“他不会看这些小的细节的”，但是现实却不是这样的。面试官经验丰富，他们总能抓到简历中不确定的点，如果面试官一旦发现你的简历中有一个不确切的事实描述，他很可能倾向于认为你简历中的其他地方也有造假。一旦他认为你不可信，你就从此与这份工作无缘了。</p>\r\n<p>\r\n	　　4)弱点?</p>\r\n<p>\r\n	　　面试都会提一些标准化的问题，比如你的弱点是什么?</p>\r\n<p>\r\n	　　每个人都不希望被问到这个问题。如果没有准备，有的人可能就大脑一片空白，而另外一些老套的回答可能是“我是完美主义者”或者“我工作太努力”了之类，在面试中发生这两种情况都不太好。</p>\r\n<p>\r\n	　　对于任何人来说，这都是一个有难度的问题，你需要提前做点准备。专家建议你说一些与这份工作无关痛痒的小缺点。畅销书作家Bernard Marr在他的LinkedIn文章中写到：“很重要的是你要表现你有自我认识，你很了解自己，但是你所说的缺点应该是对胜任求职工作本身是没有影响的。”</p>\r\n<p>\r\n	　　5)到得太早到或是迟到</p>\r\n<p>\r\n	　　终于等到了面试通知的电话，你为这重要的一天做了充分准备。但是，由于某些原因你还是迟到了。</p>\r\n<p>\r\n	　　有一句俗语是，”点滴预防胜过灵丹妙药”，为了避免面试时迟到，你最好早点从家出来，然后做好应对各种问题的准备。</p>\r\n<p>\r\n	　　来得太早也没必要，除了需要在人来人往的前台沙发等上很久，你还可能还会给面试组织者造成一种心理压力。因为很多公司的招聘标准化流程中，为了提升候选人体验，明确规定了面试等待时长，如果超出，就是面试组织者的工作失职</p>\r\n<p>\r\n	　　6)这个我想要，那个我也想要</p>\r\n<p>\r\n	　　面试官也许会问你对这份工作有什么需要。你要谨慎回答这个问题。很多情况下我们可能会回答得过于详细，细数公司福利和薪资期望等等。在面试过程中，不要过早提出对这位的要求和条件，最好的协商时机是等到你被录取了之后。</p>\r\n<p>\r\n	　　7)这问题也太愚蠢了</p>\r\n<p>\r\n	　　可能有时你觉得面试官的问题也太蠢了，配不上你的聪明才智。如果让面试官发现你这么想，那就跟自毁前途差不多。这是我在我自己的经历中学到的深刻的一课。如果你被问到类似的问题，注意你的回答最好不要太刻薄。</p>\r\n', '', '', '', '1608001957', '1608001957', 'true', '', '在我这四年短暂的职业生涯中，从高管到经理，从15人的小公司到超过10000人的跨国企业，我曾参与过不同组织、不同职位的很多场面试。 我有幸见到各类HR经理，我以不同程度的成功通', '面试,千万,别犯,的,7个,愚蠢,错误,在,我这,', '106', '1608001957', '0', '0', '0', '100');

-- ----------------------------
-- Table structure for `rrz_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channelfield`;
CREATE TABLE `rrz_channelfield` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `channel_type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` text NOT NULL COMMENT '字段定义',
  `maxlength` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` longtext COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `ifrequire` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否必填',
  `sort` int(5) unsigned NOT NULL DEFAULT '100' COMMENT '排序',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='自定义字段表';


-- ----------------------------
-- Table structure for `rrz_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_channeltype`;
CREATE TABLE `rrz_channeltype` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '名称',
  `type` enum('articles','goods') NOT NULL DEFAULT 'articles' COMMENT '类型（articles：文章，goods：产品）',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COMMENT='文章（产品）类型';


-- ----------------------------
-- Table structure for `rrz_config`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_config`;
CREATE TABLE `rrz_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text COMMENT '配置内容',
  `type` varchar(64) DEFAULT '' COMMENT '类型',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否已删除（0：否，1：是）',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统配置表';

-- -----------------------------
-- Records of `rrz_config`
-- -----------------------------
INSERT INTO `rrz_config` VALUES ('1', 'status', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('2', 'name', '某某教育机构网站', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('3', 'logo', '/storage/images/20201215/logo.jpg', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('4', 'wap_logo', '/storage/images/20201215/logo_m.png', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('5', 'favicon', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('6', 'copyright', 'Copyright © 2012-2050 某某教育机构有限公司 版权所有', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('7', 'recordnum', '琼ICP备xxxxxxxx号', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('8', 'title', '外语教育精品课程类网站模板(带手机端)', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('9', 'keywords', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('10', 'description', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('11', 'is_authorization', '1', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('12', 'authortoken_code', '', 'website', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('13', 'popup_upgrade', '1', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('14', 'wap_domain', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('15', 'is_https', '0', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('16', 'logo', '/static/images/logo.png', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('17', 'sqldatapath', '', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('18', 'expiretime', '3600', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('19', 'name', '某某教育机构有限公司', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('20', 'telephone', '400-123-4567', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('21', 'fax', '020-99999999', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('22', 'qq', '88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('23', 'email', 'admin@youweb.com', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('24', 'addr', '广东省广州市番禺经济开发区', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('25', 'coord', '22.94703,113.38555', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('26', 'thirdcode_pc', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('27', 'thirdcode_wap', '', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('28', 'inlet', '2', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('29', 'auto', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('30', 'filter_isurl', '1', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('31', 'type', 'xml', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('32', 'index_changefreq', 'always', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('33', 'list_changefreq', 'hourly', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('34', 'view_changefreq', 'daily', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('35', 'index_priority', '1.0', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('36', 'list_priority', '0.8', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('37', 'view_priority', '0.5', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('38', 'articles_num', '100', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('39', 'zzbaidutoken', '', 'sitemap', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('40', 'app_map', 'admin', 'admin', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('41', 'status', '1', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('42', 'replace', '国家级|国际级|世界级|宇宙级|千万级|百万级|星级|甲级|超甲级|完美|唯一|一流|精确|顶级|顶尖|尖端|最|国际级产品|填补国内空白|带头|首个|首次|首发|首款|首家|首选|正品|金牌|名牌|优秀|顶级|独家|唯独|独有|独创|独据|开发者|缔造者|创始|发明者|领先|领头|领导|领跑|领袖|领先|引领|创领|领航|权威|先进|耀领|缔造者|极品|极佳|顶级|尖端|顶尖|终极|绝佳|绝对|绝版|终极|极致|极具|王牌|冠军|第一|极致|永久|王牌|掌门人|领袖|独一无二|绝无仅有|前无古人|史无前例|万能|绝对|绝顶|大牌|精确|超赚|巨星|至尊|巅峰|之王|巨星|王者|资深|至尊|著名|奢侈|百分之百|国家级产品|国家免检|国家领导人|填补国内空白|史无前例|前无古人|永久|永远|万能|祖传|特效|无敌|纯天然|超赚|国际品质|专家推荐|超强|全面|全网|全球|随时结束|仅此一次|空前绝后|随时涨价|马上降价|最后一波|包治百病|药到病除|特供|专供|专家推荐|热销|畅销|全效|标杆|精确|优秀|仅此|遥遥|高档|真皮|超赚|精准|指定|精品|特供|专供|国旗|国徽|党旗|驰名|秒杀|一步到位|', 'webfilter', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('43', 'connector_title', '_', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('44', 'list_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('45', 'view_title', '1', 'seo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('46', 'mobile', '138-0000-0000', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('47', 'wx', 'wx88888888', 'webinfo', '', 'cn', '0');
INSERT INTO `rrz_config` VALUES ('48', 'qrcode', '/storage/images/20201215/qr.png', 'webinfo', '', 'cn', '0');

-- ----------------------------
-- Table structure for `rrz_form_data`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_form_data`;
CREATE TABLE `rrz_form_data` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `form_id` int(10) unsigned DEFAULT '0' COMMENT '表单ID',
  `form_name` varchar(255) DEFAULT '' COMMENT '表单名称',
  `content` longtext COMMENT '提交内容',
  `ip` varchar(255) DEFAULT '' COMMENT '提交人IP',
  `add_time` int(10) unsigned DEFAULT NULL COMMENT '提交时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_form_id` (`form_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_forms`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_forms`;
CREATE TABLE `rrz_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `config` longtext COMMENT '表单配置',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '创建时间',
  `is_del` tinyint(1) unsigned DEFAULT '0' COMMENT '删除(0=否，1=是)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_is_del` (`is_del`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- -----------------------------
-- Records of `rrz_forms`
-- -----------------------------
INSERT INTO `rrz_forms` VALUES ('1', '在线报名', 'a:4:{i:0;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:6:\"姓名\";s:8:\"required\";s:1:\"1\";}i:1;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"手机号码\";s:8:\"required\";s:1:\"1\";}i:2;a:3:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:12:\"邮箱地址\";s:8:\"required\";s:1:\"0\";}i:3;a:3:{s:4:\"type\";s:8:\"textarea\";s:4:\"name\";s:12:\"留言内容\";s:8:\"required\";s:1:\"1\";}}', '1608016832', '0');

-- ----------------------------
-- Table structure for `rrz_goods`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods`;
CREATE TABLE `rrz_goods` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `brief` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '商品简介',
  `cat_id` mediumint(8) unsigned DEFAULT NULL COMMENT '产品分类id',
  `def_img` varchar(500) DEFAULT '' COMMENT '产品默认图片路径',
  `imgs` longtext COMMENT '产品图片集合',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `del_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品划线价格',
  `store` int(8) unsigned DEFAULT '0' COMMENT '产品库存',
  `is_presell` enum('true','false') DEFAULT 'false' COMMENT '是否预售（是否定金付款）',
  `presell_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '预售价格（定金）',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '产品规格',
  `content` longtext COMMENT '产品详情',
  `wap_content` longtext COMMENT '手机端详情',
  `sales` int(11) unsigned DEFAULT '0' COMMENT '产品销量',
  `addtime` int(11) unsigned DEFAULT '0' COMMENT '创建时间',
  `is_head` tinyint(1) unsigned DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) unsigned DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_recom` tinyint(1) unsigned DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_news` tinyint(1) unsigned DEFAULT '0' COMMENT '新品（0=否，1=是）',
  `view_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` smallint(6) unsigned DEFAULT '100' COMMENT '排序',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `ifpub` enum('true','false') NOT NULL DEFAULT 'true' COMMENT '上架',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cat_id` (`cat_id`) USING BTREE,
  KEY `idx_is_head` (`is_head`) USING BTREE,
  KEY `idx_is_special` (`is_special`) USING BTREE,
  KEY `idx_is_recom` (`is_recom`) USING BTREE,
  KEY `idx_is_news` (`is_news`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品管理';


-- ----------------------------
-- Table structure for `rrz_goods_attr`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attr`;
CREATE TABLE `rrz_goods_attr` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品属性id自增',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `attr_value` text COMMENT '属性值',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `goods_id` (`goods_id`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品扩展属性关联表';


-- ----------------------------
-- Table structure for `rrz_goods_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_attribute`;
CREATE TABLE `rrz_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `name` varchar(60) NOT NULL DEFAULT '' COMMENT '属性名称',
  `is_filter` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否应用于条件筛选',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型（0 单行文本框 1下拉式列表 2多行文本框）',
  `values` text COMMENT '属性值集合',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '属性排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品扩展属性';


-- ----------------------------
-- Table structure for `rrz_goods_cat`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_cat`;
CREATE TABLE `rrz_goods_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '所属模型id',
  `name` varchar(255) DEFAULT '' COMMENT '分类名称',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `img` varchar(255) DEFAULT '' COMMENT '分类图片',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '节点深度',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '分类排序',
  `path` varchar(255) DEFAULT '' COMMENT '节点路径',
  `tmpl_path` varchar(100) DEFAULT '' COMMENT '模板',
  `tmpl_view` varchar(100) DEFAULT '' COMMENT '文档模板',
  `seo_title` varchar(255) DEFAULT '' COMMENT 'SEO标题',
  `seo_description` mediumtext COMMENT '分类描述',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT '搜索关键词',
  `attrs` longtext COMMENT '参数列表',
  `uptime` int(10) unsigned DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE,
  KEY `idx_channel_id` (`channel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品分类';


-- ----------------------------
-- Table structure for `rrz_goods_skus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_skus`;
CREATE TABLE `rrz_goods_skus` (
  `sku_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品规格id',
  `goods_id` bigint(18) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '产品价格',
  `sku_name` varchar(500) DEFAULT '' COMMENT '规格名称',
  `sku_desc` longtext COMMENT '规格明细',
  PRIMARY KEY (`sku_id`) USING BTREE,
  KEY `idx_goods_id` (`goods_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='产品规格详情';


-- ----------------------------
-- Table structure for `rrz_goods_spec_values`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_spec_values`;
CREATE TABLE `rrz_goods_spec_values` (
  `spec_value_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '规格值ID',
  `spec_id` bigint(15) unsigned NOT NULL DEFAULT '0' COMMENT '规格ID',
  `spec_value` varchar(100) NOT NULL DEFAULT '' COMMENT '规格值',
  PRIMARY KEY (`spec_value_id`) USING BTREE,
  KEY `idx_spec_id` (`spec_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格值';


-- ----------------------------
-- Table structure for `rrz_goods_specification`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_goods_specification`;
CREATE TABLE `rrz_goods_specification` (
  `spec_id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `spec_name` varchar(50) DEFAULT NULL COMMENT '规格名',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序顺序',
  PRIMARY KEY (`spec_id`) USING BTREE,
  KEY `idx_sort` (`sort`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='规格表';


-- ----------------------------
-- Table structure for `rrz_search_keywords`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_search_keywords`;
CREATE TABLE `rrz_search_keywords` (
  `id` bigint(15) unsigned NOT NULL AUTO_INCREMENT COMMENT '表ID',
  `keywords` text COMMENT '关键词',
  `type` varchar(50) DEFAULT 'article' COMMENT '搜索类型',
  `ip` varchar(100) DEFAULT NULL COMMENT '搜索客户端的ip地址',
  `hot` int(10) unsigned DEFAULT '0' COMMENT '关键词搜索量',
  `add_time` int(11) unsigned DEFAULT NULL COMMENT '搜索时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_hot` (`hot`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;


-- ----------------------------
-- Table structure for `rrz_site_links`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_links`;
CREATE TABLE `rrz_site_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT '' COMMENT '网站标题',
  `url` varchar(255) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) unsigned DEFAULT '0' COMMENT '是否新窗口打开',
  `email` varchar(50) DEFAULT '',
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='友情链接表';

-- -----------------------------
-- Records of `rrz_site_links`
-- -----------------------------
INSERT INTO `rrz_site_links` VALUES ('1', '企业建站系统', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481203', '1590481203');
INSERT INTO `rrz_site_links` VALUES ('2', '淘进微信', 'http://taobao.kbstore.cn/', '', '100', '1', '', '', '1', 'cn', '1590481246', '1591322028');
INSERT INTO `rrz_site_links` VALUES ('3', '人人站CMS', 'http://www.rrzcms.com/', '', '100', '1', '', '', '1', 'cn', '1590481266', '1590481266');
INSERT INTO `rrz_site_links` VALUES ('4', '百度', 'http://www.baidu.com', '', '100', '1', '', '', '1', 'cn', '1590822377', '1590822377');
INSERT INTO `rrz_site_links` VALUES ('5', '哔哩哔哩', 'https://www.bilibili.com/', '', '100', '1', '', '', '1', 'cn', '1601185955', '1601185955');
INSERT INTO `rrz_site_links` VALUES ('6', '知乎', 'http://zhihu.com/', '', '100', '1', '', '', '1', 'cn', '1601186019', '1601186019');
INSERT INTO `rrz_site_links` VALUES ('7', '微博', 'http://weibo.com/', '', '100', '1', '', '', '1', 'cn', '1601186069', '1601186069');
INSERT INTO `rrz_site_links` VALUES ('9', '淘宝', 'https://www.taobao.com/', '', '100', '1', '', '', '1', 'cn', '1601186210', '1601186210');

-- ----------------------------
-- Table structure for `rrz_site_menus`
-- -----------------------------
DROP TABLE IF EXISTS `rrz_site_menus`;
CREATE TABLE `rrz_site_menus` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `dir_name` varchar(255) DEFAULT '' COMMENT '目录英文名',
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '上级菜单',
  `id_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'id路径',
  `depth` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '菜单深度',
  `url` varchar(200) DEFAULT '' COMMENT '自定义链接',
  `sort` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `path` varchar(100) NOT NULL DEFAULT '' COMMENT '上下级路径',
  `target_blank` enum('true','false') NOT NULL DEFAULT 'false' COMMENT '是否新开窗口',
  `config` longtext COMMENT '配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='导航菜单表';

-- -----------------------------
-- Records of `rrz_site_menus`
-- -----------------------------
INSERT INTO `rrz_site_menus` VALUES ('1', '网站首页', 'wangzhanshouye', '0', '1', '1', '/', '1', '1001', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('2', '关于我们', 'guanyuwomen', '0', '2', '1', '/node/1.html', '2', '1002', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('3', '新闻动态', 'xinwendongtai', '0', '3', '1', '/node/2.html', '3', '1003', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('4', '招生简章', 'zhaoshengjianzhang', '0', '4', '1', '/node/3.html', '4', '1004', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('5', '外教团队', 'waijiaotuandui', '0', '5', '1', '/node/4.html', '5', '1005', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('6', '学员风采', 'xueyuanfengcai', '0', '6', '1', '/node/5.html', '6', '1006', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('7', '就业指南', 'jiuyezhinan', '0', '7', '1', '/node/6.html', '7', '1007', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('8', '在线报名', 'zaixianbaoming', '0', '8', '1', '/node/7.html', '8', '1008', 'false', '');
INSERT INTO `rrz_site_menus` VALUES ('9', '联系我们', 'lianxiwomen', '0', '9', '1', '/node/8.html', '9', '1009', 'false', '');
