<?php
/**
 * 人人站CMS
 * ============================================================================
 * 版权所有 2015-2030 山东康程信息科技有限公司，并保留所有权利。
 * 网站地址: http://www.rrzcms.com
 * ----------------------------------------------------------------------------
 * 如果商业用途务必到官方购买正版授权, 以免引起不必要的法律纠纷.
 * ============================================================================
 */

namespace think\repair\db\connector;

use think\db\connector\Mysql as base;
use \think\db\BaseQuery;

class Mysql extends base
{
    /**
     * 分析缓存Key
     * @access protected
     * @param BaseQuery $query 查询对象
     * @param string $method 查询方法
     * @return string
     */
    protected function getCacheKey(BaseQuery $query, string $method = ''): string {
        if (!empty($query->getOptions('key')) && empty($method)) {
            $field = $query->getOptions('field');
            $field = is_array($field) ? implode(',', $field) : $field;
            $key = 'think_' . $this->getConfig('database') . '.' . $query->getTable() . '|' . $query->getOptions('key') . '|' . $field;
        } else {
            $key = $query->getQueryGuid();
        }
        return $key;
    }
}