---
author: "Robert Pearce"
authorTwitter: "@RobertWPearce"
desc: "Some thoughts on freelancing in the software development business."
kewords: "freelancing, digital nomad, toptal"
title: "Freelancing"
---

Sandy beaches; downhill skiing; coffee shop Hugh Grant-esque romance. When
people imagine themselves leaving their corporate jobs and becoming their own
boss, moving from project to project as a knife through butter, they envision
themselves living the good life and doing so _on their terms_. This is
absolutely possible to achieve, but as with anything, freelancing isn't all
rainbows and unicorns! But we want rainbows; we want unicorns. How can we get to
this point? Let's start at the bottom.

## Freelancing is Tough

As soon as you leave your large organization, there is a very strange sensation
that is exhilarating and terrifying all at once: _I am now responsible for
everything, and if I fail at any one thing in this chain, I fail._ What is
encompassed by "everything?" Let's take a look at what we'll talk about for the
rest of the post: software freelancing.

* Marketing
* Sales
* Strategy
* Research
* Development
  * Frontend: UI, UX, prototyping, information architecture, functionality,
    QA/testing
  * Backend: API, server architecture, data stores, scaling, QA/testing
  * Or both
* Invoicing

Here's some very basic logic based off of these responsibilities:

* If you cannot market yourself and your skills, you cannot get in the door.
* If you cannot sell, you cannot close a deal.
* If you cannot build the product in a timely fashion and deliver what you
  promised, you'll be in trouble.
* If you cannot collect money from clients, your business does not get paid.
* If any of these steps fail, the path to getting paid is closed.

What's more, how do you know if the client you are selling is a client you
actually want to work with? How can both parties vet one another?

## Building Relationships

One way to get around many of the issues you run in to while freelancing that
are related more to the business side than what you actually create is to foster
relationships with businesses locally (or remotely, if you can manage that
across the Internet). Attending meetups, lectures, happy hours, conferences,
hackathons, open houses and the like are great ways to meet folks in your
community and get to know them and their businesses. The more knowledgeable all
parties are with one another, the more they can suss out whether or not they
want to work with each other. Once someone has a good experience with you, it is
more likely that they will come to you again to solve their problems.

If you can build enough relationships, you may not need to go outside of your
local community for work. But what if your city doesn't have enough work for you
or you travel regularly? What if you want to expand your freelance reach to a
national level?

## Finding Non-Local Work

Without an agency or consultancy brand name behind you, finding work from
organizations outside of your network could be difficult. There are a number of
services which help you, such as [Elance](https://www.elance.com/) and
[Gun.io](https://gun.io/), but the one that really caught my eye was
[toptal](https://www.toptal.com).

What really stuck out to me was the concept of their only accepting what they
call the ["top 3%"](http://www.toptal.com/top-3-percent) of people that apply.
Their rigid screening process ensures that only quality developers are admitted
to their community. To me, this guarantees prestige and sets the bar very high.
This also means that, as a marketplace, toptal would need to ensure that clients
are legit and responsible, as well. In sum, toptal

* connects you (freelancer) with vetted, great employers
* gives businesses an elite group of A+ players from which to choose for their business' needs
* handles the money

and much more.

I want to work with the best clients, and I want clients to receive the best
work possible. I have just started the process for joining [the toptal Web
developers network](http://www.toptal.com/web) to pick up additional work, look
forward to the challenges of the screening process and hope to make it through!

## Do What Works For You

If you enjoy working in your local area, then get to work building relationships
and a pipeline of backed up work as far as the eye can see with people in your
area! But if you plan on going national/international, consider giving
[toptal](https://www.toptal.com) a shot and show them what you're made of.
