---
author: "Robert Pearce"
authorTwitter: "@RobertWPearce"
desc: "On being the hinge between someone with a question and someone else with a solution."
keywords: "leadership, leadership advice, teamwork, delegate, hinge"
title: "Delegate; Don't Dump"
updated: "2023-02-04T18:00:00Z"
---

A fellow employee, Margaret, contacts you and asks, &quot;Do you know anything
about [problem] and how I might be able to solve it?&quot; You respond, &quot;Oh,
yeah, Jane is handling that now.&quot; You are a busy person being crushed under
the weight of your duties, and you have just helped someone. Having now pushed
something off of your plate, it is time to address the next thing!

But then Margaret comes back to you and says that Jane isn't sure why you said
she could solve this problem. Jane is confused, you are confused and Margaret is
left floating in ambiguity without any direction nor answer and must go ask
someone else and begin this cycle again. If this conversation happens via email,
expect it to take multiple days and span multiple threads.

Why did this happen?

## You are the hinge

When someone reaches out to you and asks a question, and you believe someone
else has the answer, then you are now effectively a hinge between these 2 people.

You are what connects that person's problem with his/her solution. When you do
not _act_ as a hinge does and connect the two different parties, then both
remain separate (read: you will now spend significantly more time than you would
have originally spent figuring out a solution).

## Delegate Like a Leader

Delegating responsibility and empowering others are pivotal skills for
leadership of any sort. How does it feel when you ask someone for their
assistance, and they are incredibly helpful in getting you where you need to go?
It feels pretty darn good. Why? Because you have a guide that either knows the
way or knows someone who does. You know that you are in safe hands and that your
problem will be solved. _You have a clear path to a solution and are thus
empowered._

## What To Do Next Time

If someone asks you a question or comes to you with a problem, it is because
they believe you possess the solution. Instead of dumping them on to someone
else, it might be in everyone's best interest to set up an introductory
email/Google Hangout/Skype call to act as the hinge you are and hand one person
off to another for safe-keeping. This way, you leave nothing to question, and if
there are any issues, your group will immediately be on the same page and be
able to find a solution much more quickly.
