---
author: "Robert Pearce"
authorTwitter: "@RobertWPearce"
desc: "Pay less attention to your device and more to those around you."
keywords: "mobile devices, etiquette, advice, staring at phones"
title: "Mobile Device Etiquette"
updated: "2023-02-04T18:00:00Z"
---

A friend and colleague of mine, [Jason
Vanderslice](https://www.linkedin.com/in/javanderslice), and I recently
discussed the state of mobile devices with regard to their place in various
settings and within our interpersonal relationships. While I would not presume
to speak for Jason on most subjects, we agree that mobile device etiquette is
something that needs to be taught, spread to others and repeated.

With the evolution of digital, mobile devices came a million new ways to
distract ourselves. Every new Twitter mention, Facebook tag, Instagram #hashtag,
email, text and push notification is a jarring intrusion in to whatever we are
doing that yearns for our attention and ultimate dismissal. Ignoring the vanity
associated with thinking that we are important enough that our responses cannot
wait (I'm not talking about you, doctors; you have a free pass with your 13
pagers), there is another aspect with which so many of us are tied to our
phones: we want to clear messages and push notifications out of our lives as
quickly as possible in order to avoid the stress of having so many of them build
up. Everyone loathes the feeling of a mountain of emails crushing down on them.
Everyone feels guilty about not returning that email their boss sent them at
11pm about XYZ big important project of the quarter. But something is
lost—ignored, even: the consideration of those around us. Instead of focusing on
the anxiety these acts alone cause us, I would like you to consider the effects
your actions have on those around you.

## Being Present

I want to tell you about a man who changed my life by setting an example.
[Paul Singh](https://twitter.com/paulsingh), former partner at [500
Startups](http://500.co) and founder of [Disruption
Corporation](http://www.disruption.vc), is a very well-known investor in the
tech world and [single-handedly transforms
cities](http://www.crystalcity.org/innovative/crystal-tech-fund) economically.
You can safely bet that his phone is constantly buzzing with the latest killer
app ideas, city construction issues and other problems that require his
attention.

I was fortunate enough to get to spend a day with Paul, [Marty
Bauer](https://twitter.com/bauermarty) and heaps of other great folks at [The
Iron Yard](http://theironyard.com) in Greenville, SC, last year, where Paul came
to speak about what he was doing in Crystal City, Arlington, VA. We picked him
up at the GSP airport and, after a night's rest, three of us met Paul at [Coffee
Underground](http://www.coffeeunderground.info) for breakfast and coffee. While
we sat there discussing life, the universe and everything, I was surprised how
attentive and conversational Paul was. He listened to every word someone had to
say, waited for them to finish, thought for a moment and then provided a
relevant response and/or follow-up question.

So what's the big deal? Most people are taught from childhood how to have a
conversation. Let's hear more.

During his presentation, an attendee was most disrespectful, hijacking the
presentation to seemingly blame Paul for the Industrial Revolution and
subsequent child labor issues. As one would imagine, this had nothing to do with
his presentation, but instead of putting the attendee down, Paul listened and
responded to the attendee with respect while he received none. When it was clear
there was to be no resolution to the original question, he closed the subject
elegantly and continued his talk without skipping a beat.

What do these two personal acedotes have to do with mobile device etiquette?

_Everything._

You see, Paul Singh, whether at the coffee shop or giving a talk or speaking
with attendees afterwards, was _present_. He was there with each person in each
moment. When I confronted him about his persona and charisma, he mentioned a
book, [The Charisma Myth](http://www.amazon.com/The-Charisma-Myth-Personal-Magnetism/dp/1591845947),
which I of course purchased soon thereafter. This book explained, broke down and
reinforced principles of interactions with others that had been taught to me in
my youth, but behind which I had never fully understood the "why". While the
book is a gold mine of information, there is a very large emphasis, with regard
to exuding charisma, on presence. In short, **if you are distracted and not
paying attention to someone you are with, this person will consciously or
unconsciously believe that they are not important enough for your attention and
will thus likely stop seeking to be in your presence simply because of the way
you make them feel.**

Think about that.

How many times have you been distracted by something, not just devices, when you
have been with someone? How many times have you not answered their questions
because something your mind deemed more important grabbed your attention? You
may not be able to recall these instances, for they mean nothing to you. But now
that you have read this far, you will undoubtedly begin to notice _others_
acting this way towards you. Don't worry, for seeing negative habits in others
is the first step to changing your own.

## You Might Be Distracted If...

* you are sitting at the dinner table with your phone out
* you are walking down the street with someone or a group with your phone out
* you are making love and answer the phone
* you are at a sporting event and Facebook just can't wait to know about how
  great your day is going
* you ever have your phone/ipad/smart watch/digital dingus in hand while you are
  with another human being

## Kids These Days

Most folks these days know not what they do. The younger generation doesn't know
a life without phonepads, and the older generation didn't know to ubiquitously
enforce an etiquette around them. I believe there will eventually be a pendulum
swing away from the current state of device affairs where mobile device
etiquette becomes a standard, and considerations for this will continue to show
up in new device features.

In the mean time, an interesting "game" has popped up among 20-somethings where
everyone at dinner places their phones in the middle of the table, one on top of
another. If anyone retrieves their phone during dinner, that person must then
pick up the tab. Gamification... who would have thought? This is a great start.

## So What Can You Do?

### Step 1: Catch It

If you have to ask yourself,

> _&quot;Is it appropriate to take out my phone?&quot;_

then the answer is probably no.

### Step 2: Don't Be A Jerk

When your friends are all tweeting about how much fun they're having during your
birthday party at the pub, be careful with bringing attention to the subject.
Not only will they be ashamed when they realize you are right, but they will
also resent you for calling them out. However, being passive aggressive and
hinting at their poor manners isn't the answer, either.

It is said that when you point at someone, you're pointing three fingers back at
yourself. Instead, focus on making yourself better rather than being quick to
judge others.

### Step 3: Set the Example

When you go to hang out with your little cousins or when you fly to give a talk
to a group of strangers, turn your phone on silent (or Airplane Mode) and either
keep it in your pocket at all times or even leave it in the car. If you have a
necessary business meeting, plan it accordingly and if you must, take the call
outside. Remember that every single person you come in to contact with is
affected by the actions you take and the way you make them feel while they
interact with you. Set the example and pass on good habits.
