---
author: "Robert Pearce"
authorTwitter: "@RobertWPearce"
desc: "You can work remotely, too! Here's how."
keywords: "remote working, remote work, digital nomad, traveling while working, travel, telecommuting"
title: "On Working Remotely"
---

Do you have a remote/virtual/telecommute job? I do. And it rocks.

A vast majority of the people in the States who inquire as to the nature of my
job share with me that they feel working remotely would make them feel isolated;
that they would lose their sense of team; that they would get bored.

## Boredom? Nope

Someone once said to me,

> _&quot;Only boring people get bored.&quot;_

Let that sink in for a second. Let yourself recognize that you might just be boring.
While you think about it, read this introduction on boredom from Wikipedia:

> _&quot;Boredom is an emotional state experienced when an individual is left
> without anything in particular to do, and not interested in their
> surroundings.&quot;_

Comma usage aside, this says _a lot_ about people who get bored. If you have
nothing in particular to do, well, that's great, but odds are that you do not
have a family or are not contributing to humanity (there's much to do here).
Your choice. I would like to focus on the second point: _&quot;and not
interested in their surroundings.&quot;_

Working remotely allows you to work from wherever you want, given you can
accomplish your work goals. It doesn't matter if you are an accountant, human
resource associate, technology professional or doctor. Thanks to the present-day
methods of communication, knowledge and data can be transferred in any number of
ways. Many remote workers choose to do their work from the comfort of their
homes where they can be nearer to family and friends and not waste their lives
away in commuter traffic. Others move to new locations as they please.
Regardless of what these people choose, one fact remains: _they can go wherever
they want,_ or in another light, _have an infinite opportunity for new,
interesting surroundings_. If they were boring before, they now have the freedom
to never be bored again.

## Isolated? No sense of team? Nope

Now that we've addressed the boredom fear, let's focus on the isolation and
loss-of-team mentality.

I write software. You might associate this with sitting in a dark room, chugging
Coca-Cola, solving complex problems with microwavable fish sticks and living in
solitude. You wouldn't be wrong about the fish sticks. But solitude? Can you say
that you spend six hours at work speaking with anywhere from 1 to 14 people at a
time? Physically, I might not be in the same room as someone, but by the end of
the day I am exhausted from the sheer amount of conversation and problem solving
I have with my colleagues. I just don't have to smell them.

## How I Am Living

One of the attractions to the job I'm working now is that the company,
[Articulate](http://www.articulate.com "Articulate"), has no office and is
completely virtual. I recently learned that it is the **2nd largest virtual
company in the world**. This means that I have the guidance of an entire company
of remote workers. What sort of guidance do they offer?

> _&quot;Live your life, and do not waste the opportunities and time you
> have.&quot;_

So I packed a bag and moved to London. I travel to different areas of town ~4-5
days a week, find wifi, do my work, explore, meet people, go find another place
to work and then go exercise at an outdoor gym. Oh, and I've been to Berlin and
have Spain, Scotland and Ireland all coming up in the next 1.5 months. And I
just got back from five days in Miami.

I am of the (generally agreed upon scientific) opinion that I shall not live
forever, so I'll be damned if I regret one day.

## Not sure where to start?

There is a program starting next year, [Remote
Year](http://www.remoteyear.com "Remote Year"), that involves ~100 remote
workers traveling to cities around the world for 2-5 weeks at a time. In each
city they will be working, exploring, absorbing the culture and then moving on
to the next city. I will be applying, and if you manage to find/have a remote
job, so should you.

Trust me; you won't get bored.
