module.exports = {
  root: true,
  env: { es6: true, node: true },
  parser: '@typescript-eslint/parser',
  parserOptions: {
    ecmaVersion: 2020,
    sourceType: 'module',
    project: './tsconfig.eslint.json',
  },
  plugins: ['import', 'prettier'],
  extends: [
    'airbnb-typescript/base',
    'plugin:@typescript-eslint/recommended',
    'plugin:@typescript-eslint/recommended-requiring-type-checking',
  ],
  settings: {
    'import/parsers': {
      '@typescript-eslint/parser': ['.ts', '.tsx'],
    },
  },
  globals: {
    $log: false,
    $info: false,
    $option: false,
    $http: false,
    $file: false,
    $data: false,
  },
  rules: {
    'no-var': 'off',
    'vars-on-top': 'off',
    'prefer-const': 'off',
    'no-return-assign': 'off',
    'consistent-return': 'off',
    'prefer-destructuring': 'off',
    'no-underscore-dangle': 'off',
    'object-curly-newline': 'off',
    // 'import/no-unresolved': 'error',
    'import/no-mutable-exports': 'off',
    'import/prefer-default-export': 'off',
    'import/no-extraneous-dependencies': 'off',
    'import/no-named-as-default-member': 'off',
    'no-console': process.env.NODE_ENV === 'production' ? 'error' : 'off',
    'max-len': ['error', { ignoreComments: true, code: 120, ignoreStrings: true }],
    '@typescript-eslint/require-await': 'off',
    '@typescript-eslint/no-unsafe-call': 'off',
    '@typescript-eslint/no-explicit-any': 'off',
    '@typescript-eslint/no-var-requires': 'off',
    '@typescript-eslint/no-unsafe-return': 'off',
    '@typescript-eslint/no-throw-literal': 'off',
    '@typescript-eslint/naming-convention': 'off',
    '@typescript-eslint/no-floating-promises': 'off',
    '@typescript-eslint/no-unsafe-assignment': 'off',
    '@typescript-eslint/no-unsafe-member-access': 'off',
    '@typescript-eslint/restrict-template-expressions': 'off',
    '@typescript-eslint/explicit-module-boundary-types': 'off',
    '@typescript-eslint/quotes': ['error', 'single', { allowTemplateLiterals: true }],
  },
};
