# 主从挂了怎么办？哨兵机制保驾护航！

![](https://cdn.jsdelivr.net/gh/rongweihe/ImageHost01/redis0700.png)

# 核心知识点提炼

## 1、主库挂了之后带来的问题

- 主库真的挂了吗？
- 该选择哪个从库作为主库？
- 怎么把新主库的相关信息通知给从库和客户端呢？

## 2、哨兵机制

Redis 主从集群中，哨兵机制是实现主从库自动切换的关键机制，它有效解决了上面三个问题。

哨兵的三个主要任务：

![](https://cdn.jsdelivr.net/gh/rongweihe/ImageHost01/redis0701.png)

- 监控：包含主观下线和客观下线。

  主观下线：通过 PING 命令来判断是否超时。

  客观下线：当有 N 个哨兵实例时，最好有 N/2 +1 个实例判断主库为下线。

  ![](https://cdn.jsdelivr.net/gh/rongweihe/ImageHost01/redis0702.png)

- 选主

  筛选：除了要检查从库的在线状态，还要检查它之前的网络状态。

  打分：三个规则依次打分：

  - 从库优先级最高。
  - 和旧主库同步复制程度最接近的（从库的slave_repl_offset设置）。

  - 如果前两个相同，选择 ID 最小的。

- 通知

# 总结

哨兵机制，它是实现 Redis 不间断服务的重要保证。

具体来说， 主从集群的数据同步，是数据可靠的基础保证；而在主库发生故障时，自动的主从切换是服务不间断的关键支撑。

Redis 的哨兵机制自动完成了以下三大功能，从而实现了主从库的自动切换，可以降低 Redis 集群的运维开销：

- **监控主库运行状态，并判断主库是否客观下线；** 
- **在主库客观下线后，选取新主库；** 
- **选出新主库后，通知从库和客户端。**

为了降低误判率，在实际应用时，哨兵机制通常采用多实例的方式进行部署，多个哨兵实 例通过“少数服从多数”的原则，来判断主库是否客观下线。

一般来说，我们可以部署三个哨兵，如果有两个哨兵认定主库“主观下线”，就可以开始切换过程。当然，如果你希 望进一步提升判断准确率，也可以再适当增加哨兵个数，比如说使用五个哨兵。 

但是，使用多个哨兵实例来降低误判率，其实相当于组成了一个哨兵集群，会因此面临着一些新的挑战，例如

- 哨兵集群中有实例挂了，怎么办，会影响主库状态判断和选主吗？ 
- 哨兵集群多数实例达成共识，判断出主库“客观下线”后，由哪个实例来执行主从切换呢？

下次分享我们在讨论。

