#  内存快照：宕机后，Redis如何实现快速恢复？

![](https://cdn.jsdelivr.net/gh/rongweihe/ImageHost01/redis0500.png)



## 总结

本节学习了 Redis 用于避免丢失的内存快照方法。

这个方法的优势在于，可以快速的恢复数据库，也就是只需要把 RDB 文件直接读入内存，这就避免了 AOF 文件需要顺序的执行命令带来的低效能问题。

不过，内存快照也有它的局限性。它拍的是一张内存的“大合影”，不可避免地会耗时耗 力。虽然，Redis 设计了 bgsave 和写时复制方式，尽可能减少了内存快照对正常读写的 影响，但是，频繁快照仍然是不太能接受的。而混合使用 RDB 和 AOF，正好可以取两者 之长，避两者之短，以较小的性能开销保证数据可靠性和性能。

### 最后，关于 AOF 和 RDB 的选择问题，有三点建议

数据不能丢失时，内存快照和 AOF 的混合使用是一个很好的选择；

如果允许分钟级别的数据丢失，可以只使用 RDB；

如果只用 AOF，优先使用 everysec 的配置选项，因为它在可靠性和性能之间取了一个平衡

参考：《极客时间-Redis核心技术和实战》