# AOF日志：宕机了，Redis如何避免数据丢失？

![](https://cdn.jsdelivr.net/gh/rongweihe/ImageHost01/redis0400.png)



# 总结

 Redis 用于避免数据丢失的 AOF 方法。

这个方法通过逐一记录操作命令，在恢复时再逐一执行命令的方式，保证了数据的可靠性。 

这个方法看似“简单”，但也是充分考虑了对 Redis 性能的影响。

总结来说，它提供了 AOF 日志的三种写回策略，分别是 Always、Everysec 和 No，这三种策略在可靠性上是 从高到低，而在性能上则是从低到高。 

此外，为了避免日志文件过大，Redis 还提供了 AOF 重写机制，直接根据数据库里数据的 最新状态，生成这些数据的插入命令，作为新日志。

这个过程通过后台线程完成，避免了对主线程的阻塞。 

其中，三种写回策略体现了系统设计中的一个重要原则 ，即 trade-off，或者称为“取 舍”，指的就是在性能和可靠性保证之间做取舍。

trade-off 这是做系统设计和开发的一个 关键哲学。

可能你也注意到了，落盘时机和重写机制都是在“记日志”这一过程中发挥作用的。

例如，落盘时机的选择可以避免记日志时阻塞主线程，重写可以避免日志文件过大。 但是，在“用日志”的过程中，也就是使用 AOF 进行故障恢复时，我们仍然需要把所有的 操作记录都运行一遍。再加上 Redis 的单线程设计，这些命令操作只能一条一条按顺序执 行，这个“重放”的过程就会很慢了。

参考：《极客时间-Redis核心技术和实战》