/**
 * 项目初始化
 */
const chalk = require("chalk");
class AppBootHook {
  constructor(app) {
    this.app = app;
  }

  async willReady() {
    // force 为 true 时,系统每次启动都会删除之前所有数据表,重新建表(类似删库)
    // force 为 false 时,系统缺失数据表的时候会自动创建, 比如在/app/model/ 下新建一个模型时,系统运行会自动创建这个模型的数据表
    await this.app.model
      .sync({ force: false })
      .then(async (res) => {
        console.log(
          chalk.green(`
\\\\ \\\\ \\\\ \\\\ \\\\ \\\\ \\\\ \\\\ || || || || || || // // // // // // // //
\\\\\\ \\\\ \\\\ \\\\          o8888888o            // // // // // //
\\\\ \\\\ \\\\ \\\\ \\\\             88" . "88               // // // // //
\\\\ \\\\ \\\\ \\\\                (| -_- |)                  // // // //
\\\\ \\\\ \\\\                   O\\  =  /O                     // // //
\\\\ \\\\                   ____/\`---'\\____                     // //
\\\\                    .' \ \\\\ \\\\ \\\\ \\\\ \\\\ \\\\        _ooOoo_          // // // // // // //
\\\\ \\\\ \ \\\\|     |//  \`.                      //
==                   /  \\\\|||  :  |||//  \\                     ==
==                  /  _||||| -:- |||||-  \\                    ==
==                  |   | \\\\\\  -  /// |   |                    ==
==                  | \\_|  ''\\---/''  |   |                    ==
==                  \\  .-\\__  \`-\`  ___/-. /                    ==
==                ___\`. .'  /--.--\\  \`. . ___                  ==
==              ."" '<  \`.___\\_<|>_/___.'  >'"".               ==
==            | | :  \`- \\\`.;\`\\ _ /\`;.\`/ - \` : | |              \\\\
//            \\  \\ \`-.   \\_ __\\ /__ _/   .-\` /  /              \\\\
//      ========\`-.____\`-.___\\_____/___.-\`____.-'========      \\\\
//                           \`=---='                           \\\\
// //   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^  \\\\ \\\\
// //  /    佛祖保佑      永无BUG      永不修改        \\\\ \\\\ \\\\
// // // // // // || || || || || || || || || || \\\\ \\\\ \\\\ \\\\ \\\\ \\\\
            `)
        );
      })
      .catch((err) => {
        console.log(chalk.red("========== 系统表创建失败 =========="));
        console.log(chalk.red(err));
        console.log(
          chalk.red(`
 * _ooOoo_
 * o8888888o
 * 88" . "88
 * (| -_- |)
 *  O\\ = /O
 * ___/\`---'\\____
 * .   ' \\\\| |// \`.
 * / \\\\||| : |||// \\
 * / _||||| -:- |||||- \\
 * | | \\\\\\ - /// | |
 * | \\_| ''\\---/'' | |
 * \\ .-\\__ \`-\` ___/-. /
 * ___\`. .' /--.--\\ \`. . __
 * ."" '< \`.___\\_<|>_/___.' >'"".
 * | | : \`- \\\`.;\`\\ _ /\`;.\`/ - \` : | |
 * \\ \\ \`-. \\_ __\\ /__ _/ .-\` / /
 * ======\`-.____\`-.___\\_____/___.-\`____.-'======
 * \`=---='
 *          .............................................
 *           佛曰：bug泛滥，我已瘫痪！

                        `)
        );
      });
  }


}

module.exports = AppBootHook;
