# Gramateria - v1.0.6 

Gramateria a drag and drop web builder which is built with GrapesJS but with a different look, blocks and components. And v1.0.6 is using Bootstrap 5, can generate a Desktop app with ElectronJS and can deploy to Netlify.

[DEMO](https://gramateria.netlify.app)

<img src="https://res.cloudinary.com/dpnea22ek/image/upload/w_1400/v1627100771/gramateria.jpg" />

----

Gramateria v1.0.6 is a re-rewritten version that changed many features and code.

> Although I have stopped developing this app for a while, there are still many users and I feel a little bad because of my old/dirty codes. So I decided to refactor the codes and add some features to be more useful for developers and non-developers in this v1.0.6.


## Installation 

```npm install```

```npm start```

## Development
#### Compile sources

```npm run dev```

```npm run watch```

```npm run prod```


## Build desktop app

```npm run pack```

Check `export` folder after running `npm run pack` command. 

----

### v1.0.6 Change logs

- Change electron-packager to electron-builder
- Change Materialize CSS to Bootstrap 5
- Upgrade Grapesjs to v0.17.19 (latest version)
- Added Nelify deployment
- Messy codes to modular code
- Added laravel mix for script compling 
- Added new blocks
- Add Notyf for toast messages
- Remove Gapesjs export plugin 
- Remove dashboard version in v1.0.4 which was built with vue.js, element UI and firebase. [reason of removing dashboard](#remove-message)


#### Reason of removing dashboard
<a name="remove-message"></a>
Because making Gramateria to compatible with Vue, ElementUI and Firebase versions is not an easy task for me. And I want to keep Gramateria as a desktop based app.

#### Roadmap
- Add more blocks
- Change icons for section blocks
- Make it available for linux and window. 
- Add more SEO tags
- Build multiple pages 
- Improve UI

### Credits
- Grapesjs [Grapes JS](https://www.grapesjs.com/ "Grapes Js")
- Bootstrap 5 [Bootstrap 5](https://www.getbootstrap.com/ "Bootstrap 5")
- Electron JS [Electron JS](https//www.electronjs.org/ "Electron Js")

Show your support by 🌟 the project, thanks.

----

[Buy Me a coffee](https://www.buymeacoffee.com/ronaldaug)
